/*
 * Decompiled with CFR 0.152.
 */
package de.themoep.entitydetection;

import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.Server;
import org.bukkit.World;

public class ChunkLocation {
    private final String world;
    private final int x;
    private final int z;

    public ChunkLocation(Location location) {
        this.world = location.getWorld().getName().toLowerCase();
        this.x = (int)Math.floor(location.getX() / 16.0);
        this.z = (int)Math.floor(location.getZ() / 16.0);
    }

    public String getWorld() {
        return this.world;
    }

    public int getX() {
        return this.x;
    }

    public int getZ() {
        return this.z;
    }

    public String toString() {
        return this.x + ", " + this.z + ": " + this.world;
    }

    public Chunk toBukkit(Server server) {
        World world = server.getWorld(this.getWorld());
        if (world == null) {
            throw new IllegalArgumentException("No world with the name " + this.getWorld() + " found on the server for this chunk entry?");
        }
        return world.getChunkAt(this.x, this.z);
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public boolean equals(Object o) {
        if (!(o instanceof ChunkLocation)) {
            return false;
        }
        if (o == this) {
            return true;
        }
        ChunkLocation other = (ChunkLocation)o;
        return this.x == other.x && this.z == other.z && this.world.equalsIgnoreCase(other.world);
    }
}

