/*
 * Decompiled with CFR 0.152.
 */
package de.themoep.connectorplugin.limbo.connector;

import com.google.common.io.ByteArrayDataInput;
import com.google.common.io.ByteArrayDataOutput;
import com.google.common.io.ByteStreams;
import com.loohp.limbo.events.EventHandler;
import com.loohp.limbo.events.Listener;
import com.loohp.limbo.events.player.PlayerJoinEvent;
import com.loohp.limbo.events.player.PluginMessageEvent;
import com.loohp.limbo.player.Player;
import com.loohp.limbo.plugins.LimboPlugin;
import de.themoep.connectorplugin.connector.Message;
import de.themoep.connectorplugin.connector.VersionMismatchException;
import de.themoep.connectorplugin.limbo.LimboConnectorPlugin;
import de.themoep.connectorplugin.limbo.connector.LimboConnector;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.Deque;
import net.kyori.adventure.key.Key;

public class PluginMessageConnector
extends LimboConnector
implements Listener {
    public static final String CHANNEL_NAME = "bungeecord:main";
    public static final Key CHANNEL_KEY = Key.key((String)"bungeecord:main");
    private final Deque<byte[]> queue = new ArrayDeque<byte[]>();

    public PluginMessageConnector(LimboConnectorPlugin plugin) {
        super(plugin, true);
        plugin.getLimbo().getEventsManager().registerEvents((LimboPlugin)plugin, (Listener)this);
    }

    @EventHandler
    public void onPluginMessage(PluginMessageEvent event) {
        if (event.getChannel().equals(CHANNEL_NAME)) {
            ByteArrayDataInput in = ByteStreams.newDataInput((byte[])event.getData());
            String subChannel = in.readUTF();
            if (!"ConnectorPlugin".equals(subChannel)) {
                return;
            }
            try {
                Message message = Message.fromByteArray((String)((LimboConnectorPlugin)this.plugin).getGroup(((LimboConnectorPlugin)this.plugin).getName()), (byte[])in.readUTF().getBytes());
                this.handle(event.getPlayer(), message);
            }
            catch (VersionMismatchException e) {
                ((LimboConnectorPlugin)this.plugin).logError("Error while handling plugin message from " + event.getPlayer().getName(), e);
            }
        }
    }

    @Override
    protected void sendDataImplementation(String targetData, Message message) {
        ByteArrayDataOutput out = ByteStreams.newDataOutput();
        out.writeUTF("Forward");
        out.writeUTF(targetData.startsWith("server:") ? targetData.substring("server:".length()) : "ALL");
        out.writeUTF("ConnectorPlugin");
        byte[] messageBytes = message.writeToByteArray();
        out.writeShort(messageBytes.length);
        out.write(messageBytes);
        byte[] data = out.toByteArray();
        if (!((LimboConnectorPlugin)this.plugin).getLimbo().getPlayers().isEmpty()) {
            try {
                ((Player)((LimboConnectorPlugin)this.plugin).getLimbo().getPlayers().iterator().next()).sendPluginMessage(CHANNEL_KEY, data);
            }
            catch (IOException e) {
                ((LimboConnectorPlugin)this.plugin).logError("Error while sending plugin message", e);
            }
        } else {
            this.queue.add(data);
        }
    }

    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent event) {
        while (!this.queue.isEmpty()) {
            try {
                event.getPlayer().sendPluginMessage(CHANNEL_KEY, this.queue.remove());
            }
            catch (IOException e) {
                ((LimboConnectorPlugin)this.plugin).logError("Error while sending queued plugin message", e);
            }
        }
    }
}

