/*
 * Decompiled with CFR 0.152.
 */
package de.themoep.connectorplugin.limbo.commands;

import com.loohp.limbo.Limbo;
import com.loohp.limbo.commands.CommandSender;
import com.loohp.limbo.player.Player;
import de.themoep.connectorplugin.limbo.commands.ConnectorCommand;
import de.themoep.connectorplugin.limbo.commands.SubCommand;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;

public class TeleportToPlayerCommand
extends SubCommand {
    public TeleportToPlayerCommand(ConnectorCommand parent) {
        super(parent.getPlugin(), parent, "teleporttoplayer <player> [<target>]", parent.getPermission() + ".teleporttoplayer", "teleportplayer");
    }

    @Override
    public void execute(CommandSender sender, String[] args) {
        String targetName;
        String playerName;
        if (args.length == 1 && sender instanceof Player) {
            playerName = sender.getName();
            targetName = args[0];
        } else if (args.length == 2) {
            playerName = args[0];
            targetName = args[1];
        } else {
            sender.sendMessage("Usage: /" + this.getFullUsage());
            return;
        }
        Consumer[] consumerArray = new Consumer[1];
        consumerArray[0] = arg_0 -> ((CommandSender)sender).sendMessage(arg_0);
        this.plugin.getBridge().teleport(playerName, targetName, consumerArray).thenAccept(success -> {
            if (success.booleanValue()) {
                sender.sendMessage("Successfully teleported " + playerName + " to " + targetName);
            } else {
                sender.sendMessage("Error while teleporting " + playerName + " to " + targetName);
            }
        });
    }

    @Override
    public List<String> tabComplete(CommandSender sender, String[] args) {
        if (args.length == 1 || args.length == 2) {
            return Limbo.getInstance().getPlayers().stream().map(Player::getName).filter(name -> name.toLowerCase().startsWith(args[args.length - 1].toLowerCase())).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }
}

