/*
 * Decompiled with CFR 0.152.
 */
package de.themoep.connectorplugin.limbo.commands;

import com.loohp.limbo.Limbo;
import com.loohp.limbo.commands.CommandSender;
import com.loohp.limbo.player.Player;
import de.themoep.connectorplugin.LocationInfo;
import de.themoep.connectorplugin.limbo.commands.ConnectorCommand;
import de.themoep.connectorplugin.limbo.commands.SubCommand;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;

public class TeleportCommand
extends SubCommand {
    public TeleportCommand(ConnectorCommand parent) {
        super(parent.getPlugin(), parent, "teleport <player> <server> [<world> <x> <y> <z> [<yaw> <pitch>]]", parent.getPermission() + ".teleport", "tp", "send");
    }

    @Override
    public void execute(CommandSender sender, String[] args) {
        if (args.length < 2) {
            sender.sendMessage("Usage: /" + this.getFullUsage());
            return;
        }
        String playerName = args[0];
        String serverName = args[1];
        if (args.length == 2) {
            Consumer[] consumerArray = new Consumer[1];
            consumerArray[0] = arg_0 -> ((CommandSender)sender).sendMessage(arg_0);
            this.plugin.getBridge().sendToServer(playerName, serverName, consumerArray).thenAccept(success -> {
                if (success.booleanValue()) {
                    sender.sendMessage("Successfully sent " + playerName + " to " + serverName);
                } else {
                    sender.sendMessage("Error while sending " + playerName + " to " + serverName);
                }
            });
            return;
        }
        if (args.length == 3) {
            Consumer[] consumerArray = new Consumer[1];
            consumerArray[0] = arg_0 -> ((CommandSender)sender).sendMessage(arg_0);
            this.plugin.getBridge().teleport(playerName, serverName, args[2], consumerArray).thenAccept(success -> {
                if (success.booleanValue()) {
                    sender.sendMessage("Successfully teleported " + playerName + " to " + args[2] + " on " + serverName);
                } else {
                    sender.sendMessage("Error while teleporting " + playerName + " to " + args[2] + " on " + serverName);
                }
            });
            return;
        }
        if (args.length < 6) {
            sender.sendMessage("Usage: /" + this.getFullUsage());
            return;
        }
        try {
            LocationInfo location = new LocationInfo(serverName, args[2], Double.parseDouble(args[3]), Double.parseDouble(args[4]), Double.parseDouble(args[5]), args.length > 6 ? Float.parseFloat(args[6]) : 0.0f, args.length > 7 ? Float.parseFloat(args[7]) : 0.0f);
            Consumer[] consumerArray = new Consumer[1];
            consumerArray[0] = arg_0 -> ((CommandSender)sender).sendMessage(arg_0);
            this.plugin.getBridge().teleport(playerName, location, consumerArray).thenAccept(success -> {
                if (success.booleanValue()) {
                    sender.sendMessage("Successfully teleported " + playerName + " to " + location.getServer() + " at " + location.getWorld() + " " + location.getX() + " " + location.getY() + " " + location.getZ());
                } else {
                    sender.sendMessage("Error while teleporting " + playerName);
                }
            });
        }
        catch (IllegalArgumentException e) {
            sender.sendMessage("Invalid number format for coordinates/rotation!");
        }
    }

    @Override
    public List<String> tabComplete(CommandSender sender, String[] args) {
        if (args.length == 1) {
            return Limbo.getInstance().getPlayers().stream().map(Player::getName).filter(name -> name.toLowerCase().startsWith(args[0].toLowerCase())).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }
}

