/*
 * Decompiled with CFR 0.152.
 */
package de.themoep.connectorplugin.limbo.commands;

import com.loohp.limbo.commands.CommandExecutor;
import com.loohp.limbo.commands.CommandSender;
import com.loohp.limbo.commands.TabCompletor;
import de.themoep.connectorplugin.limbo.LimboConnectorPlugin;
import de.themoep.connectorplugin.limbo.commands.ConnectorCommand;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public abstract class SubCommand
implements CommandExecutor,
TabCompletor {
    protected final LimboConnectorPlugin plugin;
    private final String name;
    private final String usage;
    private final String permission;
    private final Collection<String> aliases;
    private final ConnectorCommand parent;
    private Map<String, SubCommand> subCommands = new LinkedHashMap<String, SubCommand>();
    private Map<String, SubCommand> subCommandAliases = new LinkedHashMap<String, SubCommand>();
    private List<String> subCommandPermissions = new ArrayList<String>();

    public SubCommand(LimboConnectorPlugin plugin, String usage, String permission, String ... aliases) {
        this(plugin, (ConnectorCommand)null, usage, permission, aliases);
    }

    public SubCommand(LimboConnectorPlugin plugin, ConnectorCommand parent, String usage, String permission, String ... aliases) {
        this.plugin = plugin;
        this.parent = parent;
        String[] usageParts = usage.split(" ", 2);
        this.name = usageParts[0];
        this.usage = usageParts.length > 1 ? usageParts[1] : "";
        this.permission = permission;
        this.aliases = new ArrayList<String>();
        this.aliases.add(this.name);
        Collections.addAll(this.aliases, aliases);
    }

    public void registerSubCommand(SubCommand subCommand) {
        this.subCommands.put(subCommand.getName().toLowerCase(Locale.ROOT), subCommand);
        this.subCommandPermissions.add(subCommand.getPermission());
        for (String alias : subCommand.getAliases()) {
            this.subCommandAliases.put(alias.toLowerCase(Locale.ROOT), subCommand);
        }
    }

    public SubCommand getSubCommand(String name) {
        SubCommand subCommand = this.subCommands.get(name.toLowerCase(Locale.ROOT));
        if (subCommand == null) {
            subCommand = this.subCommandAliases.get(name.toLowerCase(Locale.ROOT));
        }
        return subCommand;
    }

    public void execute(CommandSender sender, String[] args) {
        if (args.length == 0) {
            return;
        }
        if (!args[0].equalsIgnoreCase(this.name) && !this.aliases.contains(args[0].toLowerCase(Locale.ROOT))) {
            return;
        }
        if (args.length == 1) {
            sender.sendMessage("Usage: /" + this.getFullUsage());
            return;
        }
        SubCommand subCommand = this.getSubCommand(args[1]);
        if (subCommand != null) {
            if (subCommand.getPermission() != null && !sender.hasPermission(subCommand.getPermission())) {
                sender.sendMessage("You do not have permission to use that command!");
                return;
            }
            subCommand.execute(sender, Arrays.copyOfRange(args, 2, args.length));
            return;
        }
    }

    public List<String> tabComplete(CommandSender sender, String[] args) {
        SubCommand subCommand;
        ArrayList<String> tab = new ArrayList<String>();
        for (Map.Entry<String, SubCommand> entry : this.subCommands.entrySet()) {
            if (!sender.hasPermission(entry.getValue().getPermission())) continue;
            tab.add(entry.getValue().getName());
        }
        if (tab.isEmpty()) {
            return Collections.emptyList();
        }
        if (args.length == 0) {
            tab.clear();
            tab.add(this.getName());
        }
        if (args.length > 0 && !args[0].equalsIgnoreCase(this.getName())) {
            return Collections.emptyList();
        }
        if (args.length > 1 && (subCommand = this.getSubCommand(args[1])) != null) {
            if (subCommand.getPermission() != null && !sender.hasPermission(subCommand.getPermission())) {
                return Collections.emptyList();
            }
            return subCommand.tabComplete(sender, Arrays.copyOfRange(args, 2, args.length));
        }
        return tab;
    }

    public String getName() {
        return this.name;
    }

    public String getUsage() {
        return this.name + " " + this.usage;
    }

    public String getFullUsage() {
        if (this.parent != null) {
            return this.parent.getName() + " " + this.getUsage();
        }
        return this.getUsage();
    }

    public String getPermission() {
        return this.permission;
    }

    public Collection<String> getAliases() {
        return this.aliases;
    }

    public LimboConnectorPlugin getPlugin() {
        return this.plugin;
    }

    public Map<String, SubCommand> getSubCommands() {
        return this.subCommands;
    }
}

