/*
 * Decompiled with CFR 0.152.
 */
package de.themoep.connectorplugin.limbo.commands;

import com.loohp.limbo.commands.CommandSender;
import de.themoep.connectorplugin.limbo.commands.ConnectorCommand;
import de.themoep.connectorplugin.limbo.commands.SubCommand;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;

public class ServerConsoleCommand
extends SubCommand {
    public ServerConsoleCommand(ConnectorCommand parent) {
        super(parent.getPlugin(), parent, "servercommand <servername|p:player> <command...>", parent.getPermission() + ".servercommand", "serverconsole", "serverconsolecommand", "server", "scc");
    }

    @Override
    public void execute(CommandSender sender, String[] args) {
        if (args.length < 2) {
            sender.sendMessage("Usage: /" + this.getFullUsage());
            return;
        }
        String serverName = args[0];
        String commandString = Arrays.stream(args).skip(1L).collect(Collectors.joining(" "));
        sender.sendMessage("Executing '" + commandString + "' on server '" + serverName + "'");
        Consumer[] consumerArray = new Consumer[1];
        consumerArray[0] = arg_0 -> ((CommandSender)sender).sendMessage(arg_0);
        this.plugin.getBridge().runServerConsoleCommand(serverName, commandString, consumerArray).thenAccept(success -> sender.sendMessage(success != false ? "Successfully executed command!" : "Error while executing the command."));
    }

    @Override
    public List<String> tabComplete(CommandSender sender, String[] args) {
        return Collections.emptyList();
    }
}

