/*
 * Decompiled with CFR 0.152.
 */
package de.themoep.connectorplugin.limbo.commands;

import com.loohp.limbo.Limbo;
import com.loohp.limbo.commands.CommandSender;
import com.loohp.limbo.player.Player;
import de.themoep.connectorplugin.limbo.commands.ConnectorCommand;
import de.themoep.connectorplugin.limbo.commands.SubCommand;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

public class ProxyPlayerCommand
extends SubCommand {
    public ProxyPlayerCommand(ConnectorCommand parent) {
        super(parent.getPlugin(), parent, "proxyplayercommand <playername> <command...>", parent.getPermission() + ".proxyplayercommand", "proxyplayer", "player", "ppc");
    }

    @Override
    public void execute(CommandSender sender, String[] args) {
        if (args.length < 2) {
            sender.sendMessage("Usage: /" + this.getFullUsage());
            return;
        }
        Player player = Limbo.getInstance().getPlayer(args[0]);
        if (player == null) {
            sender.sendMessage("No player with the name " + args[0] + " is online on this server!");
            return;
        }
        String commandString = Arrays.stream(args).skip(1L).collect(Collectors.joining(" "));
        sender.sendMessage("Executing '" + commandString + "' on the proxy for player '" + player.getName() + "'");
        this.plugin.getBridge().runProxyPlayerCommand(player, commandString).thenAccept(success -> sender.sendMessage(success != false ? "Successfully executed command!" : "Error while executing the command."));
    }

    @Override
    public List<String> tabComplete(CommandSender sender, String[] args) {
        if (args.length == 1) {
            return Limbo.getInstance().getPlayers().stream().map(Player::getName).filter(name -> name.toLowerCase().startsWith(args[0].toLowerCase())).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }
}

