/*
 * Decompiled with CFR 0.152.
 */
package de.themoep.connectorplugin.limbo;

import com.loohp.limbo.Limbo;
import com.loohp.limbo.commands.CommandExecutor;
import com.loohp.limbo.events.EventHandler;
import com.loohp.limbo.events.Listener;
import com.loohp.limbo.events.player.PlayerQuitEvent;
import com.loohp.limbo.file.FileConfiguration;
import com.loohp.limbo.player.Player;
import com.loohp.limbo.plugins.LimboPlugin;
import com.loohp.limbo.scheduler.LimboTask;
import de.themoep.connectorplugin.ConnectorPlugin;
import de.themoep.connectorplugin.connector.Connector;
import de.themoep.connectorplugin.connector.MessageTarget;
import de.themoep.connectorplugin.limbo.Bridge;
import de.themoep.connectorplugin.limbo.commands.ConnectorCommand;
import de.themoep.connectorplugin.limbo.connector.LimboConnector;
import de.themoep.connectorplugin.limbo.connector.MqttConnector;
import de.themoep.connectorplugin.limbo.connector.PluginMessageConnector;
import de.themoep.connectorplugin.limbo.connector.RedisConnector;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public class LimboConnectorPlugin
extends LimboPlugin
implements ConnectorPlugin<Player>,
Listener {
    private LimboConnector connector;
    private Bridge bridge;
    private boolean debug = true;
    private String globalGroup;
    private Map<String, String> pluginGroups;
    private String serverName;
    private FileConfiguration config;

    public void onEnable() {
        String messengerType;
        File configFile = new File(this.getDataFolder(), "limbo-config.yml");
        if (!configFile.exists()) {
            this.getDataFolder().mkdirs();
            try (InputStream in = this.getResourceAsStream("limbo-config.yml");){
                if (in != null) {
                    Files.copy(in, configFile.toPath(), new CopyOption[0]);
                } else {
                    configFile.createNewFile();
                }
            }
            catch (IOException e) {
                this.logError("Could not create default config!", e);
                return;
            }
        }
        try {
            this.config = new FileConfiguration(configFile);
        }
        catch (IOException e) {
            this.logError("Error while loading config file " + configFile.getAbsolutePath(), e);
            return;
        }
        this.debug = this.config.get("debug", Boolean.class) != null ? (Boolean)this.config.get("debug", Boolean.class) : true;
        this.globalGroup = this.config.get("group", String.class) != null ? (String)this.config.get("group", String.class) : "global";
        this.pluginGroups = new HashMap<String, String>();
        this.serverName = (String)this.config.get("server-name", String.class);
        if (this.serverName == null || "changeme".equals(this.serverName)) {
            this.serverName = new File(".").getAbsoluteFile().getParentFile().getName();
            this.logWarning("Server name is not configured! Please set it in your plugin config! Using the name of the server directory instead: " + this.serverName, new Throwable[0]);
        }
        if ((messengerType = (String)this.config.get("messenger-type", String.class)) == null) {
            messengerType = "plugin_messages";
        }
        switch (messengerType = messengerType.toLowerCase(Locale.ROOT)) {
            default: {
                this.logWarning("Messenger type '" + messengerType + "' is not supported, falling back to plugin messages!", new Throwable[0]);
            }
            case "plugin_messages": {
                this.connector = new PluginMessageConnector(this);
                this.logWarning("Using plugin messages as the messenger type will come with some caveats like sending to servers without players or to other proxies not working!", new Throwable[0]);
                this.logWarning("Please consider using one of the other messenger types!", new Throwable[0]);
                break;
            }
            case "redis": {
                this.connector = new RedisConnector(this);
                break;
            }
            case "mqtt": {
                this.connector = new MqttConnector(this);
            }
        }
        this.bridge = new Bridge(this);
        this.getLimbo().getEventsManager().registerEvents((LimboPlugin)this, (Listener)this);
        this.getLimbo().getEventsManager().registerEvents((LimboPlugin)this, (Listener)this.bridge);
        this.getLimbo().getPluginManager().registerCommands((LimboPlugin)this, (CommandExecutor)new ConnectorCommand(this));
    }

    public void onDisable() {
        if (this.connector != null) {
            this.connector.close();
        }
    }

    @EventHandler
    public void onPlayerQuit(PlayerQuitEvent event) {
        if (this.bridge != null) {
            this.bridge.onPlayerQuit(event);
        }
    }

    public Bridge getBridge() {
        return this.bridge;
    }

    public FileConfiguration getPluginConfig() {
        return this.config;
    }

    public Connector<LimboConnectorPlugin, Player> getConnector() {
        return this.connector;
    }

    public MessageTarget.Type getSourceType() {
        return MessageTarget.Type.SERVER;
    }

    public void logDebug(String message, Throwable ... throwables) {
        if (this.debug) {
            this.logInfo("[DEBUG] " + message, throwables);
        }
    }

    public void logInfo(String message, Throwable ... throwables) {
        Limbo.getInstance().getConsole().sendMessage(message);
        if (throwables.length > 0) {
            throwables[0].printStackTrace();
        }
    }

    public void logWarning(String message, Throwable ... throwables) {
        Limbo.getInstance().getConsole().sendMessage("[WARNING] " + message);
        if (throwables.length > 0) {
            throwables[0].printStackTrace();
        }
    }

    public void logError(String message, Throwable ... throwables) {
        Limbo.getInstance().getConsole().sendMessage("[ERROR] " + message);
        if (throwables.length > 0) {
            throwables[0].printStackTrace();
        }
    }

    public String getServerName() {
        return this.serverName;
    }

    public String getGlobalGroup() {
        return this.globalGroup;
    }

    public Map<String, String> getGroups() {
        return this.pluginGroups;
    }

    public void runAsync(final Runnable runnable) {
        this.getLimbo().getScheduler().runTaskAsync((LimboPlugin)this, new LimboTask(){

            public void run() {
                runnable.run();
            }
        });
    }

    public Limbo getLimbo() {
        return Limbo.getInstance();
    }

    public InputStream getResourceAsStream(String filename) {
        return ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream(filename);
    }
}

