/*
 * Decompiled with CFR 0.152.
 */
package de.themoep.connectorplugin.limbo;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.io.ByteArrayDataInput;
import com.google.common.io.ByteArrayDataOutput;
import com.google.common.io.ByteStreams;
import com.loohp.limbo.commands.CommandExecutor;
import com.loohp.limbo.commands.CommandSender;
import com.loohp.limbo.commands.TabCompletor;
import com.loohp.limbo.events.EventHandler;
import com.loohp.limbo.events.Listener;
import com.loohp.limbo.events.player.PlayerJoinEvent;
import com.loohp.limbo.events.player.PlayerQuitEvent;
import com.loohp.limbo.events.player.PlayerSpawnEvent;
import com.loohp.limbo.location.Location;
import com.loohp.limbo.player.Player;
import com.loohp.limbo.plugins.LimboPlugin;
import com.loohp.limbo.world.World;
import de.themoep.connectorplugin.ConnectorPlugin;
import de.themoep.connectorplugin.LocationInfo;
import de.themoep.connectorplugin.ResponseHandler;
import de.themoep.connectorplugin.ServerBridgeCommon;
import de.themoep.connectorplugin.connector.MessageTarget;
import de.themoep.connectorplugin.limbo.LimboConnectorPlugin;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;

public class Bridge
extends ServerBridgeCommon<LimboConnectorPlugin, Player>
implements Listener {
    private final Cache<String, ServerBridgeCommon.LoginRequest> loginRequests = CacheBuilder.newBuilder().expireAfterWrite(1L, TimeUnit.MINUTES).build();

    public Bridge(LimboConnectorPlugin plugin) {
        super((ConnectorPlugin)plugin);
        plugin.getLimbo().getEventsManager().registerEvents((LimboPlugin)plugin, (Listener)this);
        this.registerMessageHandler("teleport", (receiver, message) -> {
            ByteArrayDataInput in = ByteStreams.newDataInput((byte[])message.getData());
            String senderServer = message.getReceivedMessage().getSendingServer();
            long id = in.readLong();
            String playerName = in.readUTF();
            LocationInfo location = LocationInfo.read((ByteArrayDataInput)in);
            if (!location.getServer().equals(plugin.getServerName())) {
                return;
            }
            World world = plugin.getServer().getWorld(location.getWorld());
            if (world == null) {
                this.sendResponse(plugin.getServerName(), id, false, new String[]{"No world with the name " + location.getWorld() + " exists on the server!"});
                plugin.logDebug("[M] Player " + playerName + " is online but no world with the name " + location.getWorld() + " to teleport to exists?", new Throwable[0]);
                return;
            }
            this.markTeleporting(playerName);
            Player player = plugin.getServer().getPlayer(playerName);
            if (player != null) {
                plugin.logDebug("[M] Player " + playerName + " is online. Teleporting to " + location, new Throwable[0]);
                player.teleport(new Location(world, location.getX(), location.getY(), location.getZ(), location.getYaw(), location.getPitch()));
                this.sendResponse(plugin.getServerName(), id, true, new String[0]);
                this.unmarkTeleporting(playerName);
            } else {
                this.loginRequests.put((Object)playerName.toLowerCase(Locale.ROOT), (Object)new ServerBridgeCommon.LocationTeleportRequest(senderServer, id, location));
                if (!plugin.getConnector().requiresPlayer() || !plugin.getServer().getPlayers().isEmpty()) {
                    plugin.getBridge().sendToServer(playerName, location.getServer(), new Consumer[]{messages -> this.sendResponseMessage(senderServer, id, new String[]{messages})}).whenComplete((success, ex) -> this.sendResponse(senderServer, id, success, new String[]{success != false ? "Player teleported!" : "Unable to teleport " + (ex != null ? ex.getMessage() : "")}));
                }
            }
        });
        this.registerMessageHandler("teleport_to_world", (receiver, message) -> {
            ByteArrayDataInput in = ByteStreams.newDataInput((byte[])message.getData());
            String senderServer = message.getReceivedMessage().getSendingServer();
            long id = in.readLong();
            String playerName = in.readUTF();
            String serverName = in.readUTF();
            if (!serverName.equals(plugin.getServerName())) {
                return;
            }
            String worldName = in.readUTF();
            World world = plugin.getServer().getWorld(worldName);
            if (world == null) {
                this.sendResponse(senderServer, id, false, new String[]{"No world with the name " + worldName + " exists on the server!"});
                plugin.logDebug("[M] Player " + playerName + " is online but no world with the name " + worldName + " to teleport to exists?", new Throwable[0]);
                return;
            }
            this.markTeleporting(playerName);
            Player player = plugin.getServer().getPlayer(playerName);
            if (player != null) {
                plugin.logDebug("[M] Player " + playerName + " is online. Teleporting to spawn of world " + worldName, new Throwable[0]);
                player.teleport(plugin.getLimbo().getServerProperties().getWorldSpawn());
                this.sendResponse(senderServer, id, true, new String[]{"Player teleported to spawn of " + worldName + "!"});
                this.unmarkTeleporting(playerName);
            } else {
                this.loginRequests.put((Object)playerName.toLowerCase(Locale.ROOT), (Object)new ServerBridgeCommon.LocationTeleportRequest(senderServer, id, this.adapt(plugin.getLimbo().getServerProperties().getWorldSpawn())));
                if (!plugin.getConnector().requiresPlayer() || !plugin.getServer().getPlayers().isEmpty()) {
                    this.sendToServer(playerName, serverName, new Consumer[]{messages -> this.sendResponseMessage(senderServer, id, new String[]{messages})}).whenComplete((success, ex) -> this.sendResponse(senderServer, id, success, new String[]{success != false ? "Player teleported to spawn of " + worldName + "!" : "Unable to teleport " + (ex != null ? ex.getMessage() : "")}));
                }
            }
        });
        this.registerMessageHandler("teleport_to_player", (receiver, message) -> {
            ByteArrayDataInput in = ByteStreams.newDataInput((byte[])message.getData());
            String senderServer = message.getReceivedMessage().getSendingServer();
            long id = in.readLong();
            String playerName = in.readUTF();
            String targetName = in.readUTF();
            this.markTeleporting(playerName);
            Player target = plugin.getServer().getPlayer(targetName);
            if (target != null) {
                Player player = plugin.getServer().getPlayer(playerName);
                if (player != null) {
                    plugin.logDebug("[M] Player " + playerName + " is online. Teleporting to player " + targetName, new Throwable[0]);
                    player.teleport(target.getLocation());
                    this.sendResponse(senderServer, id, true, new String[]{"Player teleported!"});
                    this.unmarkTeleporting(playerName);
                } else {
                    this.loginRequests.put((Object)playerName.toLowerCase(Locale.ROOT), (Object)new ServerBridgeCommon.PlayerTeleportRequest(senderServer, id, targetName));
                    if (!plugin.getConnector().requiresPlayer() || !plugin.getServer().getPlayers().isEmpty()) {
                        this.sendToServer(playerName, plugin.getServerName(), new Consumer[]{messages -> this.sendResponseMessage(senderServer, id, new String[]{messages})}).whenComplete((success, ex) -> this.sendResponse(senderServer, id, success, new String[]{success != false ? "Player teleported!" : "Unable to teleport " + (ex != null ? ex.getMessage() : "")}));
                    }
                }
            }
        });
        this.registerMessageHandler("get_location", (receiver, message) -> {
            ByteArrayDataInput in = ByteStreams.newDataInput((byte[])message.getData());
            String senderServer = message.getReceivedMessage().getSendingServer();
            long id = in.readLong();
            String playerName = in.readUTF();
            Player player = plugin.getServer().getPlayer(playerName);
            if (player != null) {
                this.sendResponse(senderServer, id, this.adapt(player.getLocation()), new String[0]);
            } else {
                this.sendResponse(senderServer, id, null, new String[0]);
            }
        });
        this.registerMessageHandler("player_command", (receiver, message) -> {
            ByteArrayDataInput in = ByteStreams.newDataInput((byte[])message.getData());
            String senderServer = message.getReceivedMessage().getSendingServer();
            long id = in.readLong();
            String playerName = in.readUTF();
            UUID playerId = new UUID(in.readLong(), in.readLong());
            String command = in.readUTF();
            Player player = plugin.getLimbo().getPlayer(playerId);
            if (player == null) {
                player = plugin.getLimbo().getPlayer(playerName);
            }
            if (player == null) {
                plugin.logDebug("Could not find player " + playerName + "/" + playerId + " on this server to execute command " + command, new Throwable[0]);
                this.sendResponse(senderServer, id, false, new String[]{"Could not find player " + playerName + "/" + playerId + " on this server to execute command " + command});
                return;
            }
            plugin.logDebug("Command '" + command + "' for player '" + playerName + "' triggered from " + senderServer, new Throwable[0]);
            plugin.getLimbo().dispatchCommand((CommandSender)player, command);
            this.sendResponse(senderServer, id, true, new String[0]);
        });
        this.registerMessageHandler("console_command", (receiver, message) -> {
            Player player;
            ByteArrayDataInput in = ByteStreams.newDataInput((byte[])message.getData());
            String senderServer = message.getReceivedMessage().getSendingServer();
            String targetServer = in.readUTF();
            if (targetServer.startsWith("p:") ? (player = plugin.getLimbo().getPlayer(targetServer.substring(2))) == null : !targetServer.equals(plugin.getServerName())) {
                return;
            }
            long id = in.readLong();
            String command = in.readUTF();
            plugin.logDebug("Console command '" + command + "' triggered from " + senderServer, new Throwable[0]);
            plugin.getLimbo().dispatchCommand((CommandSender)plugin.getLimbo().getConsole(), command);
            this.sendResponse(senderServer, id, true, new String[0]);
        });
        this.registerMessageHandler("register_command", (receiver, message) -> {
            ByteArrayDataInput in = ByteStreams.newDataInput((byte[])message.getData());
            String senderServer = message.getReceivedMessage().getSendingServer();
            String pluginName = in.readUTF();
            String name = in.readUTF();
            String description = in.readUTF();
            String usage = in.readUTF();
            String permission = in.readUTF();
            String permissionMessage = in.readBoolean() ? in.readUTF() : null;
            int aliasCount = in.readInt();
            ArrayList<String> aliases = new ArrayList<String>();
            for (int i = 0; i < aliasCount; ++i) {
                aliases.add(in.readUTF());
            }
            plugin.getLimbo().getPluginManager().registerCommands((LimboPlugin)plugin, (CommandExecutor)new BridgedCommandExecutor(senderServer, pluginName, name, description, usage, aliases, permission, permissionMessage));
        });
        this.sendStarted(plugin);
    }

    @EventHandler
    public void onPlayerSpawnEvent(PlayerSpawnEvent event) {
        ServerBridgeCommon.LoginRequest request = (ServerBridgeCommon.LoginRequest)this.loginRequests.getIfPresent((Object)event.getPlayer().getName().toLowerCase(Locale.ROOT));
        if (request != null) {
            this.loginRequests.invalidate((Object)event.getPlayer().getName().toLowerCase(Locale.ROOT));
            if (request instanceof ServerBridgeCommon.LocationTeleportRequest) {
                event.setSpawnLocation(this.adapt(((ServerBridgeCommon.LocationTeleportRequest)request).getLocation()));
                this.sendResponse(request.getServer(), request.getId(), true, new String[]{"Player login location changed"});
                ((LimboConnectorPlugin)this.plugin).logDebug("Set spawn location of player " + event.getPlayer().getName() + " to " + ((ServerBridgeCommon.LocationTeleportRequest)request).getLocation(), new Throwable[0]);
            } else if (request instanceof ServerBridgeCommon.PlayerTeleportRequest) {
                Player target = ((LimboConnectorPlugin)this.plugin).getServer().getPlayer(((ServerBridgeCommon.PlayerTeleportRequest)request).getTargetName());
                if (target == null) {
                    event.setSpawnLocation(((LimboConnectorPlugin)this.plugin).getLimbo().getServerProperties().getWorldSpawn());
                    this.sendResponse(request.getServer(), request.getId(), false, new String[]{"Target player " + ((ServerBridgeCommon.PlayerTeleportRequest)request).getTargetName() + " is no longer online?"});
                    ((LimboConnectorPlugin)this.plugin).logDebug("Tried to set spawn location of player " + event.getPlayer().getName() + " to " + ((ServerBridgeCommon.PlayerTeleportRequest)request).getTargetName() + " but target wasn't online. Set to level spawn instead.", new Throwable[0]);
                } else {
                    event.setSpawnLocation(target.getLocation());
                    this.sendResponse(request.getServer(), request.getId(), true, new String[]{"Player login location changed to " + target.getName() + "'s location"});
                    ((LimboConnectorPlugin)this.plugin).logDebug("Set spawn location of player " + event.getPlayer().getName() + " to " + ((ServerBridgeCommon.PlayerTeleportRequest)request).getTargetName() + ". " + target.getLocation(), new Throwable[0]);
                }
            }
        }
    }

    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent event) {
        this.unmarkTeleporting(event.getPlayer().getName());
    }

    @EventHandler
    public void onPlayerQuit(PlayerQuitEvent event) {
        this.unmarkTeleporting(event.getPlayer().getName());
    }

    public Location adapt(LocationInfo location) {
        World world = ((LimboConnectorPlugin)this.plugin).getServer().getWorld(location.getWorld());
        if (world == null) {
            throw new IllegalArgumentException("No world with the name " + location.getWorld() + " exists!");
        }
        return new Location(world, location.getX(), location.getY(), location.getZ(), location.getYaw(), location.getPitch());
    }

    public LocationInfo adapt(Location location) {
        if (location.getWorld() == null) {
            return null;
        }
        return new LocationInfo(((LimboConnectorPlugin)this.plugin).getServerName(), location.getWorld().getName(), location.getX(), location.getY(), location.getZ(), location.getYaw(), location.getPitch());
    }

    private void sendCommandExecution(CommandSender sender, BridgedCommandExecutor executor, String label, String[] args) {
        ByteArrayDataOutput out = ByteStreams.newDataOutput();
        out.writeUTF(executor.getServer());
        out.writeUTF(sender instanceof Player ? sender.getName() : "");
        out.writeUTF(executor.getPluginName());
        out.writeUTF(executor.getName());
        out.writeUTF(label);
        out.writeInt(args.length);
        for (String arg : args) {
            out.writeUTF(arg);
        }
        if (sender instanceof Player) {
            this.adapt(((Player)sender).getLocation()).write(out);
            this.sendData("execute_command", MessageTarget.PROXY, (Player)sender, out.toByteArray());
        } else {
            out.writeUTF("");
            this.sendData("execute_command", MessageTarget.ALL_PROXIES, out.toByteArray());
        }
    }

    @SafeVarargs
    public final CompletableFuture<Boolean> teleport(Player player, LocationInfo location, Consumer<String> ... consumer) {
        return this.teleport(player.getName(), location, consumer);
    }

    @SafeVarargs
    public final CompletableFuture<Boolean> teleport(String playerName, LocationInfo location, Consumer<String> ... consumer) {
        Player player;
        this.markTeleporting(playerName);
        if (location.getServer().equals(((LimboConnectorPlugin)this.plugin).getServerName()) && (player = ((LimboConnectorPlugin)this.plugin).getServer().getPlayer(playerName)) != null) {
            ((LimboConnectorPlugin)this.plugin).logDebug("Player " + playerName + " is online. Teleporting to " + location, new Throwable[0]);
            player.teleport(this.adapt(location));
            ((LimboConnectorPlugin)this.plugin).logDebug("Teleport of player " + playerName + " was successful", new Throwable[0]);
            this.unmarkTeleporting(playerName);
            return CompletableFuture.completedFuture(true);
        }
        CompletableFuture<Boolean> future = new CompletableFuture<Boolean>();
        this.getServer(playerName).whenComplete((s, e) -> {
            if (s == null) {
                future.complete(false);
                for (Consumer c : consumer) {
                    c.accept("Player " + playerName + " is not online!");
                }
                return;
            }
            ByteArrayDataOutput out = ByteStreams.newDataOutput();
            long id = RANDOM.nextLong();
            out.writeLong(id);
            out.writeUTF(playerName);
            location.write(out);
            this.responses.put((Object)id, (Object)new ResponseHandler.Boolean(future));
            if (consumer != null && consumer.length > 0) {
                this.consumers.put((Object)id, (Object)consumer);
            }
            this.sendData("teleport", MessageTarget.SERVER, location.getServer(), out.toByteArray());
        });
        return future;
    }

    @SafeVarargs
    public final CompletableFuture<Boolean> teleport(Player player, String serverName, String worldName, Consumer<String> ... consumer) {
        return this.teleport(player.getName(), serverName, worldName, consumer);
    }

    @SafeVarargs
    public final CompletableFuture<Boolean> teleport(String playerName, String serverName, String worldName, Consumer<String> ... consumer) {
        Player player;
        this.markTeleporting(playerName);
        if (serverName.equals(((LimboConnectorPlugin)this.plugin).getServerName()) && (player = ((LimboConnectorPlugin)this.plugin).getServer().getPlayer(playerName)) != null) {
            World world = ((LimboConnectorPlugin)this.plugin).getServer().getWorld(worldName);
            if (world == null) {
                ((LimboConnectorPlugin)this.plugin).logDebug("Player " + playerName + " is online but no world with the name " + worldName + " to teleport to exists?", new Throwable[0]);
                for (Consumer<String> c : consumer) {
                    c.accept("No world with the name " + worldName + " exists on the server!");
                }
                this.unmarkTeleporting(playerName);
                return CompletableFuture.completedFuture(false);
            }
            ((LimboConnectorPlugin)this.plugin).logDebug("Player " + playerName + " is online. Teleporting to spawn of world " + worldName, new Throwable[0]);
            player.teleport(((LimboConnectorPlugin)this.plugin).getLimbo().getServerProperties().getWorldSpawn());
            ((LimboConnectorPlugin)this.plugin).logDebug("Teleport of player " + playerName + " was successful", new Throwable[0]);
            this.unmarkTeleporting(playerName);
            return CompletableFuture.completedFuture(true);
        }
        CompletableFuture<Boolean> future = new CompletableFuture<Boolean>();
        this.getServer(playerName).whenComplete((s, e) -> {
            if (s == null) {
                future.complete(false);
                for (Consumer c : consumer) {
                    c.accept("Player " + playerName + " is not online!");
                }
                return;
            }
            ByteArrayDataOutput out = ByteStreams.newDataOutput();
            long id = RANDOM.nextLong();
            out.writeLong(id);
            out.writeUTF(playerName);
            out.writeUTF(serverName);
            out.writeUTF(worldName);
            this.responses.put((Object)id, (Object)new ResponseHandler.Boolean(future));
            this.consumers.put((Object)id, (Object)consumer);
            this.sendData("teleport_to_world", MessageTarget.PROXY, "player:" + playerName, out.toByteArray());
        });
        return future;
    }

    @SafeVarargs
    public final CompletableFuture<Boolean> teleport(Player player, Player target, Consumer<String> ... consumer) {
        return this.teleport(player.getName(), target.getName(), consumer);
    }

    @SafeVarargs
    public final CompletableFuture<Boolean> teleport(String playerName, String targetName, Consumer<String> ... consumer) {
        CompletableFuture<Boolean> future = new CompletableFuture<Boolean>();
        this.getServer(playerName).whenComplete((server, ex) -> {
            if (server == null) {
                future.complete(false);
                for (Consumer c : consumer) {
                    c.accept("Player " + playerName + " is not online!");
                }
                return;
            }
            this.markTeleporting(playerName);
            ByteArrayDataOutput out = ByteStreams.newDataOutput();
            long id = RANDOM.nextLong();
            out.writeLong(id);
            out.writeUTF(playerName);
            out.writeUTF(targetName);
            this.responses.put((Object)id, (Object)new ResponseHandler.Boolean(future));
            if (consumer != null && consumer.length > 0) {
                this.consumers.put((Object)id, (Object)consumer);
            }
            this.sendData("teleport_to_player", MessageTarget.SERVER, "player:" + targetName, out.toByteArray());
        });
        return future;
    }

    public CompletableFuture<String> getServer(Player player) {
        return this.getServer(player.getName());
    }

    public CompletableFuture<LocationInfo> getLocation(Player player) {
        return this.getLocation(player.getName());
    }

    public CompletableFuture<Boolean> runProxyPlayerCommand(Player player, String command) {
        CompletableFuture<Boolean> future = new CompletableFuture<Boolean>();
        this.getServer(player).whenComplete((s, e) -> {
            if (s == null) {
                future.complete(false);
                return;
            }
            ByteArrayDataOutput out = ByteStreams.newDataOutput();
            long id = RANDOM.nextLong();
            out.writeLong(id);
            out.writeUTF(player.getName());
            out.writeLong(player.getUniqueId().getMostSignificantBits());
            out.writeLong(player.getUniqueId().getLeastSignificantBits());
            out.writeUTF(command);
            this.responses.put((Object)id, (Object)new ResponseHandler.Boolean(future));
            this.sendData("player_command", MessageTarget.PROXY, player, out.toByteArray());
        });
        return future;
    }

    private class BridgedCommandExecutor
    implements CommandExecutor,
    TabCompletor {
        private final String server;
        private final String pluginName;
        private final String name;
        private final String permission;
        private final Collection<String> aliases;

        public BridgedCommandExecutor(String server, String pluginName, String name, String description, String usage, List<String> aliases, String permission, String permissionMessage) {
            this.server = server;
            this.pluginName = pluginName;
            this.name = name;
            this.permission = permission;
            this.aliases = aliases;
        }

        public String getServer() {
            return this.server;
        }

        public String getPluginName() {
            return this.pluginName;
        }

        public String getName() {
            return this.name;
        }

        public void execute(CommandSender sender, String[] args) {
            if (!sender.hasPermission(this.permission)) {
                return;
            }
            if (args.length == 0) {
                return;
            }
            if (!args[0].equalsIgnoreCase(this.name) && !this.aliases.contains(args[0].toLowerCase(Locale.ROOT))) {
                return;
            }
            Bridge.this.sendCommandExecution(sender, this, args[0], Arrays.copyOfRange(args, 2, args.length));
        }

        public List<String> tabComplete(CommandSender sender, String[] args) {
            if (!sender.hasPermission(this.permission)) {
                return new ArrayList<String>();
            }
            ArrayList<String> completions = new ArrayList<String>();
            if (args.length == 1) {
                String prefix = args[0].toLowerCase(Locale.ROOT);
                for (String alias : this.aliases) {
                    if (!alias.toLowerCase(Locale.ROOT).startsWith(prefix)) continue;
                    completions.add(alias);
                }
            }
            return completions;
        }
    }
}

