package de.themoep.connectorplugin.limbo.connector;

/*
 * ConnectorPlugin
 * Copyright (C) 2025 Max Lee aka Phoenix616 (max@themoep.de)
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published
 * by the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */

import com.loohp.limbo.player.Player;
import de.themoep.connectorplugin.connector.Connector;
import de.themoep.connectorplugin.connector.Message;
import de.themoep.connectorplugin.limbo.LimboConnectorPlugin;

public abstract class LimboConnector extends Connector<LimboConnectorPlugin, Player> {

    public LimboConnector(LimboConnectorPlugin plugin, boolean requiresPlayer) {
        super(plugin, requiresPlayer);
    }

    protected Player getReceiverImplementation(String name) {
        return plugin.getLimbo().getPlayer(name);
    }

    @Override
    protected void handle(Player receiver, Message message) {
        switch (message.getTarget()) {
            case OTHERS_WITH_PLAYERS:
            case ALL_WITH_PLAYERS:
                if (plugin.getLimbo().getPlayers().isEmpty()) {
                    return;
                }
                break;
            default:
                break;
        }
        super.handle(receiver, message);
    }

    @Override
    protected void sendDataImplementation(Object targetData, Message message) {
        sendDataImplementation(targetData instanceof String
                ? (hasPrefix((String) targetData)
                ? (String) targetData
                : SERVER_PREFIX + targetData)
                : (targetData instanceof Player
                ? PLAYER_PREFIX + ((Player) targetData).getName()
                : ""), message);
    }

    protected abstract void sendDataImplementation(String targetData, Message message);
}
