/*
 * Decompiled with CFR 0.152.
 */
package de.themoep.chestshoptools.manager;

import com.Acrobot.Breeze.Utils.MaterialUtil;
import com.Acrobot.Breeze.Utils.StringUtil;
import com.Acrobot.ChestShop.ChestShop;
import com.Acrobot.ChestShop.Events.ShopCreatedEvent;
import com.Acrobot.ChestShop.Events.ShopDestroyedEvent;
import de.themoep.chestshoptools.ChestShopTools;
import de.themoep.chestshoptools.Utils;
import de.themoep.chestshoptools.manager.AbstractManager;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import org.bukkit.ChatColor;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.BlockState;
import org.bukkit.block.Sign;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.Directional;
import org.bukkit.block.data.Rotatable;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.event.EventHandler;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.PotionMeta;
import org.bukkit.potion.PotionData;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

public class PotionManager
extends AbstractManager {
    private final ChatColor goodColor;
    private final ChatColor neutralColor;
    private final ChatColor badColor;
    private final boolean autoCreateSign;
    private final boolean showExtended;
    private final boolean showUpgraded;
    private Set<PotionEffectType> badEffects = new HashSet<PotionEffectType>();

    public PotionManager(ChestShopTools plugin, ConfigurationSection config) {
        super(plugin, config);
        this.autoCreateSign = config.getBoolean("auto-create-sign");
        this.goodColor = this.getColor("good-color", ChatColor.BLUE);
        this.neutralColor = this.getColor("neutral-color", ChatColor.DARK_AQUA);
        this.badColor = this.getColor("bad-color", ChatColor.RED);
        this.showExtended = config.getBoolean("show-extended", false);
        this.showUpgraded = config.getBoolean("show-upgraded", false);
        for (String string : config.getStringList("bad-effects")) {
        }
    }

    @Override
    public void disable() {
        HandlerList.unregisterAll((Listener)this);
    }

    @EventHandler
    public void onShopCreation(ShopCreatedEvent event) {
        ItemMeta meta;
        if (!this.isManaged(event.getSign().getWorld())) {
            return;
        }
        String itemLine = event.getSignLine((short)3);
        ItemStack item = ChestShop.getItemDatabase().getFromCode(itemLine.substring(itemLine.indexOf(35) + 1));
        if (item != null && item.hasItemMeta() && (meta = item.getItemMeta()) instanceof PotionMeta) {
            PotionMeta potionMeta = (PotionMeta)meta;
            Block blockAbove = event.getSign().getBlock().getRelative(BlockFace.UP);
            BlockState above = blockAbove.getState();
            if (this.autoCreateSign && !(above instanceof Sign)) {
                blockAbove.setType(event.getSign().getType());
                above = blockAbove.getState();
                BlockData aboveData = above.getBlockData();
                BlockData signData = event.getSign().getBlockData();
                if (aboveData instanceof Directional && signData instanceof Directional) {
                    ((Directional)aboveData).setFacing(((Directional)signData).getFacing());
                } else if (aboveData instanceof Rotatable && signData instanceof Rotatable) {
                    ((Rotatable)aboveData).setRotation(((Rotatable)signData).getRotation());
                }
                above.setBlockData(aboveData);
            }
            if (above instanceof Sign) {
                Sign sign = (Sign)above;
                ArrayList<String> lines = new ArrayList<String>();
                if (potionMeta.getBasePotionData().getType().getEffectType() != null) {
                    lines.add(this.getPotionInfo(potionMeta.getBasePotionData()));
                }
                for (PotionEffect effect : potionMeta.getCustomEffects()) {
                    lines.add(this.getPotionInfo(effect));
                    if (lines.size() < 4) continue;
                    break;
                }
                for (int i = 0; i < 4; ++i) {
                    sign.setLine(i, "");
                }
                int lineNmbr = lines.size() >= 3 ? 0 : 1;
                for (String line : lines) {
                    sign.setLine(lineNmbr, line);
                    if (++lineNmbr < 4) continue;
                    break;
                }
                sign.update(true);
            }
        }
    }

    private String getPotionInfo(PotionData potionData) {
        String potionName = this.getHumanName(potionData.getType().getEffectType());
        Object extra = "";
        if (this.showUpgraded && potionData.isUpgraded()) {
            extra = (String)extra + " II";
        }
        if (this.showExtended && potionData.isExtended()) {
            extra = (String)extra + " +";
        }
        return String.valueOf(this.getColor(potionData.getType().getEffectType())) + this.combineSignLine(potionName, (String)extra);
    }

    private String getPotionInfo(PotionEffect potionEffect) {
        String potionName = this.getHumanName(potionEffect.getType());
        Object extra = "";
        if (this.showUpgraded && potionEffect.getAmplifier() > 0) {
            extra = (String)extra + " " + potionEffect.getAmplifier();
        }
        if (this.showExtended && potionEffect.getDuration() > 0) {
            int seconds = potionEffect.getDuration() / 20;
            extra = (String)extra + " " + String.format("%02d:%02d", seconds % 3600 / 60, seconds % 60);
        }
        return String.valueOf(this.getColor(potionEffect.getType())) + this.combineSignLine(potionName, (String)extra);
    }

    private String combineSignLine(String potionName, String extra) {
        String line = potionName + extra;
        for (int i = potionName.length() - 1; i > 0 && StringUtil.getMinecraftStringWidth((String)line) > MaterialUtil.MAXIMUM_SIGN_WIDTH; --i) {
            line = potionName.substring(0, i) + extra;
        }
        return line;
    }

    @EventHandler
    public void onShopRemoved(ShopDestroyedEvent event) {
        Sign enchSign;
        if (!this.isManaged(event.getSign().getWorld())) {
            return;
        }
        Block above = event.getSign().getBlock().getRelative(BlockFace.UP);
        BlockState state = above.getState();
        if (state instanceof Sign && this.isPotionSign(enchSign = (Sign)state)) {
            for (int i = 0; i < 4; ++i) {
                enchSign.setLine(i, "");
            }
            enchSign.update(true);
        }
    }

    public boolean isPotionSign(Sign sign) {
        int nonEmptyLines = 0;
        for (String line : sign.getLines()) {
            if (line.isEmpty()) continue;
            if (!line.startsWith(this.goodColor.toString()) && !line.startsWith(this.badColor.toString())) {
                return false;
            }
            ++nonEmptyLines;
        }
        return sign.getLines().length > 0 && nonEmptyLines > 0;
    }

    private ChatColor getColor(PotionEffectType type) {
        return switch (type.getEffectCategory()) {
            default -> throw new IncompatibleClassChangeError();
            case PotionEffectType.Category.HARMFUL -> this.badColor;
            case PotionEffectType.Category.NEUTRAL -> this.neutralColor;
            case PotionEffectType.Category.BENEFICIAL -> this.goodColor;
        };
    }

    private String getHumanName(PotionEffectType potionType) {
        String name = this.config.getString("aliases." + potionType.getName().toLowerCase(), null);
        if (name != null && !name.isEmpty()) {
            return name;
        }
        return Utils.humanize(potionType.getName());
    }

    private ChatColor getColor(String key, ChatColor defaultColor) {
        try {
            return ChatColor.valueOf((String)this.config.getString(key).toUpperCase(Locale.ROOT));
        }
        catch (IllegalArgumentException e) {
            this.plugin.getLogger().warning(this.getName() + ": " + this.config.getString(key) + " is not a valid color for " + key);
            return defaultColor;
        }
    }
}

