/*
 * Decompiled with CFR 0.152.
 */
package de.themoep.chestshoptools.manager;

import com.Acrobot.ChestShop.ChestShop;
import com.Acrobot.ChestShop.Events.ShopCreatedEvent;
import com.Acrobot.ChestShop.Events.ShopDestroyedEvent;
import de.themoep.chestshoptools.ChestShopTools;
import de.themoep.chestshoptools.Utils;
import de.themoep.chestshoptools.manager.AbstractManager;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Map;
import org.bukkit.ChatColor;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.BlockState;
import org.bukkit.block.Sign;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.Directional;
import org.bukkit.block.data.Rotatable;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.event.EventHandler;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.EnchantmentStorageMeta;
import org.bukkit.inventory.meta.ItemMeta;

public class EnchantManager
extends AbstractManager {
    private final ChatColor enchantmentColor;
    private final ChatColor enchantmentStorageColor;
    private final boolean autoCreateSign;

    public EnchantManager(ChestShopTools plugin, ConfigurationSection config) {
        super(plugin, config);
        this.autoCreateSign = config.getBoolean("auto-create-sign");
        this.enchantmentColor = this.getColor("enchant-color", ChatColor.AQUA);
        this.enchantmentStorageColor = this.getColor("enchant-storage-color", ChatColor.YELLOW);
    }

    @Override
    public void disable() {
        HandlerList.unregisterAll((Listener)this);
    }

    @EventHandler
    public void onShopCreation(ShopCreatedEvent event) {
        ItemMeta meta;
        if (!this.isManaged(event.getSign().getWorld())) {
            return;
        }
        String itemLine = event.getSignLine((short)3);
        ItemStack item = ChestShop.getItemDatabase().getFromCode(itemLine.substring(itemLine.indexOf(35) + 1));
        if (item != null && item.hasItemMeta() && ((meta = item.getItemMeta()).hasEnchants() || meta instanceof EnchantmentStorageMeta)) {
            Block blockAbove = event.getSign().getBlock().getRelative(BlockFace.UP);
            BlockState above = blockAbove.getState();
            if (this.autoCreateSign && !(above instanceof Sign)) {
                blockAbove.setType(event.getSign().getType());
                above = blockAbove.getState();
                BlockData aboveData = above.getBlockData();
                BlockData signData = event.getSign().getBlockData();
                if (aboveData instanceof Directional && signData instanceof Directional) {
                    ((Directional)aboveData).setFacing(((Directional)signData).getFacing());
                } else if (aboveData instanceof Rotatable && signData instanceof Rotatable) {
                    ((Rotatable)aboveData).setRotation(((Rotatable)signData).getRotation());
                }
                above.setBlockData(aboveData);
            }
            if (above instanceof Sign) {
                int nameLenght;
                String line;
                Sign sign = (Sign)above;
                ArrayList<CallSite> lines = new ArrayList<CallSite>();
                if (meta.hasEnchants() && !meta.getEnchants().isEmpty()) {
                    for (Map.Entry entry : meta.getEnchants().entrySet()) {
                        String string = this.getHumanName((Enchantment)entry.getKey());
                        line = string + " " + String.valueOf(entry.getValue());
                        if (line.length() > 15) {
                            nameLenght = 15 - (" " + String.valueOf(entry.getValue())).length();
                            line = string.substring(0, nameLenght) + " " + String.valueOf(entry.getValue());
                        }
                        lines.add((CallSite)((Object)(String.valueOf(this.enchantmentColor) + line)));
                        if (lines.size() < 4) continue;
                        break;
                    }
                }
                if (meta instanceof EnchantmentStorageMeta) {
                    for (Map.Entry entry : ((EnchantmentStorageMeta)meta).getStoredEnchants().entrySet()) {
                        String string = this.getHumanName((Enchantment)entry.getKey());
                        line = string + " " + String.valueOf(entry.getValue());
                        if (line.length() > 15) {
                            nameLenght = 15 - (" " + String.valueOf(entry.getValue())).length();
                            line = string.substring(0, nameLenght) + " " + String.valueOf(entry.getValue());
                        }
                        lines.add((CallSite)((Object)(String.valueOf(this.enchantmentStorageColor) + line)));
                        if (lines.size() < 4) continue;
                        break;
                    }
                }
                for (int i = 0; i < 4; ++i) {
                    sign.setLine(i, "");
                }
                int lineNmbr = lines.size() >= 3 ? 0 : 1;
                for (String string : lines) {
                    sign.setLine(lineNmbr, string);
                    if (++lineNmbr < 4) continue;
                    break;
                }
                sign.update(true);
            }
        }
    }

    @EventHandler
    public void onShopRemoved(ShopDestroyedEvent event) {
        Sign enchSign;
        if (!this.isManaged(event.getSign().getWorld())) {
            return;
        }
        Block above = event.getSign().getBlock().getRelative(BlockFace.UP);
        BlockState state = above.getState();
        if (state instanceof Sign && this.isEnchantmentSign(enchSign = (Sign)state)) {
            for (int i = 0; i < 4; ++i) {
                enchSign.setLine(i, "");
            }
            enchSign.update(true);
        }
    }

    public boolean isEnchantmentSign(Sign sign) {
        int nonEmptyLines = 0;
        for (String line : sign.getLines()) {
            if (line.isEmpty()) continue;
            if (!line.startsWith(this.enchantmentColor.toString()) && !line.startsWith(this.enchantmentStorageColor.toString())) {
                return false;
            }
            ++nonEmptyLines;
        }
        return sign.getLines().length > 0 && nonEmptyLines > 0;
    }

    private String getHumanName(Enchantment enchantment) {
        String name = this.config.getString("aliases." + enchantment.getName().toLowerCase(), null);
        if (name != null && !name.isEmpty()) {
            return name;
        }
        return Utils.humanize(enchantment.getName());
    }

    private ChatColor getColor(String key, ChatColor defaultColor) {
        try {
            return ChatColor.valueOf((String)this.config.getString(key).toUpperCase(Locale.ROOT));
        }
        catch (IllegalArgumentException e) {
            this.plugin.getLogger().warning(this.getName() + ": " + this.config.getString(key) + " is not a valid color for " + key);
            return defaultColor;
        }
    }
}

