/*
 * Decompiled with CFR 0.152.
 */
package de.themoep.chestshoptools.manager;

import com.Acrobot.Breeze.Utils.PriceUtil;
import com.Acrobot.ChestShop.ChestShop;
import com.Acrobot.ChestShop.Containers.AdminInventory;
import com.Acrobot.ChestShop.Database.Account;
import com.Acrobot.ChestShop.Events.PreTransactionEvent;
import com.Acrobot.ChestShop.Events.ShopDestroyedEvent;
import com.Acrobot.ChestShop.Events.TransactionEvent;
import com.Acrobot.ChestShop.Utils.uBlock;
import com.google.common.collect.ImmutableMap;
import de.themoep.chestshoptools.ChestShopTools;
import de.themoep.chestshoptools.Utils;
import de.themoep.chestshoptools.manager.AbstractManager;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.logging.Level;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.block.BlockState;
import org.bukkit.block.Chest;
import org.bukkit.block.Sign;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class EmptyManager
extends AbstractManager {
    String messageOwner;
    String messageBuyer;
    private Map<UUID, String> offlineMessages = new HashMap<UUID, String>();

    public EmptyManager(ChestShopTools plugin, ConfigurationSection config) {
        super(plugin, config);
        this.messageOwner = ChatColor.translateAlternateColorCodes((char)'&', (String)config.getString("messages.owner", ""));
        this.messageBuyer = ChatColor.translateAlternateColorCodes((char)'&', (String)config.getString("messages.buyer", ""));
        try {
            this.offlineMessages = (Map)this.readMap("offlinemessages.map");
        }
        catch (ClassCastException e) {
            plugin.getLogger().log(Level.WARNING, "offlinemessages.map did not contain a UUID-String-Map or is corrupted.");
        }
    }

    @Override
    public void disable() {
        this.writeMap(this.offlineMessages, "offlinemessages.map");
        HandlerList.unregisterAll((Listener)this);
    }

    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent event) {
        final UUID playerId = event.getPlayer().getUniqueId();
        if (this.offlineMessages.containsKey(playerId)) {
            final String msg = this.offlineMessages.remove(playerId);
            new BukkitRunnable(){

                public void run() {
                    Player player = EmptyManager.this.plugin.getServer().getPlayer(playerId);
                    if (player != null && player.isOnline()) {
                        player.sendMessage(msg);
                    } else {
                        EmptyManager.this.cacheMessage(playerId, msg);
                    }
                }
            }.runTaskLater((Plugin)this.plugin, 100L);
        }
    }

    @EventHandler
    public void onTradeAttempt(PreTransactionEvent event) {
        if (!event.isCancelled() || !this.isManaged(event.getSign().getWorld()) || event.getTransactionType() != TransactionEvent.TransactionType.BUY || event.getTransactionOutcome() != PreTransactionEvent.TransactionOutcome.NOT_ENOUGH_STOCK_IN_CHEST || PriceUtil.hasSellPrice((String)event.getSign().getLine(2))) {
            return;
        }
        this.removeShop(event.getClient(), event.getOwnerAccount(), event.getSign(), event.getOwnerInventory(), event.getStock(), event.getExactPrice());
    }

    @EventHandler
    public void onTrade(TransactionEvent event) {
        if (!this.isManaged(event.getSign().getWorld()) || event.getTransactionType() != TransactionEvent.TransactionType.BUY || PriceUtil.hasSellPrice((String)event.getSign().getLine(2)) || this.hasItems(event.getStock(), event.getOwnerInventory())) {
            return;
        }
        this.plugin.getServer().getScheduler().runTask((Plugin)this.plugin, () -> this.removeShop(event.getClient(), event.getOwnerAccount(), event.getSign(), event.getOwnerInventory(), event.getStock(), event.getExactPrice()));
    }

    private boolean removeShop(Player client, Account owner, Sign sign, Inventory inventory, ItemStack[] stock, BigDecimal price) {
        boolean cleanupPossible;
        boolean bl = cleanupPossible = !(inventory instanceof AdminInventory) && inventory.getHolder() instanceof BlockState && sign.equals((Object)uBlock.getConnectedSign((BlockState)((BlockState)inventory.getHolder())));
        if (!cleanupPossible) {
            return false;
        }
        Chest connectedChest = (Chest)inventory.getHolder();
        ShopDestroyedEvent destroyedEvent = new ShopDestroyedEvent(client, sign, connectedChest);
        ChestShop.callEvent((Event)destroyedEvent);
        for (int i = 0; i < 4; ++i) {
            sign.setLine(i, "");
        }
        sign.update(true);
        inventory.setContents(new ItemStack[inventory.getSize() - 1]);
        ItemStack item = null;
        if (stock.length > 0) {
            item = stock[0];
        }
        Location loc = sign.getBlock().getLocation();
        ImmutableMap replacements = ImmutableMap.of((Object)"world", (Object)loc.getWorld().getName(), (Object)"location", (Object)(loc.getBlockX() + ", " + loc.getBlockY() + ", " + loc.getBlockZ()), (Object)"price", (Object)price.toString(), (Object)"item", (Object)(item != null ? Utils.humanize(item.getType().toString()) + " " : ""));
        if (!this.messageBuyer.isEmpty()) {
            client.sendMessage(this.plugin.buildMsg(this.messageBuyer, (Map<String, String>)replacements));
        }
        if (!this.messageOwner.isEmpty()) {
            String msg = this.plugin.buildMsg(this.messageOwner, (Map<String, String>)replacements);
            Player player = this.plugin.getServer().getPlayer(owner.getUuid());
            if (player != null) {
                player.sendMessage(msg);
            } else {
                this.cacheMessage(owner.getUuid(), msg);
            }
        }
        this.plugin.getLogger().log(Level.INFO, "Removed empty " + (item != null ? item.getType().toString() : "") + " shop by " + owner.getName() + " in " + loc.getWorld().getName() + " at " + loc.getBlockX() + ", " + loc.getBlockY() + ", " + loc.getBlockZ());
        return true;
    }

    private boolean hasItems(ItemStack[] items, Inventory inventory) {
        for (ItemStack item : items) {
            if (inventory.containsAtLeast(item, item.getAmount() * 2)) continue;
            return false;
        }
        return true;
    }

    private void cacheMessage(UUID playerId, String msg) {
        if (this.offlineMessages.containsKey(playerId)) {
            this.offlineMessages.put(playerId, this.offlineMessages.get(playerId) + "\n" + msg);
        } else {
            this.offlineMessages.put(playerId, msg);
        }
    }

    public void writeMap(Object object, String outputFile) {
        try {
            File file = new File(this.plugin.getDataFolder(), outputFile);
            if (!file.isFile() && !file.createNewFile()) {
                throw new IOException("Error creating new file: " + file.getPath());
            }
            FileOutputStream fileOut = new FileOutputStream(file.getPath());
            ObjectOutputStream out = new ObjectOutputStream(fileOut);
            out.writeObject(object);
            out.close();
            fileOut.close();
            this.plugin.getLogger().fine("Serialized data is saved in " + file.getPath());
        }
        catch (IOException i) {
            i.printStackTrace();
        }
    }

    public Object readMap(String inputFile) {
        HashMap map = new HashMap();
        File file = new File(this.plugin.getDataFolder(), inputFile);
        if (!file.isFile()) {
            this.plugin.getLogger().log(Level.INFO, "No file found in " + file.getPath());
            try {
                if (!file.createNewFile()) {
                    throw new IOException("Error while creating new file: " + file.getPath());
                }
                this.writeMap(map, inputFile);
                this.plugin.getLogger().log(Level.INFO, "New file created in " + file.getPath());
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        try {
            FileInputStream fileIn = new FileInputStream(file.getPath());
            ObjectInputStream in = new ObjectInputStream(fileIn);
            map = (HashMap)in.readObject();
            in.close();
            fileIn.close();
            this.plugin.getLogger().log(Level.INFO, "Sucessfully loaded cooldown.map.");
        }
        catch (IOException i) {
            this.plugin.getLogger().log(Level.WARNING, "No saved Map found in " + inputFile);
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        return map;
    }
}

