/*
 * Decompiled with CFR 0.152.
 */
package de.themoep.chestshoptools.manager;

import de.themoep.chestshoptools.ChestShopTools;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.bukkit.World;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;

public abstract class AbstractManager
implements Listener {
    protected final ConfigurationSection config;
    protected final ChestShopTools plugin;
    private Set<String> worldSet = new HashSet<String>();

    public AbstractManager(ChestShopTools plugin, ConfigurationSection config) {
        this.plugin = plugin;
        this.config = config;
        if (config != null && config.getBoolean("enabled", false)) {
            List worldList = config.getStringList("worlds");
            this.worldSet.addAll(worldList);
            if (worldList.size() > 0) {
                plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
            }
            plugin.getLogger().info("Enabled " + this.getName());
        }
    }

    public boolean isManaged(World world) {
        return this.isManaged(world.getName());
    }

    public boolean isManaged(String worldname) {
        return this.worldSet.contains(worldname) || this.worldSet.contains("*") || this.worldSet.contains(".*") || this.worldSet.contains("(.*)");
    }

    public String getName() {
        return this.getClass().getSimpleName();
    }

    public abstract void disable();
}

