/*
 * Decompiled with CFR 0.152.
 */
package de.themoep.chestshoptools;

import com.Acrobot.Breeze.Utils.MaterialUtil;
import com.Acrobot.Breeze.Utils.NumberUtil;
import com.Acrobot.ChestShop.ChestShop;
import com.Acrobot.ChestShop.Configuration.Messages;
import com.Acrobot.ChestShop.Events.AccountQueryEvent;
import com.Acrobot.ChestShop.Events.ItemInfoEvent;
import com.Acrobot.ChestShop.Signs.ChestShopSign;
import com.Acrobot.ChestShop.Utils.uBlock;
import de.themoep.ShowItem.libs.kyori.adventure.platform.bukkit.BukkitAudiences;
import de.themoep.chestshoptools.ChestShopTools;
import java.util.Set;
import java.util.logging.Level;
import org.bukkit.ChatColor;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.block.Sign;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class ShopInfoCommand
implements CommandExecutor {
    private final ChestShopTools plugin;

    public ShopInfoCommand(ChestShopTools plugin) {
        this.plugin = plugin;
    }

    public boolean onCommand(CommandSender sender, Command cmd, String commandLabel, String[] args) {
        if (args.length > 0) {
            return false;
        }
        if (!(sender instanceof Player)) {
            sender.sendMessage(String.valueOf(ChatColor.RED) + "This command can only be run by a player!");
            return true;
        }
        Block lookingAt = ((Player)sender).getTargetBlock((Set)null, 10);
        if (lookingAt == null) {
            sender.sendMessage(String.valueOf(ChatColor.RED) + "Please look at a shop sign or chest!" + String.valueOf(ChatColor.DARK_GRAY) + " (0)");
            return true;
        }
        Sign shopSign = null;
        BlockState state = lookingAt.getState(false);
        if (state instanceof InventoryHolder) {
            shopSign = uBlock.getConnectedSign((BlockState)state);
        } else if (state instanceof Sign && ChestShopSign.isValid((Block)lookingAt)) {
            shopSign = (Sign)state;
        }
        if (shopSign == null) {
            sender.sendMessage(String.valueOf(ChatColor.RED) + "Please look at a shop sign or chest!" + String.valueOf(ChatColor.DARK_GRAY) + " (1)");
            return true;
        }
        String name = shopSign.getLine(0);
        String quantity = shopSign.getLine(1);
        String prices = shopSign.getLine(2);
        String material = shopSign.getLine(3);
        AccountQueryEvent queryEvent = new AccountQueryEvent(name);
        ChestShop.callEvent((Event)queryEvent);
        if (queryEvent.getAccount() == null) {
            Messages.INVALID_SHOP_DETECTED.sendWithPrefix(sender, new String[0]);
            return true;
        }
        String ownerName = queryEvent.getAccount().getName();
        ownerName = ownerName != null ? ownerName : name;
        ItemStack item = MaterialUtil.getItem((String)material);
        if (item == null || !NumberUtil.isInteger((String)quantity)) {
            Messages.INVALID_SHOP_DETECTED.sendWithPrefix(sender, new String[0]);
            return true;
        }
        sender.sendMessage(Messages.prefix((String)(String.valueOf(ChatColor.GREEN) + "Besitzer: " + String.valueOf(ChatColor.WHITE) + ownerName)));
        sender.sendMessage(Messages.prefix((String)(String.valueOf(ChatColor.GREEN) + "Anzahl: " + String.valueOf(ChatColor.WHITE) + quantity)));
        sender.sendMessage(Messages.prefix((String)(String.valueOf(ChatColor.GREEN) + "Preis: " + String.valueOf(ChatColor.WHITE) + prices)));
        if (this.plugin.getShowItem() == null) {
            sender.sendMessage(Messages.prefix((String)(String.valueOf(ChatColor.GREEN) + "Item: " + String.valueOf(ChatColor.WHITE) + material)));
        } else {
            try {
                BukkitAudiences.create((Plugin)this.plugin).sender(sender).sendMessage(this.plugin.getShowItem().getItemConverter().createComponent(item, Level.OFF).toTextComponent((Player)sender));
            }
            catch (Exception e) {
                if (e.getClass().getSimpleName().equals("ItemDataTooLongException")) {
                    sender.sendMessage(Messages.prefix((String)(String.valueOf(ChatColor.GREEN) + "Item: " + String.valueOf(ChatColor.WHITE) + material + String.valueOf(ChatColor.RED) + " (Data too long)")));
                }
                this.plugin.getLogger().log(Level.WARNING, "Error while trying to show info of shop at " + lookingAt.getWorld().getName() + "/" + lookingAt.getX() + "/" + lookingAt.getY() + "/" + lookingAt.getZ() + ": " + e.getMessage());
            }
        }
        new ItemInfoEvent(sender, item).callEvent();
        return true;
    }
}

