/*
 * Decompiled with CFR 0.152.
 */
package de.themoep.chestshoptools;

import com.Acrobot.ChestShop.Configuration.Messages;
import de.themoep.ShowItem.api.ShowItem;
import de.themoep.chestshoptools.ShopInfoCommand;
import de.themoep.chestshoptools.manager.EmptyManager;
import de.themoep.chestshoptools.manager.EnchantManager;
import de.themoep.chestshoptools.manager.PotionManager;
import de.themoep.chestshoptools.manager.TradeManager;
import java.util.Map;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.plugin.java.JavaPlugin;

public class ChestShopTools
extends JavaPlugin {
    private EmptyManager emptMan;
    private EnchantManager enchMan;
    private PotionManager potMan;
    private TradeManager tradeMan;
    private ShowItem showItem = null;

    public void onEnable() {
        this.saveDefaultConfig();
        this.loadConfig();
        this.getServer().getPluginCommand("cstshopinfo").setExecutor((CommandExecutor)new ShopInfoCommand(this));
        if (this.getServer().getPluginManager().getPlugin("ShowItem") != null) {
            this.showItem = (ShowItem)this.getServer().getPluginManager().getPlugin("ShowItem");
        }
    }

    public void onDisable() {
        this.disableManagers();
    }

    public boolean onCommand(CommandSender sender, Command cmd, String commandLabel, String[] args) {
        if (args.length > 0 && args[0].equalsIgnoreCase("reload")) {
            this.loadConfig();
            sender.sendMessage(String.valueOf(ChatColor.GREEN) + "[CST] Reloaded Config");
            return true;
        }
        return false;
    }

    private void loadConfig() {
        this.reloadConfig();
        this.disableManagers();
        this.emptMan = new EmptyManager(this, this.getConfig().getConfigurationSection("removeempty"));
        this.enchMan = new EnchantManager(this, this.getConfig().getConfigurationSection("enchantsigns"));
        this.potMan = new PotionManager(this, this.getConfig().getConfigurationSection("potionsigns"));
        this.tradeMan = new TradeManager(this, this.getConfig().getConfigurationSection("tradeinfo"));
    }

    private void disableManagers() {
        if (this.emptMan != null) {
            this.emptMan.disable();
        }
        if (this.tradeMan != null) {
            this.tradeMan.disable();
        }
        if (this.enchMan != null) {
            this.enchMan.disable();
        }
        if (this.potMan != null) {
            this.potMan.disable();
        }
    }

    public String buildMsg(String msg, Map<String, String> replacements) {
        for (Map.Entry<String, String> entry : replacements.entrySet()) {
            msg = msg.replace("%" + entry.getKey() + "%", entry.getValue());
        }
        return Messages.prefix((String)msg);
    }

    public ShowItem getShowItem() {
        return this.showItem;
    }
}

