/*
 * Decompiled with CFR 0.152.
 */
package de.minebench.simpleafkkick;

import com.destroystokyo.paper.event.player.PlayerJumpEvent;
import io.papermc.paper.event.player.AsyncChatEvent;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockDamageEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.inventory.InventoryCreativeEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.event.inventory.InventoryOpenEvent;
import org.bukkit.event.player.PlayerAnimationEvent;
import org.bukkit.event.player.PlayerBedLeaveEvent;
import org.bukkit.event.player.PlayerCommandPreprocessEvent;
import org.bukkit.event.player.PlayerDropItemEvent;
import org.bukkit.event.player.PlayerFishEvent;
import org.bukkit.event.player.PlayerInteractAtEntityEvent;
import org.bukkit.event.player.PlayerInteractEntityEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerItemConsumeEvent;
import org.bukkit.event.player.PlayerItemHeldEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.player.PlayerToggleSneakEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scheduler.BukkitTask;

public class SimpleAfkKick
extends JavaPlugin
implements Listener {
    private Set<Listener> listeners = new HashSet<Listener>();
    private Map<UUID, Long> lastActive = new ConcurrentHashMap<UUID, Long>();
    private Component kickMessage;
    private boolean kickOnActive;
    private BukkitTask checkTask = null;

    public void onEnable() {
        this.loadConfig();
        this.getCommand("simpleafkkick").setExecutor((sender, command, label, args) -> {
            if (args.length > 0 && "reload".equalsIgnoreCase(args[0])) {
                this.loadConfig();
                sender.sendMessage(String.valueOf(ChatColor.GREEN) + "Reloaded the config!");
                return true;
            }
            return false;
        });
        this.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this);
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.MONITOR)
    public void onJoin(PlayerJoinEvent event) {
        this.updateActive((HumanEntity)event.getPlayer());
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onQuit(PlayerQuitEvent event) {
        this.lastActive.remove(event.getPlayer().getUniqueId());
    }

    private void updateActive(HumanEntity human) {
        Player player;
        if (this.kickOnActive && human instanceof Player && !(player = (Player)human).hasPermission("simpleafkkick.bypass")) {
            player.kick(this.kickMessage);
        } else {
            this.lastActive.put(human.getUniqueId(), System.currentTimeMillis());
        }
    }

    public void loadConfig() {
        this.saveDefaultConfig();
        this.reloadConfig();
        this.unregisterListeners();
        this.stopTask();
        String rawKickMessage = this.getConfig().getString("kick-message", "lang:multiplayer.disconnect.idling");
        this.kickMessage = rawKickMessage.startsWith("lang:") ? Component.translatable((String)rawKickMessage.substring("lang:".length())) : LegacyComponentSerializer.legacyAmpersand().deserialize(rawKickMessage);
        this.kickOnActive = this.getConfig().getBoolean("kick-on-active");
        if (this.startTask()) {
            this.registerListeners();
        }
    }

    private boolean startTask() {
        long checkInterval = this.getConfig().getLong("check-interval");
        if (checkInterval > 0L) {
            long afkTime = this.getConfig().getLong("afk-time");
            this.checkTask = this.getServer().getScheduler().runTaskTimer((Plugin)this, () -> {
                Iterator<Map.Entry<UUID, Long>> it = this.lastActive.entrySet().iterator();
                while (it.hasNext()) {
                    Map.Entry<UUID, Long> entry = it.next();
                    if (entry.getValue() + afkTime * 1000L >= System.currentTimeMillis()) continue;
                    Player player = this.getServer().getPlayer(entry.getKey());
                    if (player != null) {
                        if (player.hasPermission("simpleafkkick.bypass") || this.kickOnActive) continue;
                        player.kick(this.kickMessage);
                        it.remove();
                        continue;
                    }
                    it.remove();
                }
            }, checkInterval * 20L, checkInterval * 20L);
            return true;
        }
        return false;
    }

    private void stopTask() {
        if (this.checkTask != null) {
            this.checkTask.cancel();
            this.checkTask = null;
        }
    }

    private static boolean sameOrientation(Location l1, Location l2) {
        return l1.getYaw() == l2.getYaw() && l1.getPitch() == l2.getPitch();
    }

    private static boolean sameBlock(Location l1, Location l2) {
        return l1.getWorld() == l2.getWorld() && l1.getBlockX() == l2.getBlockX() && l1.getBlockY() == l2.getBlockY() && l1.getBlockZ() == l2.getBlockZ();
    }

    private void registerListener(Listener listener) {
        this.getServer().getPluginManager().registerEvents(listener, (Plugin)this);
        this.listeners.add(listener);
    }

    private void unregisterListeners() {
        for (Listener listener : this.listeners) {
            HandlerList.unregisterAll((Listener)listener);
        }
        this.listeners.clear();
    }

    private boolean shouldCheck(String type) {
        return this.getConfig().getBoolean("check." + type);
    }

    private void registerListeners() {
        if (this.shouldCheck("blocks")) {
            this.registerListener(new Listener(){

                @EventHandler
                public void onBlockPlace(BlockPlaceEvent event) {
                    SimpleAfkKick.this.updateActive((HumanEntity)event.getPlayer());
                }

                @EventHandler
                public void onBlockBreak(BlockBreakEvent event) {
                    SimpleAfkKick.this.updateActive((HumanEntity)event.getPlayer());
                }

                @EventHandler
                public void onBlockDamage(BlockDamageEvent event) {
                    SimpleAfkKick.this.updateActive((HumanEntity)event.getPlayer());
                }
            });
        }
        if (this.shouldCheck("move")) {
            final boolean checkOrientation = this.shouldCheck("orientation");
            this.registerListener(new Listener(){

                @EventHandler
                public void onMove(PlayerMoveEvent event) {
                    if (!(SimpleAfkKick.sameBlock(event.getFrom(), event.getTo()) || checkOrientation && SimpleAfkKick.sameOrientation(event.getFrom(), event.getTo()))) {
                        SimpleAfkKick.this.updateActive((HumanEntity)event.getPlayer());
                    }
                }
            });
        }
        if (this.shouldCheck("sneaking")) {
            this.registerListener(new Listener(){

                @EventHandler
                public void onSneak(PlayerToggleSneakEvent event) {
                    SimpleAfkKick.this.updateActive((HumanEntity)event.getPlayer());
                }
            });
        }
        if (this.shouldCheck("jumping")) {
            this.registerListener(new Listener(){

                @EventHandler
                public void onJump(PlayerJumpEvent event) {
                    SimpleAfkKick.this.updateActive((HumanEntity)event.getPlayer());
                }
            });
        }
        if (this.shouldCheck("Interact")) {
            this.registerListener(new Listener(){

                @EventHandler
                public void onInteract(PlayerInteractEvent event) {
                    SimpleAfkKick.this.updateActive((HumanEntity)event.getPlayer());
                }

                @EventHandler
                public void onInteract(PlayerInteractEntityEvent event) {
                    SimpleAfkKick.this.updateActive((HumanEntity)event.getPlayer());
                }

                @EventHandler
                public void onInteract(PlayerInteractAtEntityEvent event) {
                    SimpleAfkKick.this.updateActive((HumanEntity)event.getPlayer());
                }

                @EventHandler
                public void onInteract(PlayerAnimationEvent event) {
                    SimpleAfkKick.this.updateActive((HumanEntity)event.getPlayer());
                }

                @EventHandler
                public void onInteract(PlayerBedLeaveEvent event) {
                    SimpleAfkKick.this.updateActive((HumanEntity)event.getPlayer());
                }
            });
        }
        if (this.shouldCheck("inventory")) {
            this.registerListener(new Listener(){

                @EventHandler
                public void onInteract(InventoryClickEvent event) {
                    SimpleAfkKick.this.updateActive(event.getWhoClicked());
                }

                @EventHandler
                public void onInteract(InventoryCreativeEvent event) {
                    SimpleAfkKick.this.updateActive(event.getWhoClicked());
                }

                @EventHandler
                public void onInteract(InventoryDragEvent event) {
                    SimpleAfkKick.this.updateActive(event.getWhoClicked());
                }

                @EventHandler
                public void onInteract(InventoryOpenEvent event) {
                    SimpleAfkKick.this.updateActive(event.getPlayer());
                }

                @EventHandler
                public void onInteract(InventoryCloseEvent event) {
                    SimpleAfkKick.this.updateActive(event.getPlayer());
                }

                @EventHandler
                public void onInteract(PlayerDropItemEvent event) {
                    SimpleAfkKick.this.updateActive((HumanEntity)event.getPlayer());
                }

                @EventHandler
                public void onInteract(PlayerItemConsumeEvent event) {
                    SimpleAfkKick.this.updateActive((HumanEntity)event.getPlayer());
                }

                @EventHandler
                public void onInteract(PlayerItemHeldEvent event) {
                    SimpleAfkKick.this.updateActive((HumanEntity)event.getPlayer());
                }
            });
        }
        if (this.shouldCheck("fishing")) {
            this.registerListener(new Listener(){

                @EventHandler
                public void onFish(PlayerFishEvent event) {
                    SimpleAfkKick.this.updateActive((HumanEntity)event.getPlayer());
                }
            });
        }
        if (this.shouldCheck("commands")) {
            this.registerListener(new Listener(){

                @EventHandler
                public void onCommand(PlayerCommandPreprocessEvent event) {
                    SimpleAfkKick.this.updateActive((HumanEntity)event.getPlayer());
                }
            });
        }
        if (this.shouldCheck("chat")) {
            this.registerListener(new Listener(){

                @EventHandler
                public void onChat(AsyncChatEvent event) {
                    SimpleAfkKick.this.updateActive((HumanEntity)event.getPlayer());
                }
            });
        }
    }
}

