/*
 * Decompiled with CFR 0.152.
 */
package de.minebench.moblimit.libs.minedown;

import de.minebench.moblimit.libs.minedown.MineDown;
import de.minebench.moblimit.libs.minedown.Util;
import java.awt.Color;
import java.lang.reflect.Field;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.PrimitiveIterator;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import net.md_5.bungee.api.ChatColor;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.ClickEvent;
import net.md_5.bungee.api.chat.ComponentBuilder;
import net.md_5.bungee.api.chat.HoverEvent;
import net.md_5.bungee.api.chat.ItemTag;
import net.md_5.bungee.api.chat.TextComponent;
import net.md_5.bungee.api.chat.hover.content.Content;
import net.md_5.bungee.api.chat.hover.content.Entity;
import net.md_5.bungee.api.chat.hover.content.Item;
import net.md_5.bungee.api.chat.hover.content.Text;

public class MineDownParser {
    private static final String RAINBOW = "rainbow";
    private static final boolean HAS_APPEND_SUPPORT = Util.hasMethod(ComponentBuilder.class, "append", BaseComponent[].class);
    private static final boolean HAS_RGB_SUPPORT = Util.hasMethod(ChatColor.class, "of", String.class);
    private static final boolean HAS_FONT_SUPPORT = Util.hasMethod(ComponentBuilder.class, "font", String.class);
    private static final boolean HAS_INSERTION_SUPPORT = Util.hasMethod(ComponentBuilder.class, "insertion", String.class);
    private static final boolean HAS_HOVER_CONTENT_SUPPORT = Util.hasMethod(HoverEvent.class, "getContents", new Class[0]);
    private char colorChar = (char)38;
    private Set<Option> enabledOptions = EnumSet.of(Option.LEGACY_COLORS, Option.SIMPLE_FORMATTING, Option.ADVANCED_FORMATTING);
    private Set<Option> filteredOptions = EnumSet.noneOf(Option.class);
    private boolean lenient = false;
    private boolean backwardsCompatibility = true;
    private boolean urlDetection = true;
    private String urlHoverText = "Click to open url";
    private boolean autoAddUrlPrefix = true;
    private int hoverTextWidth = 60;
    public static final Pattern URL_PATTERN = Pattern.compile("^(?:(https?)://)?([-\\w_\\.]{1,}\\.[a-z]{2,18})(/\\S*)?$");
    private ComponentBuilder builder;
    private StringBuilder value;
    private String font;
    private String insertion;
    private Integer rainbowPhase;
    private List<Map.Entry<ChatColor, Boolean>> colors;
    private Map<ChatColor, Boolean> format;
    private boolean formattingIsLegacy = false;
    private ClickEvent clickEvent;
    private HoverEvent hoverEvent;

    public MineDownParser() {
        this.reset();
    }

    public ComponentBuilder parse(String message) throws IllegalArgumentException {
        Matcher urlMatcher = this.urlDetection() ? URL_PATTERN.matcher(message) : null;
        boolean escaped = false;
        for (int i = 0; i < message.length(); ++i) {
            boolean isFormatting;
            int definitionClose;
            char c = message.charAt(i);
            boolean isEscape = c == '\\' && i + 1 < message.length();
            boolean isColorCode = this.isEnabled(Option.LEGACY_COLORS) && i + 1 < message.length() && (c == '\u00a7' || c == this.colorChar());
            int eventEndIndex = -1;
            String eventDefinition = null;
            if (!escaped && this.isEnabled(Option.ADVANCED_FORMATTING) && c == '[' && (eventEndIndex = Util.getUnescapedEndIndex(message, '[', ']', i)) != -1 && message.length() > eventEndIndex + 1 && message.charAt(eventEndIndex + 1) == '(' && (definitionClose = Util.getUnescapedEndIndex(message, '(', ')', eventEndIndex + 1)) != -1) {
                eventDefinition = message.substring(eventEndIndex + 2, definitionClose);
            }
            boolean bl = isFormatting = this.isEnabled(Option.SIMPLE_FORMATTING) && (c == '_' || c == '*' || c == '~' || c == '?' || c == '#') && Util.isDouble(message, i) && message.indexOf(String.valueOf(c) + String.valueOf(c), i + 2) != -1;
            if (escaped) {
                escaped = false;
            } else {
                if (isEscape) {
                    escaped = true;
                    continue;
                }
                if (isColorCode) {
                    ChatColor byChar;
                    boolean isLegacyHex;
                    char code;
                    if ((code = message.charAt(++i)) >= 'A' && code <= 'Z') {
                        code = (char)(code + 32);
                    }
                    boolean bl2 = isLegacyHex = code == 'x';
                    if (isLegacyHex) {
                        i += 2;
                    }
                    Integer rainbowPhase = null;
                    List<Map.Entry<ChatColor, Boolean>> encoded = null;
                    Option filterOption = null;
                    StringBuilder colorString = new StringBuilder();
                    for (int j = i; j < message.length(); ++j) {
                        char c1 = message.charAt(j);
                        if (c1 == c) {
                            if (isLegacyHex) continue;
                            if (colorString.length() > 1) {
                                String colorStr = colorString.toString();
                                rainbowPhase = MineDownParser.parseRainbow(colorStr, "", this.lenient());
                                if (rainbowPhase == null && !colorStr.contains("=")) {
                                    encoded = MineDownParser.parseColor(colorStr, "", true, this.backwardsCompatibility());
                                    if (encoded.isEmpty()) {
                                        encoded = null;
                                        break;
                                    }
                                    filterOption = Option.SIMPLE_FORMATTING;
                                    i = j;
                                    break;
                                }
                                filterOption = Option.SIMPLE_FORMATTING;
                                i = j;
                                break;
                            }
                        }
                        if (!isLegacyHex && c1 != '_' && c1 != '#' && c1 != '-' && c1 != ',' && c1 != ':' & (c1 < 'A' || c1 > 'Z') && (c1 < 'a' || c1 > 'z') && (c1 < '0' || c1 > '9')) break;
                        if (isLegacyHex && c1 == 'x') continue;
                        colorString.append(c1);
                        if (!isLegacyHex || colorString.length() != 6) continue;
                        encoded = MineDownParser.parseColor("#" + colorString.toString(), "", true, this.backwardsCompatibility());
                        if (encoded.isEmpty()) {
                            encoded = null;
                            break;
                        }
                        filterOption = Option.LEGACY_COLORS;
                        i = j;
                        break;
                    }
                    if (rainbowPhase == null && encoded == null && (byChar = ChatColor.getByChar((char)code)) != null) {
                        filterOption = Option.LEGACY_COLORS;
                        encoded = new ArrayList<Map.Entry<ChatColor, Boolean>>();
                        encoded.add(new AbstractMap.SimpleEntry<ChatColor, Boolean>(byChar, true));
                    }
                    if (rainbowPhase != null || encoded != null) {
                        if (this.isFiltered(filterOption)) continue;
                        if (encoded != null && encoded.size() == 1) {
                            Map.Entry single = (Map.Entry)encoded.iterator().next();
                            if (single.getKey() == ChatColor.RESET) {
                                this.appendValue();
                                this.colors(new ArrayList<Map.Entry<ChatColor, Boolean>>());
                                this.rainbowPhase(null);
                                Util.applyFormat(this.builder(), this.format());
                                this.format(new HashMap<ChatColor, Boolean>());
                                continue;
                            }
                            if (!Util.isFormat((ChatColor)single.getKey())) {
                                if (this.value().length() > 0) {
                                    this.appendValue();
                                }
                                this.colors(new ArrayList<Map.Entry<ChatColor, Boolean>>());
                                this.colors().add(new AbstractMap.SimpleEntry<ChatColor, Boolean>((ChatColor)single.getKey(), (Boolean)single.getValue()));
                                this.rainbowPhase(null);
                                if (!this.formattingIsLegacy()) continue;
                                this.format(new HashMap<ChatColor, Boolean>());
                                continue;
                            }
                            if (this.value().length() > 0) {
                                this.appendValue();
                            }
                            this.formattingIsLegacy(true);
                            this.format().put((ChatColor)single.getKey(), (Boolean)single.getValue());
                            continue;
                        }
                        if (this.value().length() > 0) {
                            this.appendValue();
                        }
                        this.rainbowPhase(rainbowPhase);
                        this.colors(encoded);
                        if (!this.formattingIsLegacy()) continue;
                        this.format(new HashMap<ChatColor, Boolean>());
                        continue;
                    }
                    this.value().append(c).append(code);
                    continue;
                }
                if (eventEndIndex != -1 && eventDefinition != null) {
                    this.appendValue();
                    if (!this.isFiltered(Option.ADVANCED_FORMATTING) && !eventDefinition.isEmpty()) {
                        this.append(this.parseEvent(message.substring(i + 1, eventEndIndex), eventDefinition));
                    } else {
                        this.append(this.copy(true).parse(message.substring(i + 1, eventEndIndex)));
                    }
                    i = eventEndIndex + 2 + eventDefinition.length();
                    continue;
                }
                if (isFormatting) {
                    int endIndex = message.indexOf(String.valueOf(c) + String.valueOf(c), i + 2);
                    HashMap<ChatColor, Boolean> formats = new HashMap<ChatColor, Boolean>(this.format());
                    if (!this.isFiltered(Option.SIMPLE_FORMATTING)) {
                        formats.put(MineDown.getFormatFromChar(c), true);
                    }
                    this.formattingIsLegacy(false);
                    this.appendValue();
                    this.append(this.copy(true).format(formats).parse(message.substring(i + 2, endIndex)));
                    i = endIndex + 1;
                    continue;
                }
            }
            if (this.urlDetection() && urlMatcher != null) {
                int urlEnd = message.indexOf(32, i);
                if (urlEnd == -1) {
                    urlEnd = message.length();
                }
                if (urlMatcher.region(i, urlEnd).find()) {
                    this.appendValue();
                    this.value(new StringBuilder(message.substring(i, urlEnd)));
                    this.appendValue();
                    i = urlEnd - 1;
                    continue;
                }
            }
            this.value().append(message.charAt(i));
        }
        if (escaped) {
            this.value().append('\\');
        }
        this.appendValue();
        if (this.builder() == null) {
            this.builder(new ComponentBuilder(""));
        }
        return this.builder();
    }

    private void append(ComponentBuilder builder) {
        this.append(builder.create());
    }

    private void append(BaseComponent[] components) {
        block7: {
            block8: {
                block6: {
                    if (this.builder != null) break block6;
                    if (components.length > 0) {
                        this.builder = new ComponentBuilder(components[0]);
                        for (int i = 1; i < components.length; ++i) {
                            this.builder.append(components[i]);
                        }
                    } else {
                        this.builder = new ComponentBuilder("");
                    }
                    break block7;
                }
                if (!HAS_APPEND_SUPPORT) break block8;
                this.builder.append(components);
                break block7;
            }
            if (components.length <= 0) break block7;
            try {
                Field fCurrent = this.builder.getClass().getDeclaredField("current");
                fCurrent.setAccessible(true);
                BaseComponent previous = (BaseComponent)fCurrent.get(this.builder);
                Field fParts = this.builder.getClass().getDeclaredField("parts");
                fParts.setAccessible(true);
                List parts = (List)fParts.get(this.builder);
                for (BaseComponent component : components) {
                    parts.add(previous);
                    fCurrent.set(this.builder, component.duplicate());
                }
            }
            catch (IllegalAccessException | NoSuchFieldException e1) {
                e1.printStackTrace();
            }
        }
    }

    private void appendValue() {
        ComponentBuilder builder;
        List<Object> applicableColors;
        long valueCodepointLength = this.value.length();
        if (valueCodepointLength == 0L) {
            return;
        }
        if (this.rainbowPhase != null) {
            valueCodepointLength = this.value.codePoints().count();
            applicableColors = Util.createRainbow(valueCodepointLength, (int)this.rainbowPhase, HAS_RGB_SUPPORT);
        } else if (this.colors != null) {
            if (this.colors.size() > 1) {
                valueCodepointLength = this.value.codePoints().count();
                applicableColors = Util.createGradient(valueCodepointLength, this.colors.stream().filter(Map.Entry::getValue).map(Map.Entry::getKey).collect(Collectors.toList()), HAS_RGB_SUPPORT);
            } else {
                applicableColors = this.colors.stream().map(Map.Entry::getKey).collect(Collectors.toCollection(ArrayList::new));
            }
        } else {
            applicableColors = new ArrayList();
        }
        if (applicableColors.size() > 1) {
            builder = new ComponentBuilder();
        } else {
            builder = this.builder == null ? new ComponentBuilder(this.value.toString()) : this.builder.append(this.value.toString(), ComponentBuilder.FormatRetention.NONE);
            if (applicableColors.size() == 1) {
                builder.color((ChatColor)applicableColors.get(0));
            }
        }
        if (!this.backwardsCompatibility || HAS_FONT_SUPPORT) {
            builder.font(this.font);
        }
        if (!this.backwardsCompatibility || HAS_INSERTION_SUPPORT) {
            builder.insertion(this.insertion);
        }
        Util.applyFormat(builder, this.format);
        if (this.urlDetection() && URL_PATTERN.matcher(this.value).matches()) {
            String v = this.value.toString();
            if (!v.startsWith("http://") && !v.startsWith("https://")) {
                v = "http://" + v;
            }
            builder.event(new ClickEvent(ClickEvent.Action.OPEN_URL, v));
            if (this.urlHoverText() != null && !this.urlHoverText().isEmpty()) {
                builder.event(new HoverEvent(HoverEvent.Action.SHOW_TEXT, new MineDown(this.urlHoverText()).replace("url", this.value.toString()).toComponent()));
            }
        }
        if (this.clickEvent != null) {
            builder.event(this.clickEvent);
        }
        if (this.hoverEvent != null) {
            builder.event(this.hoverEvent);
        }
        if (applicableColors.size() > 1) {
            int stepLength = (int)Math.round((double)valueCodepointLength / (double)applicableColors.size());
            TextComponent component = new TextComponent();
            StringBuilder sb = new StringBuilder();
            int colorIndex = 0;
            int steps = 0;
            PrimitiveIterator.OfInt it = this.value.codePoints().iterator();
            while (it.hasNext()) {
                sb.appendCodePoint(it.next());
                if (++steps != stepLength) continue;
                steps = 0;
                TextComponent c = new TextComponent(sb.toString());
                c.setColor((ChatColor)applicableColors.get(colorIndex++));
                component.addExtra((BaseComponent)c);
                sb = new StringBuilder();
            }
            builder.append((BaseComponent)component);
            if (this.builder == null) {
                this.builder = builder;
            } else {
                this.builder.append(builder.create());
            }
        } else {
            this.builder = builder;
        }
        this.value = new StringBuilder();
    }

    /*
     * Unable to fully structure code
     */
    public ComponentBuilder parseEvent(String text, String definitions) {
        defParts = new ArrayList<String>();
        if (definitions.startsWith(" ")) {
            defParts.add("");
        }
        Collections.addAll(defParts, definitions.split(" "));
        if (definitions.endsWith(" ")) {
            defParts.add("");
        }
        font = null;
        insertion = null;
        rainbowPhase = null;
        colors = null;
        formats = new HashMap<ChatColor, Boolean>();
        clickEvent = null;
        hoverEvent = null;
        formatEnd = -1;
        i = new AtomicInteger(0);
        while (i.get() < defParts.size()) {
            definition = (String)defParts.get(i.get());
            parsedRainbowPhase = MineDownParser.parseRainbow(definition, "", this.lenient());
            if (parsedRainbowPhase != null) {
                rainbowPhase = parsedRainbowPhase;
            } else if (!definition.contains("=") && !(parsed = MineDownParser.parseColor(definition, "", true, this.backwardsCompatibility())).isEmpty()) {
                var16_16 = parsed.iterator();
                while (var16_16.hasNext()) {
                    e = var16_16.next();
                    if (Util.isFormat(e.getKey())) {
                        formats.put(e.getKey(), e.getValue());
                        continue;
                    }
                    if (colors == null) {
                        colors = new ArrayList<AbstractMap.SimpleEntry<ChatColor, Boolean>>();
                    }
                    colors.add(new AbstractMap.SimpleEntry<ChatColor, Boolean>(e.getKey(), e.getValue()));
                }
                formatEnd = i.get();
            } else if (definition.toLowerCase(Locale.ROOT).startsWith("font=")) {
                font = definition.substring("font=".length());
            } else if (definition.toLowerCase(Locale.ROOT).startsWith("insert=")) {
                insertion = this.getValue(i, definition.substring("insert=".length()), defParts, true);
            } else if (definition.toLowerCase(Locale.ROOT).startsWith("color=")) {
                rainbowPhase = MineDownParser.parseRainbow(definition, "color=", this.lenient());
                if (rainbowPhase == null) {
                    colors = MineDownParser.parseColor(definition, "color=", this.lenient(), this.backwardsCompatibility());
                    if (!this.lenient()) {
                        parsed = colors.iterator();
                        while (parsed.hasNext()) {
                            e = (Map.Entry)parsed.next();
                            if (!Util.isFormat((ChatColor)e.getKey())) continue;
                            throw new IllegalArgumentException(e + " is a format and not a color!");
                        }
                    }
                }
                formatEnd = i.get();
            } else if (definition.toLowerCase(Locale.ROOT).startsWith("format=")) {
                parsed = MineDownParser.parseColor(definition, "format=", this.lenient(), this.backwardsCompatibility());
                e = parsed.iterator();
                while (e.hasNext()) {
                    e = e.next();
                    if (Util.isFormat(e.getKey())) {
                        formats.put(e.getKey(), e.getValue());
                        continue;
                    }
                    if (this.lenient()) continue;
                    throw new IllegalArgumentException(e + " is a color and not a format!");
                }
                formatEnd = i.get();
            } else if (i.get() == formatEnd + 1 && MineDownParser.URL_PATTERN.matcher(definition).matches()) {
                if (!definition.startsWith("http://") && !definition.startsWith("https://")) {
                    definition = "http://" + definition;
                }
                clickEvent = new ClickEvent(ClickEvent.Action.OPEN_URL, definition);
            } else {
                clickAction = definition.startsWith("/") != false ? ClickEvent.Action.RUN_COMMAND : null;
                hoverAction = null;
                if (definition.toLowerCase(Locale.ROOT).startsWith("hover=")) {
                    hoverAction = HoverEvent.Action.SHOW_TEXT;
                }
                parts = definition.split("=", 2);
                try {
                    hoverAction = HoverEvent.Action.valueOf((String)parts[0].toUpperCase(Locale.ROOT));
                }
                catch (IllegalArgumentException var18_19) {
                    // empty catch block
                }
                try {
                    clickAction = ClickEvent.Action.valueOf((String)parts[0].toUpperCase(Locale.ROOT));
                }
                catch (IllegalArgumentException var18_20) {
                    // empty catch block
                }
                valueStr = this.getValue(i, parts.length > 1 ? parts[1] : "", defParts, clickAction != null || hoverAction != null);
                if (clickAction != null) {
                    if (this.autoAddUrlPrefix() && clickAction == ClickEvent.Action.OPEN_URL && !valueStr.startsWith("http://") && !valueStr.startsWith("https://")) {
                        valueStr = "http://" + valueStr;
                    }
                    clickEvent = new ClickEvent(clickAction, valueStr);
                } else if (hoverAction == null) {
                    hoverAction = HoverEvent.Action.SHOW_TEXT;
                }
                if (hoverAction != null) {
                    if (!MineDownParser.HAS_HOVER_CONTENT_SUPPORT) {
                        hoverEvent = new HoverEvent(hoverAction, this.copy(false).urlDetection(false).parse(hoverAction == HoverEvent.Action.SHOW_TEXT ? Util.wrap(valueStr, this.hoverTextWidth()) : valueStr).create());
                    } else if (hoverAction == HoverEvent.Action.SHOW_TEXT) {
                        hoverEvent = new HoverEvent(hoverAction, new Content[]{new Text(this.copy(false).urlDetection(false).parse(Util.wrap(valueStr, this.hoverTextWidth())).create())});
                    } else if (hoverAction == HoverEvent.Action.SHOW_ENTITY) {
                        valueParts = valueStr.split(":", 2);
                        try {
                            additionalParts = valueParts[1].split(" ", 2);
                            if (!additionalParts[0].contains(":")) {
                                additionalParts[0] = "minecraft:" + additionalParts[0];
                            }
                            hoverEvent = new HoverEvent(hoverAction, new Content[]{new Entity(additionalParts[0], valueParts[0], additionalParts.length > 1 && additionalParts[1] != null ? new TextComponent(this.copy(false).urlDetection(false).parse(additionalParts[1]).create()) : null)});
                        }
                        catch (Exception e) {
                            if (this.lenient()) ** GOTO lbl139
                            if (valueParts.length < 2) {
                                throw new IllegalArgumentException("Invalid entity definition. Needs to be of format uuid:id or uuid:namespace:id!");
                            }
                            throw new IllegalArgumentException(e.getMessage());
                        }
                    } else if (hoverAction == HoverEvent.Action.SHOW_ITEM) {
                        block53: {
                            valueParts = valueStr.split(" ", 2);
                            id = valueParts[0];
                            if (!id.contains(":")) {
                                id = "minecraft:" + id;
                            }
                            count = 1;
                            countIndex = valueParts[0].indexOf(42);
                            if (countIndex > 0 && countIndex + 1 < valueParts[0].length()) {
                                try {
                                    count = Integer.parseInt(valueParts[0].substring(countIndex + 1));
                                    id = valueParts[0].substring(0, countIndex);
                                }
                                catch (NumberFormatException e) {
                                    if (this.lenient()) break block53;
                                    throw new IllegalArgumentException(e.getMessage());
                                }
                            }
                        }
                        tag = null;
                        if (valueParts.length > 1 && valueParts[1] != null) {
                            tag = ItemTag.ofNbt((String)valueParts[1]);
                        }
                        hoverEvent = new HoverEvent(hoverAction, new Content[]{new Item(id, count, tag)});
                    }
                }
            }
lbl139:
            // 16 sources

            i.incrementAndGet();
        }
        if (clickEvent != null && hoverEvent == null) {
            hoverEvent = new HoverEvent(HoverEvent.Action.SHOW_TEXT, new ComponentBuilder(clickEvent.getAction().toString().toLowerCase(Locale.ROOT).replace('_', ' ')).color(ChatColor.BLUE).append(" " + clickEvent.getValue()).color(ChatColor.WHITE).create());
        }
        return this.copy().urlDetection(false).font(font).insertion(insertion).rainbowPhase(rainbowPhase).colors(colors).format(formats).clickEvent(clickEvent).hoverEvent(hoverEvent).parse(text);
    }

    private String getValue(AtomicInteger i, String firstPart, List<String> defParts, boolean hasAction) {
        int bracketDepth = !firstPart.isEmpty() && firstPart.startsWith("{") && hasAction ? 1 : 0;
        StringBuilder value = new StringBuilder();
        if (!firstPart.isEmpty() && hasAction) {
            if (bracketDepth > 0) {
                value.append(firstPart.substring(1));
            } else {
                value.append(firstPart);
            }
        } else {
            value.append(defParts.get(i.get()));
        }
        i.incrementAndGet();
        while (i.get() < defParts.size()) {
            int equalsIndex;
            String part = defParts.get(i.get());
            if (bracketDepth == 0 && (equalsIndex = part.indexOf(61)) > 0 && !Util.isEscaped(part, equalsIndex)) {
                i.decrementAndGet();
                break;
            }
            value.append(" ");
            if (bracketDepth > 0) {
                int startBracketIndex = part.indexOf("={");
                if (startBracketIndex > 0 && !Util.isEscaped(part, startBracketIndex) && !Util.isEscaped(part, startBracketIndex + 1)) {
                    ++bracketDepth;
                }
                if (part.endsWith("}") && !Util.isEscaped(part, part.length() - 1) && --bracketDepth == 0) {
                    value.append(part, 0, part.length() - 1);
                    break;
                }
            }
            value.append(part);
            i.incrementAndGet();
        }
        return value.toString();
    }

    protected ComponentBuilder builder() {
        return this.builder;
    }

    protected MineDownParser builder(ComponentBuilder builder) {
        this.builder = builder;
        return this;
    }

    protected MineDownParser value(StringBuilder value) {
        this.value = value;
        return this;
    }

    protected StringBuilder value() {
        return this.value;
    }

    private MineDownParser font(String font) {
        this.font = font;
        return this;
    }

    protected String font() {
        return this.font;
    }

    private MineDownParser insertion(String insertion) {
        this.insertion = insertion;
        return this;
    }

    protected String insertion() {
        return this.insertion;
    }

    protected MineDownParser rainbowPhase(Integer rainbowPhase) {
        this.rainbowPhase = rainbowPhase;
        return this;
    }

    protected Integer rainbowPhase() {
        return this.rainbowPhase;
    }

    protected MineDownParser colors(List<Map.Entry<ChatColor, Boolean>> colors) {
        this.colors = colors;
        return this;
    }

    protected List<Map.Entry<ChatColor, Boolean>> colors() {
        return this.colors;
    }

    protected MineDownParser format(Map<ChatColor, Boolean> format) {
        this.format = format;
        return this;
    }

    protected Map<ChatColor, Boolean> format() {
        return this.format;
    }

    protected MineDownParser formattingIsLegacy(boolean formattingIsLegacy) {
        this.formattingIsLegacy = formattingIsLegacy;
        return this;
    }

    protected boolean formattingIsLegacy() {
        return this.formattingIsLegacy;
    }

    protected MineDownParser clickEvent(ClickEvent clickEvent) {
        this.clickEvent = clickEvent;
        return this;
    }

    protected ClickEvent clickEvent() {
        return this.clickEvent;
    }

    protected MineDownParser hoverEvent(HoverEvent hoverEvent) {
        this.hoverEvent = hoverEvent;
        return this;
    }

    protected HoverEvent hoverEvent() {
        return this.hoverEvent;
    }

    private static Integer parseRainbow(String colorString, String prefix, boolean lenient) {
        if (colorString.substring(prefix.length()).toLowerCase(Locale.ROOT).startsWith(RAINBOW)) {
            if (colorString.length() > prefix.length() + RAINBOW.length() + 1) {
                try {
                    return Integer.parseInt(colorString.substring(prefix.length() + RAINBOW.length() + 1));
                }
                catch (NumberFormatException e) {
                    if (!lenient) {
                        throw e;
                    }
                }
            } else {
                return 0;
            }
        }
        return null;
    }

    /*
     * Unable to fully structure code
     */
    private static List<Map.Entry<ChatColor, Boolean>> parseColor(String colorString, String prefix, boolean lenient, boolean backwardsCompatibility) {
        colors = new ArrayList<Map.Entry<ChatColor, Boolean>>();
        if (prefix.length() + 1 == colorString.length()) {
            color = ChatColor.getByChar((char)colorString.charAt(prefix.length()));
            if (color == null && !lenient) {
                throw new IllegalArgumentException(colorString.charAt(prefix.length()) + " is not a valid " + prefix + " char!");
            }
            colors.add(new AbstractMap.SimpleEntry<ChatColor, Boolean>(color, true));
        } else {
            for (String part : colorString.substring(prefix.length()).split("[\\-,]")) {
                if (part.isEmpty()) continue;
                v0 = negated = part.charAt(0) == '!';
                if (negated) {
                    part = part.substring(1);
                }
                if (part.charAt(0) == '#') {
                    if (part.length() == 4) {
                        sb = new StringBuilder("#");
                        for (i = 1; i < 4; ++i) {
                            sb.append(part.charAt(i)).append(part.charAt(i));
                        }
                        part = sb.toString();
                    }
                    color = null;
                    if (!backwardsCompatibility || MineDownParser.HAS_RGB_SUPPORT) {
                        try {
                            color = ChatColor.of((String)part);
                        }
                        catch (IllegalArgumentException e) {
                            if (lenient) ** GOTO lbl31
                            throw e;
                        }
                    } else {
                        color = Util.getClosestLegacy(new Color(Integer.parseInt(part.substring(1), 16)));
                    }
lbl31:
                    // 3 sources

                    if (color == null) continue;
                    colors.add(new AbstractMap.SimpleEntry<ChatColor, Boolean>(color, negated == false));
                    continue;
                }
                try {
                    colors.add(new AbstractMap.SimpleEntry<ChatColor, Boolean>(ChatColor.valueOf((String)part.toUpperCase(Locale.ROOT)), negated == false));
                }
                catch (IllegalArgumentException e) {
                    if (lenient) continue;
                    throw e;
                }
            }
        }
        return colors;
    }

    public MineDownParser copy() {
        return this.copy(false);
    }

    public MineDownParser copy(boolean formatting) {
        return new MineDownParser().copy(this, formatting);
    }

    public MineDownParser copy(MineDownParser from) {
        return this.copy(from, false);
    }

    public MineDownParser copy(MineDownParser from, boolean formatting) {
        this.lenient(from.lenient());
        this.urlDetection(from.urlDetection());
        this.urlHoverText(from.urlHoverText());
        this.autoAddUrlPrefix(from.autoAddUrlPrefix());
        this.hoverTextWidth(from.hoverTextWidth());
        this.enabledOptions(from.enabledOptions());
        this.filteredOptions(from.filteredOptions());
        this.colorChar(from.colorChar());
        if (formatting) {
            this.format(from.format());
            this.formattingIsLegacy(from.formattingIsLegacy());
            this.colors(from.colors());
            this.font(from.font());
            this.insertion(from.insertion());
            this.clickEvent(from.clickEvent());
            this.hoverEvent(from.hoverEvent());
        }
        return this;
    }

    public MineDownParser reset() {
        this.builder = null;
        this.value = new StringBuilder();
        this.font = null;
        this.insertion = null;
        this.colors = null;
        this.format = new HashMap<ChatColor, Boolean>();
        this.clickEvent = null;
        this.hoverEvent = null;
        return this;
    }

    @Deprecated
    public boolean translateLegacyColors() {
        return this.isEnabled(Option.LEGACY_COLORS);
    }

    @Deprecated
    public MineDownParser translateLegacyColors(boolean enabled) {
        return enabled ? this.enable(Option.LEGACY_COLORS) : this.disable(Option.LEGACY_COLORS);
    }

    public boolean isEnabled(Option option) {
        return this.enabledOptions().contains((Object)option);
    }

    public MineDownParser enable(Option option) {
        this.enabledOptions().add(option);
        return this;
    }

    public MineDownParser disable(Option option) {
        this.enabledOptions().remove((Object)option);
        return this;
    }

    public boolean isFiltered(Option option) {
        return this.filteredOptions().contains((Object)option);
    }

    public MineDownParser filter(Option option) {
        this.filteredOptions().add(option);
        this.enabledOptions().add(option);
        return this;
    }

    public MineDownParser unfilter(Option option) {
        this.filteredOptions().remove((Object)option);
        return this;
    }

    public String escape(String string) {
        StringBuilder value = new StringBuilder();
        for (int i = 0; i < string.length(); ++i) {
            boolean isFormatting;
            char c = string.charAt(i);
            boolean isEscape = c == '\\';
            boolean isColorCode = this.isEnabled(Option.LEGACY_COLORS) && i + 1 < string.length() && (c == '\u00a7' || c == this.colorChar());
            boolean isEvent = this.isEnabled(Option.ADVANCED_FORMATTING) && c == '[';
            boolean bl = isFormatting = this.isEnabled(Option.SIMPLE_FORMATTING) && (c == '_' || c == '*' || c == '~' || c == '?' || c == '#') && Util.isDouble(string, i);
            if (isEscape || isColorCode || isEvent || isFormatting) {
                value.append('\\');
            }
            value.append(c);
        }
        return value.toString();
    }

    public char colorChar() {
        return this.colorChar;
    }

    public MineDownParser colorChar(char colorChar) {
        this.colorChar = colorChar;
        return this;
    }

    public Set<Option> enabledOptions() {
        return this.enabledOptions;
    }

    public MineDownParser enabledOptions(Set<Option> enabledOptions) {
        this.enabledOptions = enabledOptions;
        return this;
    }

    public Set<Option> filteredOptions() {
        return this.filteredOptions;
    }

    public MineDownParser filteredOptions(Set<Option> filteredOptions) {
        this.filteredOptions = filteredOptions;
        return this;
    }

    public boolean lenient() {
        return this.lenient;
    }

    public MineDownParser lenient(boolean lenient) {
        this.lenient = lenient;
        return this;
    }

    public boolean backwardsCompatibility() {
        return this.backwardsCompatibility;
    }

    public MineDownParser backwardsCompatibility(boolean backwardsCompatibility) {
        this.backwardsCompatibility = backwardsCompatibility;
        return this;
    }

    public boolean urlDetection() {
        return this.urlDetection;
    }

    public MineDownParser urlDetection(boolean urlDetection) {
        this.urlDetection = urlDetection;
        return this;
    }

    public String urlHoverText() {
        return this.urlHoverText;
    }

    public MineDownParser urlHoverText(String urlHoverText) {
        this.urlHoverText = urlHoverText;
        return this;
    }

    public boolean autoAddUrlPrefix() {
        return this.autoAddUrlPrefix;
    }

    public MineDownParser autoAddUrlPrefix(boolean autoAddUrlPrefix) {
        this.autoAddUrlPrefix = autoAddUrlPrefix;
        return this;
    }

    public int hoverTextWidth() {
        return this.hoverTextWidth;
    }

    public MineDownParser hoverTextWidth(int hoverTextWidth) {
        this.hoverTextWidth = hoverTextWidth;
        return this;
    }

    public static enum Option {
        SIMPLE_FORMATTING,
        ADVANCED_FORMATTING,
        LEGACY_COLORS;

    }
}

