/*
 * Decompiled with CFR 0.152.
 */
package de.minebench.moblimit.adapter;

import com.destroystokyo.paper.event.entity.PreCreatureSpawnEvent;
import de.minebench.moblimit.MobLimit;
import de.minebench.moblimit.SpawningSettings;
import de.minebench.moblimit.adapter.PlatformAdapter;
import java.util.Collection;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.CreatureSpawnEvent;

public class PaperAdapter
implements Listener,
PlatformAdapter {
    private MobLimit plugin;

    public PaperAdapter(MobLimit plugin) {
        this.plugin = plugin;
    }

    @EventHandler(ignoreCancelled=true)
    public void entitySpawn(PreCreatureSpawnEvent event) {
        SpawningSettings settings;
        MobLimit.PRE_SPAWN_HANDLED.put((Object)event.getReason(), (Object)event.getType());
        if (event.getReason() == CreatureSpawnEvent.SpawnReason.NATURAL) {
            if (this.plugin.getGlobalLimit() >= 0 && event.getSpawnLocation().getWorld().getEntityCount() > this.plugin.getGlobalLimit()) {
                event.setCancelled(true);
                event.setShouldAbortSpawn(true);
                return;
            }
            if (this.plugin.getChunkLimit() >= 0 && event.getSpawnLocation().getChunk().getEntities().length > this.plugin.getChunkLimit()) {
                event.setCancelled(true);
                event.setShouldAbortSpawn(true);
                return;
            }
        }
        if ((settings = this.plugin.getSettings(event.getReason(), event.getType())) != null && (settings.getCount() == 0 || settings.getChunk() > -1 && event.getSpawnLocation().getChunk().getEntities().length >= settings.getChunk() || settings.getCount() > -1 && settings.getRadius() > 0 && event.getSpawnLocation().getNearbyEntitiesByType(event.getType().getEntityClass(), (double)settings.getRadius()).size() > settings.getCount())) {
            event.setCancelled(true);
            event.setShouldAbortSpawn(true);
        }
    }

    @Override
    public Collection<? extends Entity> getNearbyEntitiesByType(Location location, Class<? extends Entity> entityClass, int radius) {
        return location.getNearbyEntitiesByType(entityClass, (double)radius);
    }
}

