/*
 * Decompiled with CFR 0.152.
 */
package de.minebench.moblimit;

import de.minebench.moblimit.MobLimit;
import de.minebench.moblimit.SpawningSettings;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Mob;
import org.bukkit.entity.PigZombie;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.EntityBreedEvent;
import org.bukkit.event.entity.EntityPlaceEvent;

public class MobLimitListener
implements Listener {
    private final MobLimit plugin;

    public MobLimitListener(MobLimit plugin) {
        this.plugin = plugin;
    }

    @EventHandler(ignoreCancelled=true)
    public void entitySpawn(CreatureSpawnEvent event) {
        SpawningSettings settings;
        boolean preSpawnHandled;
        boolean bl = preSpawnHandled = MobLimit.IS_PAPER && MobLimit.PRE_SPAWN_HANDLED.containsEntry((Object)event.getSpawnReason(), (Object)event.getEntity().getType());
        if (!preSpawnHandled && event.getSpawnReason() == CreatureSpawnEvent.SpawnReason.NATURAL) {
            if (this.plugin.getGlobalLimit() >= 0 && event.getLocation().getWorld().getEntityCount() > this.plugin.getGlobalLimit()) {
                event.setCancelled(true);
                return;
            }
            if (this.plugin.getChunkLimit() >= 0 && event.getLocation().getChunk().getEntities().length > this.plugin.getChunkLimit()) {
                event.setCancelled(true);
                return;
            }
        }
        if ((settings = this.plugin.getSettings(event.getSpawnReason(), event.getEntity().getType())) != null) {
            if (!preSpawnHandled && (settings.getCount() == 0 || settings.getChunk() > -1 && event.getLocation().getChunk().getEntities().length >= settings.getChunk() || settings.getCount() > -1 && settings.getRadius() > 0 && this.plugin.getPlatformAdapter().getNearbyEntitiesByType(event.getLocation(), event.getEntity().getClass(), settings.getRadius()).size() > settings.getCount())) {
                event.setCancelled(true);
                return;
            }
            if (settings.isDumb()) {
                if (event.getEntity() instanceof Mob) {
                    ((Mob)event.getEntity()).setAware(false);
                } else {
                    event.getEntity().setAI(false);
                }
            }
        }
        if (event.getSpawnReason() == CreatureSpawnEvent.SpawnReason.NETHER_PORTAL && event.getEntity() instanceof PigZombie) {
            PigZombie pigZombie = (PigZombie)event.getEntity();
            pigZombie.setAngry(false);
            if (settings != null && settings.isDumb()) {
                int[][] relatives;
                Block down = event.getLocation().getBlock().getRelative(BlockFace.DOWN);
                for (int[] relative : relatives = new int[][]{{0, 0}, {0, 1}, {1, 1}, {1, 0}, {1, -1}, {0, -1}, {-1, -1}, {-1, 0}, {-1, 1}}) {
                    Block rel = down.getRelative(relative[0], 0, relative[1]);
                    if (!MobLimit.NONSOLID_SOLID.contains(rel.getType())) continue;
                    pigZombie.teleport(rel.getLocation().add(0.5, 0.5, 0.5));
                    break;
                }
            }
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onBreeding(EntityBreedEvent event) {
        SpawningSettings settings;
        if (event.getBreeder() != null && (settings = this.plugin.getSettings(CreatureSpawnEvent.SpawnReason.BREEDING, event.getEntity().getType())) != null) {
            int count = -1;
            if (settings.getChunk() > -1 && event.getEntity().getLocation().getChunk().getEntities().length >= settings.getChunk()) {
                count = settings.getChunk();
            } else if (settings.getCount() > -1 && settings.getRadius() > 0 && this.plugin.getPlatformAdapter().getNearbyEntitiesByType(event.getEntity().getLocation(), event.getEntity().getType().getEntityClass(), settings.getRadius()).size() > settings.getCount()) {
                count = settings.getCount();
            }
            if (count > -1) {
                event.setCancelled(true);
                event.setExperience(0);
                event.getBreeder().spigot().sendMessage(this.plugin.getMessage((CommandSender)event.getBreeder(), "aborted-breeding", "amount", String.valueOf(count)));
            } else if (settings.isDumb()) {
                if (event.getEntity() instanceof Mob) {
                    ((Mob)event.getEntity()).setAware(false);
                } else {
                    event.getEntity().setAI(false);
                }
            }
        }
    }

    @EventHandler
    public void onPlace(EntityPlaceEvent event) {
        SpawningSettings settings = this.plugin.getSettings(CreatureSpawnEvent.SpawnReason.CUSTOM, event.getEntity().getType());
        if (settings != null) {
            int count = -1;
            if (settings.getChunk() > -1 && event.getEntity().getLocation().getChunk().getEntities().length >= settings.getChunk()) {
                count = settings.getChunk();
            } else if (settings.getCount() > -1 && settings.getRadius() > 0 && this.plugin.getPlatformAdapter().getNearbyEntitiesByType(event.getEntity().getLocation(), event.getEntity().getType().getEntityClass(), settings.getRadius()).size() > settings.getCount()) {
                count = settings.getCount();
            }
            if (count > -1) {
                event.setCancelled(true);
                event.getPlayer().spigot().sendMessage(this.plugin.getMessage((CommandSender)event.getPlayer(), "aborted-place", "amount", String.valueOf(count)));
            }
        }
    }
}

