/*
 * Decompiled with CFR 0.152.
 */
package de.minebench.moblimit;

import de.minebench.moblimit.MobLimit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;

public class MobLimitCommand
implements CommandExecutor {
    private MobLimit plugin;

    public MobLimitCommand(MobLimit plugin) {
        this.plugin = plugin;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (args.length > 0) {
            if ("reload".equalsIgnoreCase(args[0]) && sender.hasPermission("moblimit.command.reload")) {
                this.plugin.loadConfig();
                sender.sendMessage("Reloaded!");
                return true;
            }
            if ("set".equalsIgnoreCase(args[0]) && sender.hasPermission("moblimit.command.set")) {
                block9: {
                    if (args.length < 2) {
                        this.usage(sender);
                        return true;
                    }
                    try {
                        int value = Integer.parseInt(args[1]);
                        if (args[0].equals("chunk")) {
                            this.plugin.setChunkLimit(value);
                            sender.sendMessage("Set chunk limit to " + value);
                            break block9;
                        }
                        if (args[0].equals("global")) {
                            this.plugin.setGlobalLimit(value);
                            sender.sendMessage("Set global limit to " + value);
                            break block9;
                        }
                        this.usage(sender);
                        return true;
                    }
                    catch (NumberFormatException e) {
                        if (args[0].equals("purge")) {
                            this.plugin.setPurging("true".equals(args[1]));
                            sender.sendMessage("Set purging to " + this.plugin.isPurging());
                        }
                        this.usage(sender);
                    }
                }
                return true;
            }
        }
        sender.sendMessage(this.plugin.getCurrentStateMessage().toArray(new String[0]));
        return true;
    }

    private void usage(CommandSender sender) {
        sender.sendMessage(new String[]{"Usage: /moblimit reload", "Usage: /moblimit set chunk|global <value>", "Usage: /moblimit set purge false|true", "Note: chunklimit counts all entities in a chunk!", "Note: purge will remove hostile/ambient mobs on chunkload"});
    }
}

