/*
 * Decompiled with CFR 0.152.
 */
package de.minebench.moblimit;

import com.google.common.collect.Multimap;
import com.google.common.collect.MultimapBuilder;
import com.google.common.collect.SetMultimap;
import de.minebench.moblimit.MobLimitCommand;
import de.minebench.moblimit.MobLimitListener;
import de.minebench.moblimit.SpawningSettings;
import de.minebench.moblimit.adapter.PaperAdapter;
import de.minebench.moblimit.adapter.PlatformAdapter;
import de.minebench.moblimit.adapter.SpigotAdapter;
import de.minebench.moblimit.libs.lang.bukkit.BukkitLanguageConfig;
import de.minebench.moblimit.libs.lang.bukkit.LanguageManager;
import de.minebench.moblimit.libs.minedown.MineDown;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import net.md_5.bungee.api.chat.BaseComponent;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.Tag;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Ambient;
import org.bukkit.entity.Animals;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Monster;
import org.bukkit.entity.WaterMob;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public final class MobLimit
extends JavaPlugin {
    static final Set<Material> NONSOLID_SOLID = EnumSet.of(Material.LADDER, new Material[]{Material.OAK_SIGN, Material.ACACIA_SIGN, Material.BIRCH_SIGN, Material.DARK_OAK_SIGN, Material.JUNGLE_SIGN, Material.SPRUCE_SIGN, Material.OAK_WALL_SIGN, Material.ACACIA_WALL_SIGN, Material.BIRCH_WALL_SIGN, Material.DARK_OAK_WALL_SIGN, Material.JUNGLE_WALL_SIGN, Material.SPRUCE_WALL_SIGN, Material.SPRUCE_TRAPDOOR, Material.OAK_TRAPDOOR, Material.SPRUCE_TRAPDOOR, Material.BIRCH_TRAPDOOR, Material.DARK_OAK_TRAPDOOR, Material.JUNGLE_TRAPDOOR});
    static final Set<Class<? extends Entity>> HOSTILE_MOBS = new HashSet<Class>(Arrays.asList(EntityType.MAGMA_CUBE.getEntityClass(), EntityType.SLIME.getEntityClass()));
    static final Set<Class<? extends Entity>> AMBIENT_MOBS = new HashSet<Class<? extends Entity>>();
    static final Set<Class<? extends Entity>> WATER_MOBS = new HashSet<Class<? extends Entity>>();
    static final Set<Class<? extends Entity>> PEACEFUL_MOBS = new HashSet<Class>(Arrays.asList(EntityType.VILLAGER.getEntityClass()));
    static final boolean IS_PAPER;
    public static final Multimap<CreatureSpawnEvent.SpawnReason, EntityType> PRE_SPAWN_HANDLED;
    private int chunkLimit = 20;
    private int globalLimit = 2500;
    private boolean purge = true;
    private Map<CreatureSpawnEvent.SpawnReason, ReasonSettings> spawningSettings;
    private LanguageManager lang;
    private PlatformAdapter platformAdapter;

    public void onEnable() {
        this.loadConfig();
        this.lang = new LanguageManager((Plugin)this, "en", new BukkitLanguageConfig[0]);
        this.getCommand("moblimit").setExecutor((CommandExecutor)new MobLimitCommand(this));
        this.getServer().getPluginManager().registerEvents((Listener)new MobLimitListener(this), (Plugin)this);
        if (IS_PAPER) {
            this.getLogger().log(Level.INFO, "Paper detected. Using more efficient events and methods.");
            this.getServer().getPluginManager().registerEvents((Listener)new PaperAdapter(this), (Plugin)this);
            this.platformAdapter = new PaperAdapter(this);
        } else {
            this.platformAdapter = new SpigotAdapter(this);
        }
        this.checkSpawnTick("monster", this.getServer().getTicksPerMonsterSpawns(), 10);
        this.checkSpawnTick("animals", this.getServer().getTicksPerAnimalSpawns(), 400);
        this.checkSpawnTick("water-animals", this.getServer().getTicksPerWaterSpawns(), 40);
        this.checkSpawnTick("water-ambient", this.getServer().getTicksPerWaterAmbientSpawns(), 40);
        this.checkSpawnTick("ambient", this.getServer().getTicksPerAmbientSpawns(), 40);
    }

    private void checkSpawnTick(String type, int ticks, int target) {
        if (ticks < target) {
            this.getLogger().log(Level.WARNING, "Your " + type + " spawning ticks are pretty low (" + ticks + "). Set ticks-per." + type + " to " + target + " in your bukkit.yml to improve performance!");
        }
    }

    public void loadConfig() {
        this.saveDefaultConfig();
        this.reloadConfig();
        this.chunkLimit = this.getConfig().getInt("chunk");
        this.globalLimit = this.getConfig().getInt("global");
        this.purge = this.getConfig().getBoolean("purge");
        this.spawningSettings = new EnumMap<CreatureSpawnEvent.SpawnReason, ReasonSettings>(CreatureSpawnEvent.SpawnReason.class);
        for (CreatureSpawnEvent.SpawnReason spawnReason : CreatureSpawnEvent.SpawnReason.values()) {
            if (!this.getConfig().isConfigurationSection("reasons." + spawnReason.name().toLowerCase())) continue;
            this.spawningSettings.put(spawnReason, new ReasonSettings(this.getConfig().getConfigurationSection("reasons." + spawnReason.name().toLowerCase())));
        }
        if (this.getConfig().isConfigurationSection("reasons.place")) {
            this.spawningSettings.put(CreatureSpawnEvent.SpawnReason.CUSTOM, new ReasonSettings(this.getConfig().getConfigurationSection("reasons.place")));
        }
        this.getLogger().log(Level.INFO, String.join((CharSequence)"\n", this.getCurrentStateMessage()));
    }

    public SpawningSettings getSettings(CreatureSpawnEvent.SpawnReason reason, EntityType type) {
        ReasonSettings reasonSettings = this.spawningSettings.get(reason);
        if (reasonSettings != null) {
            return reasonSettings.getSpawningSettings().getOrDefault(type, reasonSettings);
        }
        return null;
    }

    public void setGlobalLimit(int globalLimit) {
        this.globalLimit = globalLimit;
        this.getConfig().set("global", (Object)globalLimit);
        this.saveConfig();
    }

    public int getGlobalLimit() {
        return this.globalLimit;
    }

    public void setChunkLimit(int chunkLimit) {
        this.chunkLimit = chunkLimit;
        this.getConfig().set("chunk", (Object)chunkLimit);
        this.saveConfig();
    }

    public int getChunkLimit() {
        return this.chunkLimit;
    }

    public void setPurging(boolean purge) {
        this.purge = purge;
        this.getConfig().set("purge", (Object)purge);
        this.saveConfig();
    }

    public boolean isPurging() {
        return this.purge;
    }

    public Map<CreatureSpawnEvent.SpawnReason, ReasonSettings> getSpawningSettings() {
        return this.spawningSettings;
    }

    public List<String> getCurrentStateMessage() {
        ArrayList<String> message = new ArrayList<String>();
        Collections.addAll(message, ChatColor.BOLD + "Moblimits:", "Global limit: " + (this.getGlobalLimit() == 0 ? "disabled" : Integer.valueOf(this.getGlobalLimit())), "Chunk limit: " + (this.getChunkLimit() == 0 ? "disabled" : Integer.valueOf(this.getChunkLimit())), "Chunk purging: " + this.isPurging());
        for (Map.Entry<CreatureSpawnEvent.SpawnReason, ReasonSettings> entry : this.getSpawningSettings().entrySet()) {
            ArrayList<String> reasonValues = new ArrayList<String>();
            if (entry.getValue().getChunk() > -1) {
                reasonValues.add("  Chunk Limit: " + entry.getValue().getChunk());
            }
            if (entry.getValue().getCount() > -1) {
                reasonValues.add("  Count: " + entry.getValue().getCount());
            }
            if (entry.getValue().getRadius() > 0) {
                reasonValues.add("  Radius: " + entry.getValue().getRadius());
            }
            if (entry.getValue().isDumb()) {
                reasonValues.add("  Dumb: " + entry.getValue().isDumb());
            }
            for (Map.Entry<EntityType, SpawningSettings> settingsEntry : entry.getValue().getSpawningSettings().entrySet()) {
                ArrayList<String> typeReasonValues = new ArrayList<String>();
                if (settingsEntry.getValue().getChunk() > -1) {
                    typeReasonValues.add("    Chunk Limit: " + settingsEntry.getValue().getChunk());
                }
                if (settingsEntry.getValue().getCount() > -1) {
                    typeReasonValues.add("    Count: " + settingsEntry.getValue().getCount());
                }
                if (settingsEntry.getValue().getRadius() > 0) {
                    typeReasonValues.add("    Radius: " + settingsEntry.getValue().getRadius());
                }
                if (settingsEntry.getValue().isDumb()) {
                    typeReasonValues.add("    Dumb: " + settingsEntry.getValue().isDumb());
                }
                if (typeReasonValues.isEmpty()) continue;
                reasonValues.add("  " + settingsEntry.getKey().name() + ":");
                reasonValues.addAll(typeReasonValues);
            }
            if (reasonValues.isEmpty()) continue;
            message.add(entry.getKey().name() + ":");
            message.addAll(reasonValues);
        }
        return message;
    }

    public BaseComponent[] getMessage(CommandSender sender, String key, String ... replacements) {
        return MineDown.parse(this.lang.getConfig(sender).get(key), replacements);
    }

    public PlatformAdapter getPlatformAdapter() {
        return this.platformAdapter;
    }

    static {
        NONSOLID_SOLID.addAll(Tag.TRAPDOORS.getValues());
        for (EntityType type : EntityType.values()) {
            if (type.getEntityClass() == null) continue;
            if (Animals.class.isAssignableFrom(type.getEntityClass())) {
                PEACEFUL_MOBS.add(type.getEntityClass());
                continue;
            }
            if (Ambient.class.isAssignableFrom(type.getEntityClass())) {
                AMBIENT_MOBS.add(type.getEntityClass());
                continue;
            }
            if (Monster.class.isAssignableFrom(type.getEntityClass())) {
                HOSTILE_MOBS.add(type.getEntityClass());
                continue;
            }
            if (!WaterMob.class.isAssignableFrom(type.getEntityClass())) continue;
            WATER_MOBS.add(type.getEntityClass());
        }
        boolean hasPreSpawnEvent = false;
        SetMultimap preSpawnHandled = null;
        try {
            Class.forName("com.destroystokyo.paper.event.entity.PreCreatureSpawnEvent");
            hasPreSpawnEvent = true;
            preSpawnHandled = MultimapBuilder.enumKeys(CreatureSpawnEvent.SpawnReason.class).enumSetValues(EntityType.class).build();
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        IS_PAPER = hasPreSpawnEvent;
        PRE_SPAWN_HANDLED = preSpawnHandled;
    }

    class ReasonSettings
    extends SpawningSettings {
        private Map<EntityType, SpawningSettings> spawningSettings;

        public ReasonSettings(ConfigurationSection section) {
            super(section);
            this.spawningSettings = new EnumMap<EntityType, SpawningSettings>(EntityType.class);
            for (String key : section.getKeys(false)) {
                if (!section.isConfigurationSection(key) || key.equals("count") || key.equals("radius") || key.equals("dumb")) continue;
                try {
                    this.spawningSettings.put(EntityType.valueOf((String)key.toUpperCase()), new SpawningSettings(section.getConfigurationSection(key)));
                }
                catch (IllegalArgumentException e) {
                    MobLimit.this.getLogger().log(Level.WARNING, key + " is not a valid entity type in " + section.getCurrentPath());
                }
            }
        }

        public Map<EntityType, SpawningSettings> getSpawningSettings() {
            return this.spawningSettings;
        }
    }
}

