/*
 * Decompiled with CFR 0.152.
 */
package de.minebench.channelslogger;

import com.google.inject.Inject;
import com.velocitypowered.api.event.Subscribe;
import com.velocitypowered.api.event.proxy.ProxyInitializeEvent;
import com.velocitypowered.api.plugin.annotation.DataDirectory;
import com.velocitypowered.api.proxy.ProxyServer;
import de.minebench.channelslogger.FileConfiguration;
import java.io.IOException;
import java.nio.file.Path;
import net.zaiyers.Channels.events.ChannelsChatEvent;
import net.zaiyers.Channels.message.ChannelMessage;
import net.zaiyers.Channels.message.ConsoleMessage;
import net.zaiyers.Channels.message.PrivateMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.event.Level;

public class ChannelsLogger {
    private final ProxyServer proxy;
    private final Logger logger;
    private FileConfiguration config;
    private final Logger chatLogger = LoggerFactory.getLogger((String)"ChannelsLogger.ChatLogger");
    private boolean enabled = false;
    private boolean logPrivate = false;
    private boolean logPrefixes = false;

    @Inject
    public ChannelsLogger(ProxyServer proxy, Logger logger, @DataDirectory Path dataFolder) {
        this.proxy = proxy;
        this.logger = logger;
        this.config = new FileConfiguration(this, dataFolder.resolve("config.yml"));
    }

    @Subscribe
    public void onProxyInitialization(ProxyInitializeEvent event) {
        try {
            this.config.createDefaultConfig();
        }
        catch (IOException e) {
            this.log(Level.ERROR, "Failed to create default config", e);
        }
        this.config.load();
        this.enabled = true;
        this.logPrivate = this.config.getBoolean("logPrivate");
        this.logPrefixes = this.config.getBoolean("logPrefixes");
        this.proxy.getEventManager().register((Object)this, (Object)this);
    }

    @Subscribe
    public void onChannelsMessage(ChannelsChatEvent event) {
        if (!this.enabled) {
            return;
        }
        if (event.getMessage() instanceof ChannelMessage) {
            ChannelMessage cm = (ChannelMessage)event.getMessage();
            this.chatLogger.info("[" + cm.getChannel().getTag() + "] " + (this.logPrefixes ? cm.getChatter().getPrefix() : "") + cm.getChatter().getName() + ": " + cm.getRawMessage());
        } else if (event.getMessage() instanceof PrivateMessage) {
            if (this.logPrivate) {
                PrivateMessage pm = (PrivateMessage)event.getMessage();
                this.chatLogger.info(pm.getChatter().getName() + " -> " + pm.getReceiver().getName() + ": " + pm.getRawMessage());
            }
        } else if (event.getMessage() instanceof ConsoleMessage) {
            ConsoleMessage cm = (ConsoleMessage)event.getMessage();
            this.chatLogger.info("[" + cm.getChannel().getTag() + "] " + String.valueOf(cm.getSender()) + ": " + cm.getRawMessage());
        }
    }

    public void log(Level level, String message) {
        this.logger.atLevel(level).log(message);
    }

    public void log(Level level, String message, Throwable throwable) {
        this.logger.atLevel(level).setCause(throwable).log(message);
    }
}

