/*
 * Decompiled with CFR 0.152.
 */
package com.velocitypowered.api.plugin.ap;

import com.google.auto.service.AutoService;
import com.google.gson.Gson;
import com.velocitypowered.api.plugin.Dependency;
import com.velocitypowered.api.plugin.Plugin;
import com.velocitypowered.api.plugin.ap.SerializedPluginDescription;
import java.io.BufferedWriter;
import java.io.IOException;
import java.util.Objects;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.Processor;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.Name;
import javax.lang.model.element.TypeElement;
import javax.tools.Diagnostic;
import javax.tools.FileObject;
import javax.tools.StandardLocation;

@SupportedAnnotationTypes(value={"com.velocitypowered.api.plugin.Plugin"})
@AutoService(value={Processor.class})
public class PluginAnnotationProcessor
extends AbstractProcessor {
    private ProcessingEnvironment environment;
    private String pluginClassFound;
    private boolean warnedAboutMultiplePlugins;

    @Override
    public synchronized void init(ProcessingEnvironment processingEnv) {
        this.environment = processingEnv;
    }

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latestSupported();
    }

    @Override
    public synchronized boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        if (roundEnv.processingOver()) {
            return false;
        }
        for (Element element : roundEnv.getElementsAnnotatedWith(Plugin.class)) {
            if (element.getKind() != ElementKind.CLASS) {
                this.environment.getMessager().printMessage(Diagnostic.Kind.ERROR, "Only classes can be annotated with " + Plugin.class.getCanonicalName());
                return false;
            }
            Name qualifiedName = ((TypeElement)element).getQualifiedName();
            if (Objects.equals(this.pluginClassFound, qualifiedName.toString())) {
                if (!this.warnedAboutMultiplePlugins) {
                    this.environment.getMessager().printMessage(Diagnostic.Kind.WARNING, "Velocity does not yet currently support multiple plugins. We are using " + this.pluginClassFound + " for your plugin's main class.");
                    this.warnedAboutMultiplePlugins = true;
                }
                return false;
            }
            Plugin plugin = element.getAnnotation(Plugin.class);
            if (!SerializedPluginDescription.ID_PATTERN.matcher(plugin.id()).matches()) {
                this.environment.getMessager().printMessage(Diagnostic.Kind.ERROR, "Invalid ID for plugin " + String.valueOf(qualifiedName) + ". IDs must start alphabetically, have lowercase alphanumeric characters, and can contain dashes or underscores.");
                return false;
            }
            for (Dependency dependency : plugin.dependencies()) {
                if (SerializedPluginDescription.ID_PATTERN.matcher(dependency.id()).matches()) continue;
                this.environment.getMessager().printMessage(Diagnostic.Kind.ERROR, "Invalid dependency ID '" + dependency.id() + "' for plugin " + String.valueOf(qualifiedName) + ". IDs must start alphabetically, have lowercase alphanumeric characters, and can contain dashes or underscores.");
                return false;
            }
            SerializedPluginDescription description = SerializedPluginDescription.from(plugin, qualifiedName.toString());
            try {
                FileObject object = this.environment.getFiler().createResource(StandardLocation.CLASS_OUTPUT, "", "velocity-plugin.json", new Element[0]);
                try (BufferedWriter writer = new BufferedWriter(object.openWriter());){
                    new Gson().toJson((Object)description, (Appendable)writer);
                }
                this.pluginClassFound = qualifiedName.toString();
            }
            catch (IOException e) {
                this.environment.getMessager().printMessage(Diagnostic.Kind.ERROR, "Unable to generate plugin file");
            }
        }
        return false;
    }
}

