/*
 * Decompiled with CFR 0.152.
 */
package net.querz.nbt.tag;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import net.querz.io.MaxDepthIO;
import net.querz.nbt.tag.ByteArrayTag;
import net.querz.nbt.tag.ByteTag;
import net.querz.nbt.tag.CompoundTag;
import net.querz.nbt.tag.DoubleTag;
import net.querz.nbt.tag.EndTag;
import net.querz.nbt.tag.FloatTag;
import net.querz.nbt.tag.IntArrayTag;
import net.querz.nbt.tag.IntTag;
import net.querz.nbt.tag.LongArrayTag;
import net.querz.nbt.tag.LongTag;
import net.querz.nbt.tag.ShortTag;
import net.querz.nbt.tag.StringTag;
import net.querz.nbt.tag.Tag;

public class ListTag<T extends Tag<?>>
extends Tag<List<T>>
implements Iterable<T>,
Comparable<ListTag<T>>,
MaxDepthIO {
    public static final byte ID = 9;
    private Class<?> typeClass = null;

    private ListTag() {
        super(ListTag.createEmptyValue(3));
    }

    @Override
    public byte getID() {
        return 9;
    }

    public static ListTag<?> createUnchecked(Class<?> typeClass) {
        ListTag list = new ListTag();
        list.typeClass = typeClass;
        return list;
    }

    private static <T> List<T> createEmptyValue(int initialCapacity) {
        return new ArrayList(initialCapacity);
    }

    public ListTag(Class<? super T> typeClass) throws IllegalArgumentException, NullPointerException {
        super(ListTag.createEmptyValue(3));
        if (typeClass == EndTag.class) {
            throw new IllegalArgumentException("cannot create ListTag with EndTag elements");
        }
        this.typeClass = Objects.requireNonNull(typeClass);
    }

    public Class<?> getTypeClass() {
        return this.typeClass == null ? EndTag.class : this.typeClass;
    }

    public int size() {
        return ((List)this.getValue()).size();
    }

    public T remove(int index) {
        return (T)((Tag)((List)this.getValue()).remove(index));
    }

    public void clear() {
        ((List)this.getValue()).clear();
    }

    public boolean contains(T t) {
        return ((List)this.getValue()).contains(t);
    }

    public boolean containsAll(Collection<Tag<?>> tags) {
        return ((List)this.getValue()).containsAll(tags);
    }

    public void sort(Comparator<T> comparator) {
        ((List)this.getValue()).sort(comparator);
    }

    @Override
    public Iterator<T> iterator() {
        return ((List)this.getValue()).iterator();
    }

    @Override
    public void forEach(Consumer<? super T> action) {
        ((List)this.getValue()).forEach(action);
    }

    public T set(int index, T t) {
        return (T)((Tag)((List)this.getValue()).set(index, Objects.requireNonNull(t)));
    }

    public void add(T t) {
        this.add(this.size(), t);
    }

    public void add(int index, T t) {
        Objects.requireNonNull(t);
        if (this.typeClass == null || this.typeClass == EndTag.class) {
            this.typeClass = t.getClass();
        } else if (this.typeClass != t.getClass()) {
            throw new ClassCastException(String.format("cannot add %s to ListTag<%s>", t.getClass().getSimpleName(), this.typeClass.getSimpleName()));
        }
        ((List)this.getValue()).add(index, t);
    }

    public void addAll(Collection<T> t) {
        for (Tag tt : t) {
            this.add(tt);
        }
    }

    public void addAll(int index, Collection<T> t) {
        int i = 0;
        for (Tag tt : t) {
            this.add(index + i, tt);
            ++i;
        }
    }

    public void addBoolean(boolean value) {
        this.addUnchecked(new ByteTag(value));
    }

    public void addByte(byte value) {
        this.addUnchecked(new ByteTag(value));
    }

    public void addShort(short value) {
        this.addUnchecked(new ShortTag(value));
    }

    public void addInt(int value) {
        this.addUnchecked(new IntTag(value));
    }

    public void addLong(long value) {
        this.addUnchecked(new LongTag(value));
    }

    public void addFloat(float value) {
        this.addUnchecked(new FloatTag(value));
    }

    public void addDouble(double value) {
        this.addUnchecked(new DoubleTag(value));
    }

    public void addString(String value) {
        this.addUnchecked(new StringTag(value));
    }

    public void addByteArray(byte[] value) {
        this.addUnchecked(new ByteArrayTag(value));
    }

    public void addIntArray(int[] value) {
        this.addUnchecked(new IntArrayTag(value));
    }

    public void addLongArray(long[] value) {
        this.addUnchecked(new LongArrayTag(value));
    }

    public T get(int index) {
        return (T)((Tag)((List)this.getValue()).get(index));
    }

    public int indexOf(T t) {
        return ((List)this.getValue()).indexOf(t);
    }

    public <L extends Tag<?>> ListTag<L> asTypedList(Class<L> type) {
        this.checkTypeClass(type);
        this.typeClass = type;
        return this;
    }

    public ListTag<ByteTag> asByteTagList() {
        return this.asTypedList(ByteTag.class);
    }

    public ListTag<ShortTag> asShortTagList() {
        return this.asTypedList(ShortTag.class);
    }

    public ListTag<IntTag> asIntTagList() {
        return this.asTypedList(IntTag.class);
    }

    public ListTag<LongTag> asLongTagList() {
        return this.asTypedList(LongTag.class);
    }

    public ListTag<FloatTag> asFloatTagList() {
        return this.asTypedList(FloatTag.class);
    }

    public ListTag<DoubleTag> asDoubleTagList() {
        return this.asTypedList(DoubleTag.class);
    }

    public ListTag<StringTag> asStringTagList() {
        return this.asTypedList(StringTag.class);
    }

    public ListTag<ByteArrayTag> asByteArrayTagList() {
        return this.asTypedList(ByteArrayTag.class);
    }

    public ListTag<IntArrayTag> asIntArrayTagList() {
        return this.asTypedList(IntArrayTag.class);
    }

    public ListTag<LongArrayTag> asLongArrayTagList() {
        return this.asTypedList(LongArrayTag.class);
    }

    public ListTag<ListTag<?>> asListTagList() {
        this.checkTypeClass(ListTag.class);
        this.typeClass = ListTag.class;
        return this;
    }

    public ListTag<CompoundTag> asCompoundTagList() {
        return this.asTypedList(CompoundTag.class);
    }

    @Override
    public String valueToString(int maxDepth) {
        StringBuilder sb = new StringBuilder("{\"type\":\"").append(this.getTypeClass().getSimpleName()).append("\",\"list\":[");
        for (int i = 0; i < this.size(); ++i) {
            sb.append(i > 0 ? "," : "").append(((Tag)this.get(i)).valueToString(this.decrementMaxDepth(maxDepth)));
        }
        sb.append("]}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!super.equals(other) || this.size() != ((ListTag)other).size() || this.getTypeClass() != ((ListTag)other).getTypeClass()) {
            return false;
        }
        for (int i = 0; i < this.size(); ++i) {
            if (((Tag)this.get(i)).equals(((ListTag)other).get(i))) continue;
            return false;
        }
        return true;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.getTypeClass().hashCode(), ((List)this.getValue()).hashCode());
    }

    @Override
    public int compareTo(ListTag<T> o) {
        return Integer.compare(this.size(), ((List)o.getValue()).size());
    }

    @Override
    public ListTag<T> clone() {
        ListTag<Object> copy = new ListTag<Object>();
        copy.typeClass = this.typeClass;
        for (Tag t : (List)this.getValue()) {
            copy.add(t.clone());
        }
        return copy;
    }

    public void addUnchecked(Tag<?> tag) {
        if (this.typeClass != null && this.typeClass != tag.getClass() && this.typeClass != EndTag.class) {
            throw new IllegalArgumentException(String.format("cannot add %s to ListTag<%s>", tag.getClass().getSimpleName(), this.typeClass.getSimpleName()));
        }
        this.add(this.size(), tag);
    }

    private void checkTypeClass(Class<?> clazz) {
        if (this.typeClass != null && this.typeClass != EndTag.class && this.typeClass != clazz) {
            throw new ClassCastException(String.format("cannot cast ListTag<%s> to ListTag<%s>", this.typeClass.getSimpleName(), clazz.getSimpleName()));
        }
    }
}

