/*
 * Decompiled with CFR 0.152.
 */
package net.querz.nbt.io;

import java.util.ArrayList;
import java.util.regex.Pattern;
import net.querz.io.MaxDepthIO;
import net.querz.nbt.io.ParseException;
import net.querz.nbt.io.StringPointer;
import net.querz.nbt.tag.ArrayTag;
import net.querz.nbt.tag.ByteArrayTag;
import net.querz.nbt.tag.ByteTag;
import net.querz.nbt.tag.CompoundTag;
import net.querz.nbt.tag.DoubleTag;
import net.querz.nbt.tag.EndTag;
import net.querz.nbt.tag.FloatTag;
import net.querz.nbt.tag.IntArrayTag;
import net.querz.nbt.tag.IntTag;
import net.querz.nbt.tag.ListTag;
import net.querz.nbt.tag.LongArrayTag;
import net.querz.nbt.tag.LongTag;
import net.querz.nbt.tag.ShortTag;
import net.querz.nbt.tag.StringTag;
import net.querz.nbt.tag.Tag;

public final class SNBTParser
implements MaxDepthIO {
    private static final Pattern FLOAT_LITERAL_PATTERN = Pattern.compile("^[-+]?(?:\\d+\\.?|\\d*\\.\\d+)(?:e[-+]?\\d+)?f$", 2);
    private static final Pattern DOUBLE_LITERAL_PATTERN = Pattern.compile("^[-+]?(?:\\d+\\.?|\\d*\\.\\d+)(?:e[-+]?\\d+)?d$", 2);
    private static final Pattern DOUBLE_LITERAL_NO_SUFFIX_PATTERN = Pattern.compile("^[-+]?(?:\\d+\\.|\\d*\\.\\d+)(?:e[-+]?\\d+)?$", 2);
    private static final Pattern BYTE_LITERAL_PATTERN = Pattern.compile("^[-+]?\\d+b$", 2);
    private static final Pattern SHORT_LITERAL_PATTERN = Pattern.compile("^[-+]?\\d+s$", 2);
    private static final Pattern INT_LITERAL_PATTERN = Pattern.compile("^[-+]?\\d+$", 2);
    private static final Pattern LONG_LITERAL_PATTERN = Pattern.compile("^[-+]?\\d+l$", 2);
    private static final Pattern NUMBER_PATTERN = Pattern.compile("^[-+]?\\d+$");
    private StringPointer ptr;

    private SNBTParser(String string) {
        this.ptr = new StringPointer(string);
    }

    public static Tag<?> parse(String string, int maxDepth) throws ParseException {
        SNBTParser parser = new SNBTParser(string);
        Tag<?> tag = parser.parseAnything(maxDepth);
        parser.ptr.skipWhitespace();
        if (parser.ptr.hasNext()) {
            throw parser.ptr.parseException("invalid characters after end of snbt");
        }
        return tag;
    }

    public static Tag<?> parse(String string) throws ParseException {
        return SNBTParser.parse(string, 512);
    }

    private Tag<?> parseAnything(int maxDepth) throws ParseException {
        this.ptr.skipWhitespace();
        switch (this.ptr.currentChar()) {
            case '{': {
                return this.parseCompoundTag(maxDepth);
            }
            case '[': {
                if (this.ptr.hasCharsLeft(2) && this.ptr.lookAhead(1) != '\"' && this.ptr.lookAhead(2) == ';') {
                    return this.parseNumArray();
                }
                return this.parseListTag(maxDepth);
            }
        }
        return this.parseStringOrLiteral();
    }

    private Tag<?> parseStringOrLiteral() throws ParseException {
        this.ptr.skipWhitespace();
        if (this.ptr.currentChar() == '\"') {
            return new StringTag(this.ptr.parseQuotedString());
        }
        String s = this.ptr.parseSimpleString();
        if (s.isEmpty()) {
            throw new ParseException("expected non empty value");
        }
        if (FLOAT_LITERAL_PATTERN.matcher(s).matches()) {
            return new FloatTag(Float.parseFloat(s.substring(0, s.length() - 1)));
        }
        if (BYTE_LITERAL_PATTERN.matcher(s).matches()) {
            try {
                return new ByteTag(Byte.parseByte(s.substring(0, s.length() - 1)));
            }
            catch (NumberFormatException ex) {
                throw this.ptr.parseException("byte not in range: \"" + s.substring(0, s.length() - 1) + "\"");
            }
        }
        if (SHORT_LITERAL_PATTERN.matcher(s).matches()) {
            try {
                return new ShortTag(Short.parseShort(s.substring(0, s.length() - 1)));
            }
            catch (NumberFormatException ex) {
                throw this.ptr.parseException("short not in range: \"" + s.substring(0, s.length() - 1) + "\"");
            }
        }
        if (LONG_LITERAL_PATTERN.matcher(s).matches()) {
            try {
                return new LongTag(Long.parseLong(s.substring(0, s.length() - 1)));
            }
            catch (NumberFormatException ex) {
                throw this.ptr.parseException("long not in range: \"" + s.substring(0, s.length() - 1) + "\"");
            }
        }
        if (INT_LITERAL_PATTERN.matcher(s).matches()) {
            try {
                return new IntTag(Integer.parseInt(s));
            }
            catch (NumberFormatException ex) {
                throw this.ptr.parseException("int not in range: \"" + s.substring(0, s.length() - 1) + "\"");
            }
        }
        if (DOUBLE_LITERAL_PATTERN.matcher(s).matches()) {
            return new DoubleTag(Double.parseDouble(s.substring(0, s.length() - 1)));
        }
        if (DOUBLE_LITERAL_NO_SUFFIX_PATTERN.matcher(s).matches()) {
            return new DoubleTag(Double.parseDouble(s));
        }
        if ("true".equalsIgnoreCase(s)) {
            return new ByteTag(true);
        }
        if ("false".equalsIgnoreCase(s)) {
            return new ByteTag(false);
        }
        return new StringTag(s);
    }

    private CompoundTag parseCompoundTag(int maxDepth) throws ParseException {
        this.ptr.expectChar('{');
        CompoundTag compoundTag = new CompoundTag();
        this.ptr.skipWhitespace();
        while (this.ptr.hasNext() && this.ptr.currentChar() != '}') {
            String key;
            this.ptr.skipWhitespace();
            String string = key = this.ptr.currentChar() == '\"' ? this.ptr.parseQuotedString() : this.ptr.parseSimpleString();
            if (key.isEmpty()) {
                throw new ParseException("empty keys are not allowed");
            }
            this.ptr.expectChar(':');
            compoundTag.put(key, this.parseAnything(this.decrementMaxDepth(maxDepth)));
            if (this.ptr.nextArrayElement()) continue;
            break;
        }
        this.ptr.expectChar('}');
        return compoundTag;
    }

    private ListTag<?> parseListTag(int maxDepth) throws ParseException {
        this.ptr.expectChar('[');
        this.ptr.skipWhitespace();
        ListTag<EndTag> list = ListTag.createUnchecked(EndTag.class);
        while (this.ptr.currentChar() != ']') {
            Tag<?> element = this.parseAnything(this.decrementMaxDepth(maxDepth));
            try {
                list.addUnchecked(element);
            }
            catch (IllegalArgumentException ex) {
                throw this.ptr.parseException(ex.getMessage());
            }
            if (this.ptr.nextArrayElement()) continue;
            break;
        }
        this.ptr.expectChar(']');
        return list;
    }

    private ArrayTag<?> parseNumArray() throws ParseException {
        this.ptr.expectChar('[');
        char arrayType = this.ptr.next();
        this.ptr.expectChar(';');
        this.ptr.skipWhitespace();
        switch (arrayType) {
            case 'B': {
                return this.parseByteArrayTag();
            }
            case 'I': {
                return this.parseIntArrayTag();
            }
            case 'L': {
                return this.parseLongArrayTag();
            }
        }
        throw new ParseException("invalid array type '" + arrayType + "'");
    }

    private ByteArrayTag parseByteArrayTag() throws ParseException {
        ArrayList<Byte> byteList = new ArrayList<Byte>();
        while (this.ptr.currentChar() != ']') {
            String s = this.ptr.parseSimpleString();
            this.ptr.skipWhitespace();
            if (NUMBER_PATTERN.matcher(s).matches()) {
                try {
                    byteList.add(Byte.parseByte(s));
                }
                catch (NumberFormatException ex) {
                    throw this.ptr.parseException("byte not in range: \"" + s + "\"");
                }
            } else {
                throw this.ptr.parseException("invalid byte in ByteArrayTag: \"" + s + "\"");
            }
            if (this.ptr.nextArrayElement()) continue;
            break;
        }
        this.ptr.expectChar(']');
        byte[] bytes = new byte[byteList.size()];
        for (int i = 0; i < byteList.size(); ++i) {
            bytes[i] = (Byte)byteList.get(i);
        }
        return new ByteArrayTag(bytes);
    }

    private IntArrayTag parseIntArrayTag() throws ParseException {
        ArrayList<Integer> intList = new ArrayList<Integer>();
        while (this.ptr.currentChar() != ']') {
            String s = this.ptr.parseSimpleString();
            this.ptr.skipWhitespace();
            if (NUMBER_PATTERN.matcher(s).matches()) {
                try {
                    intList.add(Integer.parseInt(s));
                }
                catch (NumberFormatException ex) {
                    throw this.ptr.parseException("int not in range: \"" + s + "\"");
                }
            } else {
                throw this.ptr.parseException("invalid int in IntArrayTag: \"" + s + "\"");
            }
            if (this.ptr.nextArrayElement()) continue;
            break;
        }
        this.ptr.expectChar(']');
        return new IntArrayTag(intList.stream().mapToInt(i -> i).toArray());
    }

    private LongArrayTag parseLongArrayTag() throws ParseException {
        ArrayList<Long> longList = new ArrayList<Long>();
        while (this.ptr.currentChar() != ']') {
            String s = this.ptr.parseSimpleString();
            this.ptr.skipWhitespace();
            if (NUMBER_PATTERN.matcher(s).matches()) {
                try {
                    longList.add(Long.parseLong(s));
                }
                catch (NumberFormatException ex) {
                    throw this.ptr.parseException("long not in range: \"" + s + "\"");
                }
            } else {
                throw this.ptr.parseException("invalid long in LongArrayTag: \"" + s + "\"");
            }
            if (this.ptr.nextArrayElement()) continue;
            break;
        }
        this.ptr.expectChar(']');
        return new LongArrayTag(longList.stream().mapToLong(l -> l).toArray());
    }
}

