/*
 * Decompiled with CFR 0.152.
 */
package net.querz.nbt.io;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PushbackInputStream;
import java.util.zip.GZIPInputStream;
import net.querz.nbt.io.NBTDeserializer;
import net.querz.nbt.io.NBTSerializer;
import net.querz.nbt.io.NamedTag;
import net.querz.nbt.tag.Tag;

public final class NBTUtil {
    private NBTUtil() {
    }

    public static void write(NamedTag tag, File file, boolean compressed) throws IOException {
        try (FileOutputStream fos = new FileOutputStream(file);){
            new NBTSerializer(compressed).toStream(tag, (OutputStream)fos);
        }
    }

    public static void write(NamedTag tag, String file, boolean compressed) throws IOException {
        NBTUtil.write(tag, new File(file), compressed);
    }

    public static void write(NamedTag tag, File file) throws IOException {
        NBTUtil.write(tag, file, true);
    }

    public static void write(NamedTag tag, String file) throws IOException {
        NBTUtil.write(tag, new File(file), true);
    }

    public static void write(Tag<?> tag, File file, boolean compressed) throws IOException {
        NBTUtil.write(new NamedTag(null, tag), file, compressed);
    }

    public static void write(Tag<?> tag, String file, boolean compressed) throws IOException {
        NBTUtil.write(new NamedTag(null, tag), new File(file), compressed);
    }

    public static void write(Tag<?> tag, File file) throws IOException {
        NBTUtil.write(new NamedTag(null, tag), file, true);
    }

    public static void write(Tag<?> tag, String file) throws IOException {
        NBTUtil.write(new NamedTag(null, tag), new File(file), true);
    }

    public static NamedTag read(File file, boolean compressed) throws IOException {
        try (FileInputStream fis = new FileInputStream(file);){
            NamedTag namedTag = new NBTDeserializer(compressed).fromStream(fis);
            return namedTag;
        }
    }

    public static NamedTag read(String file, boolean compressed) throws IOException {
        return NBTUtil.read(new File(file), compressed);
    }

    public static NamedTag read(File file) throws IOException {
        try (FileInputStream fis = new FileInputStream(file);){
            NamedTag namedTag = new NBTDeserializer(false).fromStream(NBTUtil.detectDecompression(fis));
            return namedTag;
        }
    }

    public static NamedTag read(String file) throws IOException {
        return NBTUtil.read(new File(file));
    }

    private static InputStream detectDecompression(InputStream is) throws IOException {
        PushbackInputStream pbis = new PushbackInputStream(is, 2);
        int signature = (pbis.read() & 0xFF) + (pbis.read() << 8);
        pbis.unread(signature >> 8);
        pbis.unread(signature & 0xFF);
        if (signature == 35615) {
            return new GZIPInputStream(pbis);
        }
        return pbis;
    }
}

