/*
 * Decompiled with CFR 0.152.
 */
package net.querz.nbt.io;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import net.querz.io.ExceptionTriConsumer;
import net.querz.io.MaxDepthIO;
import net.querz.nbt.io.NamedTag;
import net.querz.nbt.tag.ByteArrayTag;
import net.querz.nbt.tag.ByteTag;
import net.querz.nbt.tag.CompoundTag;
import net.querz.nbt.tag.DoubleTag;
import net.querz.nbt.tag.EndTag;
import net.querz.nbt.tag.FloatTag;
import net.querz.nbt.tag.IntArrayTag;
import net.querz.nbt.tag.IntTag;
import net.querz.nbt.tag.ListTag;
import net.querz.nbt.tag.LongArrayTag;
import net.querz.nbt.tag.LongTag;
import net.querz.nbt.tag.ShortTag;
import net.querz.nbt.tag.StringTag;
import net.querz.nbt.tag.Tag;

public class NBTOutputStream
extends DataOutputStream
implements MaxDepthIO {
    private static Map<Byte, ExceptionTriConsumer<NBTOutputStream, Tag<?>, Integer, IOException>> writers = new HashMap();
    private static Map<Class<?>, Byte> classIdMapping = new HashMap();

    private static void put(byte id, ExceptionTriConsumer<NBTOutputStream, Tag<?>, Integer, IOException> f, Class<?> clazz) {
        writers.put(id, f);
        classIdMapping.put(clazz, id);
    }

    public NBTOutputStream(OutputStream out) {
        super(out);
    }

    public void writeTag(NamedTag tag, int maxDepth) throws IOException {
        this.writeByte(tag.getTag().getID());
        if (tag.getTag().getID() != 0) {
            this.writeUTF(tag.getName() == null ? "" : tag.getName());
        }
        this.writeRawTag(tag.getTag(), maxDepth);
    }

    public void writeTag(Tag<?> tag, int maxDepth) throws IOException {
        this.writeByte(tag.getID());
        if (tag.getID() != 0) {
            this.writeUTF("");
        }
        this.writeRawTag(tag, maxDepth);
    }

    public void writeRawTag(Tag<?> tag, int maxDepth) throws IOException {
        ExceptionTriConsumer<NBTOutputStream, Tag<?>, Integer, IOException> f = writers.get(tag.getID());
        if (f == null) {
            throw new IOException("invalid tag \"" + tag.getID() + "\"");
        }
        f.accept(this, tag, maxDepth);
    }

    static byte idFromClass(Class<?> clazz) {
        Byte id = classIdMapping.get(clazz);
        if (id == null) {
            throw new IllegalArgumentException("unknown Tag class " + clazz.getName());
        }
        return id;
    }

    private static void writeByte(NBTOutputStream out, Tag<?> tag) throws IOException {
        out.writeByte(((ByteTag)tag).asByte());
    }

    private static void writeShort(NBTOutputStream out, Tag<?> tag) throws IOException {
        out.writeShort(((ShortTag)tag).asShort());
    }

    private static void writeInt(NBTOutputStream out, Tag<?> tag) throws IOException {
        out.writeInt(((IntTag)tag).asInt());
    }

    private static void writeLong(NBTOutputStream out, Tag<?> tag) throws IOException {
        out.writeLong(((LongTag)tag).asLong());
    }

    private static void writeFloat(NBTOutputStream out, Tag<?> tag) throws IOException {
        out.writeFloat(((FloatTag)tag).asFloat());
    }

    private static void writeDouble(NBTOutputStream out, Tag<?> tag) throws IOException {
        out.writeDouble(((DoubleTag)tag).asDouble());
    }

    private static void writeString(NBTOutputStream out, Tag<?> tag) throws IOException {
        out.writeUTF(((StringTag)tag).getValue());
    }

    private static void writeByteArray(NBTOutputStream out, Tag<?> tag) throws IOException {
        out.writeInt(((ByteArrayTag)tag).length());
        out.write((byte[])((ByteArrayTag)tag).getValue());
    }

    private static void writeIntArray(NBTOutputStream out, Tag<?> tag) throws IOException {
        out.writeInt(((IntArrayTag)tag).length());
        for (int i : (int[])((IntArrayTag)tag).getValue()) {
            out.writeInt(i);
        }
    }

    private static void writeLongArray(NBTOutputStream out, Tag<?> tag) throws IOException {
        out.writeInt(((LongArrayTag)tag).length());
        for (long l : (long[])((LongArrayTag)tag).getValue()) {
            out.writeLong(l);
        }
    }

    private static void writeList(NBTOutputStream out, Tag<?> tag, int maxDepth) throws IOException {
        out.writeByte(NBTOutputStream.idFromClass(((ListTag)tag).getTypeClass()));
        out.writeInt(((ListTag)tag).size());
        for (Tag t : (ListTag)tag) {
            out.writeRawTag(t, out.decrementMaxDepth(maxDepth));
        }
    }

    private static void writeCompound(NBTOutputStream out, Tag<?> tag, int maxDepth) throws IOException {
        for (Map.Entry<String, Tag<?>> entry : (CompoundTag)tag) {
            if (entry.getValue().getID() == 0) {
                throw new IOException("end tag not allowed");
            }
            out.writeByte(entry.getValue().getID());
            out.writeUTF(entry.getKey());
            out.writeRawTag(entry.getValue(), out.decrementMaxDepth(maxDepth));
        }
        out.writeByte(0);
    }

    static {
        NBTOutputStream.put((byte)0, (o, t, d) -> {}, EndTag.class);
        NBTOutputStream.put((byte)1, (o, t, d) -> NBTOutputStream.writeByte(o, t), ByteTag.class);
        NBTOutputStream.put((byte)2, (o, t, d) -> NBTOutputStream.writeShort(o, t), ShortTag.class);
        NBTOutputStream.put((byte)3, (o, t, d) -> NBTOutputStream.writeInt(o, t), IntTag.class);
        NBTOutputStream.put((byte)4, (o, t, d) -> NBTOutputStream.writeLong(o, t), LongTag.class);
        NBTOutputStream.put((byte)5, (o, t, d) -> NBTOutputStream.writeFloat(o, t), FloatTag.class);
        NBTOutputStream.put((byte)6, (o, t, d) -> NBTOutputStream.writeDouble(o, t), DoubleTag.class);
        NBTOutputStream.put((byte)7, (o, t, d) -> NBTOutputStream.writeByteArray(o, t), ByteArrayTag.class);
        NBTOutputStream.put((byte)8, (o, t, d) -> NBTOutputStream.writeString(o, t), StringTag.class);
        NBTOutputStream.put((byte)9, NBTOutputStream::writeList, ListTag.class);
        NBTOutputStream.put((byte)10, NBTOutputStream::writeCompound, CompoundTag.class);
        NBTOutputStream.put((byte)11, (o, t, d) -> NBTOutputStream.writeIntArray(o, t), IntArrayTag.class);
        NBTOutputStream.put((byte)12, (o, t, d) -> NBTOutputStream.writeLongArray(o, t), LongArrayTag.class);
    }
}

