/*
 * Decompiled with CFR 0.152.
 */
package com.comphenix.protocol.wrappers.nbt.io;

import com.comphenix.protocol.reflect.FieldAccessException;
import com.comphenix.protocol.reflect.FuzzyReflection;
import com.comphenix.protocol.reflect.accessors.Accessors;
import com.comphenix.protocol.reflect.accessors.MethodAccessor;
import com.comphenix.protocol.reflect.fuzzy.FuzzyMethodContract;
import com.comphenix.protocol.utility.MinecraftReflection;
import com.comphenix.protocol.utility.MinecraftVersion;
import com.comphenix.protocol.wrappers.nbt.NbtBase;
import com.comphenix.protocol.wrappers.nbt.NbtCompound;
import com.comphenix.protocol.wrappers.nbt.NbtFactory;
import com.comphenix.protocol.wrappers.nbt.NbtList;
import com.comphenix.protocol.wrappers.nbt.NbtWrapper;
import java.io.DataInput;
import java.io.DataOutput;
import java.lang.reflect.Method;

public class NbtBinarySerializer {
    public static final NbtBinarySerializer DEFAULT = new NbtBinarySerializer();
    private static final Class<?> NBT_BASE_CLASS = MinecraftReflection.getNBTBaseClass();
    private static CodecMethod codecMethod;

    private static MethodAccessor getNbtLoadMethod(Class<?> ... parameters) {
        Method method = NbtBinarySerializer.getUtilityClass().getMethodByReturnTypeAndParameters("load", NBT_BASE_CLASS, parameters);
        return Accessors.getMethodAccessor(method);
    }

    private static FuzzyReflection getUtilityClass() {
        return FuzzyReflection.fromClass(MinecraftReflection.getNbtCompressedStreamToolsClass(), true);
    }

    private static CodecMethod getCodecMethod() {
        if (codecMethod == null) {
            codecMethod = MinecraftVersion.CONFIG_PHASE_PROTOCOL_UPDATE.atOrAbove() ? new LoadMethodConfigPhaseUpdate() : new LoadMethodSkinUpdate();
        }
        return codecMethod;
    }

    public <T> void serialize(NbtBase<T> value, DataOutput destination) {
        NbtBinarySerializer.getCodecMethod().writeNbt(NbtFactory.fromBase(value).getHandle(), destination);
    }

    public <TType> NbtWrapper<TType> deserialize(DataInput source) {
        try {
            return NbtFactory.fromNMS(NbtBinarySerializer.getCodecMethod().loadNbt(source), null);
        }
        catch (Exception e) {
            throw new FieldAccessException("Unable to read NBT from " + source, e);
        }
    }

    public NbtCompound deserializeCompound(DataInput source) {
        return (NbtCompound)((Object)this.deserialize(source));
    }

    public <T> NbtList<T> deserializeList(DataInput source) {
        return (NbtList)((Object)this.deserialize(source));
    }

    static /* synthetic */ MethodAccessor access$100(Class[] x0) {
        return NbtBinarySerializer.getNbtLoadMethod(x0);
    }

    private static interface CodecMethod {
        public Object loadNbt(DataInput var1);

        public void writeNbt(Object var1, DataOutput var2);
    }

    private static class LoadMethodConfigPhaseUpdate
    implements CodecMethod {
        private final Class<?> readLimitClass = MinecraftReflection.getNBTReadLimiterClass();
        private final Object readLimiter = FuzzyReflection.fromClass(this.readLimitClass).getSingleton();
        private final MethodAccessor readNbt;
        private final MethodAccessor writeNbt;

        public LoadMethodConfigPhaseUpdate() {
            String readNbtMethodName = MinecraftReflection.isMojangMapped() ? "readAnyTag" : "b";
            String writeNbtMethodName = MinecraftReflection.isMojangMapped() ? "writeAnyTag" : "a";
            Method readNbtMethod = NbtBinarySerializer.getUtilityClass().getMethod(FuzzyMethodContract.newBuilder().nameExact(readNbtMethodName).returnTypeExact(MinecraftReflection.getNBTBaseClass()).parameterExactArray(DataInput.class, this.readLimitClass).build());
            this.readNbt = Accessors.getMethodAccessor(readNbtMethod);
            Method writeNbtMethod = NbtBinarySerializer.getUtilityClass().getMethod(FuzzyMethodContract.newBuilder().nameExact(writeNbtMethodName).parameterExactArray(MinecraftReflection.getNBTBaseClass(), DataOutput.class).build());
            this.writeNbt = Accessors.getMethodAccessor(writeNbtMethod);
        }

        @Override
        public Object loadNbt(DataInput input) {
            return this.readNbt.invoke(null, input, this.readLimiter);
        }

        @Override
        public void writeNbt(Object nbt, DataOutput target) {
            this.writeNbt.invoke(null, nbt, target);
        }
    }

    private static class LoadMethodSkinUpdate
    implements CodecMethod {
        private final Class<?> readLimitClass = MinecraftReflection.getNBTReadLimiterClass();
        private final Object readLimiter = FuzzyReflection.fromClass(this.readLimitClass).getSingleton();
        private final MethodAccessor readNbt = NbtBinarySerializer.access$100(new Class[]{DataInput.class, Integer.TYPE, this.readLimitClass});
        private final MethodAccessor writeNBT = Accessors.getMethodAccessor(NbtBinarySerializer.access$200().getMethodByParameters("writeNBT", MinecraftReflection.getNBTBaseClass(), DataOutput.class));

        private LoadMethodSkinUpdate() {
        }

        @Override
        public Object loadNbt(DataInput input) {
            return this.readNbt.invoke(null, input, 0, this.readLimiter);
        }

        @Override
        public void writeNbt(Object nbt, DataOutput target) {
            this.writeNBT.invoke(null, nbt, target);
        }
    }
}

