/*
 * Decompiled with CFR 0.152.
 */
package com.comphenix.protocol.wrappers;

import com.comphenix.protocol.reflect.EquivalentConverter;
import com.comphenix.protocol.reflect.FuzzyReflection;
import com.comphenix.protocol.reflect.StructureModifier;
import com.comphenix.protocol.reflect.accessors.Accessors;
import com.comphenix.protocol.reflect.accessors.ConstructorAccessor;
import com.comphenix.protocol.reflect.accessors.MethodAccessor;
import com.comphenix.protocol.reflect.fuzzy.FuzzyMethodContract;
import com.comphenix.protocol.utility.ByteBuddyFactory;
import com.comphenix.protocol.utility.ByteBuddyGenerated;
import com.comphenix.protocol.utility.MinecraftReflection;
import com.comphenix.protocol.utility.StreamSerializer;
import com.comphenix.protocol.wrappers.MinecraftKey;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Objects;
import net.bytebuddy.ByteBuddy;
import net.bytebuddy.dynamic.loading.ClassLoadingStrategy;
import net.bytebuddy.implementation.FieldAccessor;
import net.bytebuddy.implementation.Implementation;
import net.bytebuddy.implementation.MethodCall;
import net.bytebuddy.implementation.MethodDelegation;
import net.bytebuddy.implementation.bind.annotation.Argument;
import net.bytebuddy.implementation.bind.annotation.FieldValue;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;

public final class CustomPacketPayloadWrapper {
    private static final Class<?> MINECRAFT_KEY_CLASS;
    private static final Class<?> CUSTOM_PACKET_PAYLOAD_CLASS;
    private static final ConstructorAccessor PAYLOAD_WRAPPER_CONSTRUCTOR;
    private static final MethodAccessor GET_ID_PAYLOAD_METHOD;
    private static final MethodAccessor SERIALIZE_PAYLOAD_METHOD;
    private static final EquivalentConverter<CustomPacketPayloadWrapper> CONVERTER;
    private final byte[] payload;
    private final MinecraftKey id;
    private Object genericId;

    private static Constructor<?> makePayloadWrapper() throws Exception {
        return new ByteBuddy().subclass(Object.class).name("com.comphenix.protocol.wrappers.ProtocolLibCustomPacketPayload").implement(new Type[]{CUSTOM_PACKET_PAYLOAD_CLASS, ByteBuddyGenerated.class}).defineField("payload", byte[].class, 18).defineField("id", MinecraftReflection.getMinecraftKeyClass(), 18).defineConstructor(1).withParameters(new Type[]{MinecraftReflection.getMinecraftKeyClass(), byte[].class}).intercept((Implementation)MethodCall.invoke(Object.class.getConstructor(new Class[0])).andThen(FieldAccessor.ofField((String)"id").setsArgumentAt(0)).andThen(FieldAccessor.ofField((String)"payload").setsArgumentAt(1))).method((ElementMatcher)ElementMatchers.returns(MinecraftReflection.getMinecraftKeyClass()).and((ElementMatcher)ElementMatchers.takesNoArguments())).intercept((Implementation)FieldAccessor.ofField((String)"id")).method((ElementMatcher)ElementMatchers.returns(Void.TYPE).and((ElementMatcher)ElementMatchers.takesArguments((Class[])new Class[]{MinecraftReflection.getPacketDataSerializerClass()}))).intercept((Implementation)MethodDelegation.to(CustomPacketPayloadInterceptionHandler.class)).make().load(ByteBuddyFactory.getInstance().getClassLoader(), (ClassLoadingStrategy)ClassLoadingStrategy.Default.INJECTION).getLoaded().getConstructor(MinecraftReflection.getMinecraftKeyClass(), byte[].class);
    }

    public CustomPacketPayloadWrapper(byte[] payload, MinecraftKey id) {
        this.payload = Objects.requireNonNull(payload, "payload");
        this.id = Objects.requireNonNull(id, "id");
    }

    public static Class<?> getCustomPacketPayloadClass() {
        return CUSTOM_PACKET_PAYLOAD_CLASS;
    }

    public static EquivalentConverter<CustomPacketPayloadWrapper> getConverter() {
        return CONVERTER;
    }

    public static CustomPacketPayloadWrapper fromUnknownPayload(Object payload) {
        Object messageId = GET_ID_PAYLOAD_METHOD.invoke(payload, new Object[0]);
        MinecraftKey id = MinecraftKey.getConverter().getSpecific(messageId);
        StructureModifier modifier = new StructureModifier(payload.getClass()).withTarget(payload);
        byte[] messagePayload = modifier.withType(ByteBuf.class).optionRead(0).map(buffer -> {
            ByteBuf buf = (ByteBuf)buffer;
            byte[] data = StreamSerializer.getDefault().getBytesAndRelease(buf.markReaderIndex().retain());
            buf.resetReaderIndex();
            return data;
        }).orElseGet(() -> {
            ByteBuf buffer = Unpooled.buffer();
            Object serializer = MinecraftReflection.getPacketDataSerializer(buffer);
            SERIALIZE_PAYLOAD_METHOD.invoke(payload, serializer);
            return StreamSerializer.getDefault().getBytesAndRelease(buffer);
        });
        return new CustomPacketPayloadWrapper(messagePayload, id);
    }

    private Object getGenericId() {
        if (this.genericId == null) {
            this.genericId = MinecraftKey.getConverter().getGeneric(this.id);
        }
        return this.genericId;
    }

    public byte[] getPayload() {
        return this.payload;
    }

    public MinecraftKey getId() {
        return this.id;
    }

    public Object newHandle() {
        return PAYLOAD_WRAPPER_CONSTRUCTOR.invoke(this.getGenericId(), this.payload);
    }

    static {
        try {
            MINECRAFT_KEY_CLASS = MinecraftReflection.getMinecraftKeyClass();
            CUSTOM_PACKET_PAYLOAD_CLASS = MinecraftReflection.getMinecraftClass("network.protocol.common.custom.CustomPacketPayload");
            Method getPayloadId = FuzzyReflection.fromClass(CUSTOM_PACKET_PAYLOAD_CLASS).getMethod(FuzzyMethodContract.newBuilder().banModifier(8).returnTypeExact(MINECRAFT_KEY_CLASS).parameterCount(0).build());
            GET_ID_PAYLOAD_METHOD = Accessors.getMethodAccessor(getPayloadId);
            Method serializePayloadData = FuzzyReflection.fromClass(CUSTOM_PACKET_PAYLOAD_CLASS).getMethod(FuzzyMethodContract.newBuilder().banModifier(8).returnTypeVoid().parameterCount(1).parameterDerivedOf(ByteBuf.class, 0).build());
            SERIALIZE_PAYLOAD_METHOD = Accessors.getMethodAccessor(serializePayloadData);
            Constructor<?> payloadWrapperConstructor = CustomPacketPayloadWrapper.makePayloadWrapper();
            PAYLOAD_WRAPPER_CONSTRUCTOR = Accessors.getConstructorAccessor(payloadWrapperConstructor);
            CONVERTER = new EquivalentConverter<CustomPacketPayloadWrapper>(){

                @Override
                public Object getGeneric(CustomPacketPayloadWrapper specific) {
                    return specific.newHandle();
                }

                @Override
                public CustomPacketPayloadWrapper getSpecific(Object generic) {
                    return CustomPacketPayloadWrapper.fromUnknownPayload(generic);
                }

                @Override
                public Class<CustomPacketPayloadWrapper> getSpecificType() {
                    return CustomPacketPayloadWrapper.class;
                }
            };
        }
        catch (Exception exception) {
            throw new ExceptionInInitializerError(exception);
        }
    }

    static final class CustomPacketPayloadInterceptionHandler {
        CustomPacketPayloadInterceptionHandler() {
        }

        public static void intercept(@FieldValue(value="payload") byte[] payload, @Argument(value=0) Object packetBuffer) {
            ((ByteBuf)packetBuffer).writeBytes(payload);
        }
    }
}

