/*
 * Decompiled with CFR 0.152.
 */
package com.comphenix.protocol.injector.netty.manager;

import com.comphenix.protocol.ProtocolLogger;
import com.comphenix.protocol.error.ErrorReporter;
import com.comphenix.protocol.injector.ListenerManager;
import com.comphenix.protocol.injector.netty.Injector;
import com.comphenix.protocol.injector.netty.channel.InjectionFactory;
import com.comphenix.protocol.injector.netty.manager.InjectionChannelInboundHandler;
import com.comphenix.protocol.injector.netty.manager.InjectionChannelInitializer;
import com.comphenix.protocol.injector.netty.manager.ListeningList;
import com.comphenix.protocol.reflect.FuzzyReflection;
import com.comphenix.protocol.reflect.accessors.Accessors;
import com.comphenix.protocol.reflect.accessors.FieldAccessor;
import com.comphenix.protocol.reflect.fuzzy.FuzzyFieldContract;
import com.comphenix.protocol.reflect.fuzzy.FuzzyMethodContract;
import com.comphenix.protocol.utility.MinecraftReflection;
import com.comphenix.protocol.wrappers.Pair;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInboundHandler;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class NetworkManagerInjector {
    private static final String INBOUND_INJECT_HANDLER_NAME = "protocol_lib_inbound_inject";
    private final Set<Pair<Object, FieldAccessor>> overriddenLists = new HashSet<Pair<Object, FieldAccessor>>();
    private final ErrorReporter errorReporter;
    private final InjectionFactory injectionFactory;
    private final InjectionChannelInitializer pipelineInjectorHandler;
    private boolean closed = false;
    private boolean injected = false;

    public NetworkManagerInjector(Plugin plugin, ListenerManager listenerManager, ErrorReporter reporter) {
        this.errorReporter = reporter;
        this.injectionFactory = new InjectionFactory(plugin, reporter, listenerManager);
        InjectionChannelInboundHandler injectionHandler = new InjectionChannelInboundHandler(this.errorReporter, this.injectionFactory);
        this.pipelineInjectorHandler = new InjectionChannelInitializer(INBOUND_INJECT_HANDLER_NAME, (ChannelInboundHandler)injectionHandler);
    }

    public Injector getInjector(Player player) {
        return this.injectionFactory.fromPlayer(player);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void inject() {
        if (this.closed || this.injected) {
            return;
        }
        FuzzyReflection server = FuzzyReflection.fromClass(MinecraftReflection.getMinecraftServerClass());
        List<Method> serverConnectionGetter = server.getMethodList(FuzzyMethodContract.newBuilder().parameterCount(0).banModifier(8).returnTypeExact(MinecraftReflection.getServerConnectionClass()).build());
        Object serverInstance = server.getSingleton();
        Object serverConnection = null;
        for (Method method : serverConnectionGetter) {
            try {
                serverConnection = method.invoke(serverInstance, new Object[0]);
                if (serverConnection == null) continue;
                break;
            }
            catch (Exception exception) {
                ProtocolLogger.debug("Exception invoking getter for server connection " + method, exception);
            }
        }
        if (serverConnection == null) {
            throw new IllegalStateException("Unable to retrieve ServerConnection instance from MinecraftServer");
        }
        FuzzyReflection serverConnectionFuzzy = FuzzyReflection.fromObject(serverConnection, true);
        List<Field> listFields = serverConnectionFuzzy.getFieldList(FuzzyFieldContract.newBuilder().typeDerivedOf(List.class).banModifier(8).build());
        for (Field field : listFields) {
            if (!field.getGenericType().getTypeName().contains(ChannelFuture.class.getName())) continue;
            FieldAccessor accessor = Accessors.getFieldAccessor(field);
            List value = (List)accessor.get(serverConnection);
            this.overriddenLists.add(new Pair<Object, FieldAccessor>(serverConnection, accessor));
            List list = value;
            synchronized (list) {
                ListeningList newList = new ListeningList(value, (ChannelHandler)this.pipelineInjectorHandler);
                accessor.set(serverConnection, newList);
            }
        }
        this.injected = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        if (this.closed || !this.injected) {
            return;
        }
        this.closed = true;
        this.injected = false;
        for (Pair<Object, FieldAccessor> list : this.overriddenLists) {
            List<Object> original;
            Object currentFieldValue = list.getSecond().get(list.getFirst());
            if (!(currentFieldValue instanceof ListeningList)) continue;
            ListeningList ourList = (ListeningList)currentFieldValue;
            List<Object> list2 = original = ourList.getOriginal();
            synchronized (list2) {
                ourList.unProcessAll();
                list.getSecond().set(list.getFirst(), original);
            }
        }
        this.overriddenLists.clear();
        this.injectionFactory.close();
    }
}

