/*
 * Decompiled with CFR 0.152.
 */
package com.comphenix.protocol.events;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang.Validate;

class PacketMetadata {
    private static Cache<Object, List<MetaObject>> META_CACHE;

    PacketMetadata() {
    }

    public static <T> Optional<T> get(Object packet, String key) {
        Validate.notNull((Object)key, (String)"Null keys are not permitted!");
        if (META_CACHE == null) {
            return Optional.empty();
        }
        List meta = (List)META_CACHE.getIfPresent(packet);
        if (meta == null) {
            return Optional.empty();
        }
        for (MetaObject object : meta) {
            if (!object.key.equals(key)) continue;
            return Optional.of(object.value);
        }
        return Optional.empty();
    }

    private static void createCache() {
        META_CACHE = CacheBuilder.newBuilder().expireAfterWrite(1L, TimeUnit.MINUTES).build();
    }

    public static <T> void set(Object packet, String key, T value) {
        ArrayList packetMeta;
        Validate.notNull((Object)key, (String)"Null keys are not permitted!");
        if (META_CACHE == null) {
            PacketMetadata.createCache();
        }
        try {
            packetMeta = (ArrayList)META_CACHE.get(packet, ArrayList::new);
        }
        catch (ExecutionException ex) {
            packetMeta = new ArrayList();
        }
        packetMeta.removeIf(meta -> ((MetaObject)meta).key.equals(key));
        packetMeta.add(new MetaObject(key, value));
        META_CACHE.put(packet, packetMeta);
    }

    public static <T> Optional<T> remove(Object packet, String key) {
        Validate.notNull((Object)key, (String)"Null keys are not permitted!");
        if (META_CACHE == null) {
            return Optional.empty();
        }
        List packetMeta = (List)META_CACHE.getIfPresent(packet);
        if (packetMeta == null) {
            return Optional.empty();
        }
        Optional<Object> value = Optional.empty();
        Iterator iter = packetMeta.iterator();
        while (iter.hasNext()) {
            MetaObject meta = (MetaObject)iter.next();
            if (!meta.key.equals(key)) continue;
            value = Optional.of(meta.value);
            iter.remove();
        }
        return value;
    }

    private static class MetaObject<T> {
        private final String key;
        private final T value;

        private MetaObject(String key, T value) {
            this.key = key;
            this.value = value;
        }

        public int hashCode() {
            return Objects.hash(this.key, this.value);
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o instanceof MetaObject) {
                MetaObject that = (MetaObject)o;
                return that.key.equals(this.key) && that.value.equals(this.value);
            }
            return false;
        }

        public String toString() {
            return "MetaObject[" + this.key + "=" + this.value + "]";
        }
    }
}

