/*
 * Decompiled with CFR 0.152.
 */
package com.comphenix.protocol;

import com.comphenix.protocol.CommandBase;
import com.comphenix.protocol.ProtocolConfig;
import com.comphenix.protocol.ProtocolLibrary;
import com.comphenix.protocol.ProtocolLogger;
import com.comphenix.protocol.ProtocolManager;
import com.comphenix.protocol.error.DetailedErrorReporter;
import com.comphenix.protocol.error.ErrorReporter;
import com.comphenix.protocol.events.PacketListener;
import com.comphenix.protocol.timing.TimingReport;
import com.comphenix.protocol.timing.TimingTrackerManager;
import com.comphenix.protocol.updater.Updater;
import com.comphenix.protocol.utility.Closer;
import com.google.common.collect.ImmutableSet;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.file.Path;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashSet;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginDescriptionFile;

class CommandProtocol
extends CommandBase {
    public static final String NAME = "protocol";
    private Plugin plugin;
    private Updater updater;
    private ProtocolConfig config;
    private static SimpleDateFormat FILE_FORMAT;
    private static SimpleDateFormat TIMESTAMP_FORMAT;

    public CommandProtocol(ErrorReporter reporter, Plugin plugin, Updater updater, ProtocolConfig config) {
        super(reporter, "protocol.admin", NAME, 1);
        this.plugin = plugin;
        this.updater = updater;
        this.config = config;
    }

    @Override
    protected boolean handleCommand(CommandSender sender, String[] args) {
        String subCommand = args[0];
        if (subCommand.equalsIgnoreCase("config") || subCommand.equalsIgnoreCase("reload")) {
            this.reloadConfiguration(sender);
        } else if (subCommand.equalsIgnoreCase("check")) {
            this.checkVersion(sender, true);
        } else if (subCommand.equalsIgnoreCase("update")) {
            this.updateVersion(sender, true);
        } else if (subCommand.equalsIgnoreCase("timings")) {
            this.toggleTimings(sender, args);
        } else if (subCommand.equalsIgnoreCase("listeners")) {
            this.printListeners(sender);
        } else if (subCommand.equalsIgnoreCase("version")) {
            this.printVersion(sender);
        } else if (subCommand.equalsIgnoreCase("dump")) {
            this.dump(sender);
        } else {
            return false;
        }
        return true;
    }

    public void checkVersion(CommandSender sender, boolean command) {
        this.performUpdate(sender, Updater.UpdateType.NO_DOWNLOAD, command);
    }

    public void updateVersion(CommandSender sender, boolean command) {
        this.performUpdate(sender, Updater.UpdateType.DEFAULT, command);
    }

    private void printListeners(CommandSender sender) {
        ProtocolManager manager = ProtocolLibrary.getProtocolManager();
        sender.sendMessage(ChatColor.GOLD + "Packet listeners:");
        for (PacketListener listener : manager.getPacketListeners()) {
            sender.sendMessage(ChatColor.GOLD + " - " + listener);
        }
        sender.sendMessage(ChatColor.GOLD + "Asynchronous listeners:");
        for (PacketListener listener : manager.getAsynchronousManager().getAsyncHandlers()) {
            sender.sendMessage(ChatColor.GOLD + " - " + listener);
        }
    }

    private void performUpdate(final CommandSender sender, Updater.UpdateType type, final boolean command) {
        if (this.updater.isChecking()) {
            sender.sendMessage(ChatColor.RED + "Already checking for an update.");
            return;
        }
        Runnable notify = new Runnable(){

            @Override
            public void run() {
                if (command) {
                    sender.sendMessage(ChatColor.YELLOW + "[ProtocolLib] " + CommandProtocol.this.updater.getResult());
                    String remoteVersion = CommandProtocol.this.updater.getRemoteVersion();
                    if (remoteVersion != null) {
                        sender.sendMessage(ChatColor.YELLOW + "Remote version: " + remoteVersion);
                        sender.sendMessage(ChatColor.YELLOW + "Current version: " + CommandProtocol.this.plugin.getDescription().getVersion());
                    }
                } else if (CommandProtocol.this.updater.shouldNotify() || CommandProtocol.this.config.isDebug()) {
                    sender.sendMessage(ChatColor.YELLOW + "[ProtocolLib] " + CommandProtocol.this.updater.getResult());
                }
                CommandProtocol.this.updater.removeListener(this);
                CommandProtocol.this.updateFinished();
            }
        };
        this.updater.start(type);
        this.updater.addListener(notify);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void toggleTimings(CommandSender sender, String[] args) {
        boolean isNotTracking;
        boolean bl = isNotTracking = !TimingTrackerManager.isTracking();
        if (args.length == 2) {
            Boolean parsed = this.parseBoolean(this.toQueue(args, 2), "start");
            if (parsed == null) {
                sender.sendMessage(ChatColor.RED + "Specify a state: ON or OFF.");
                return;
            }
            isNotTracking = parsed;
        } else if (args.length > 2) {
            sender.sendMessage(ChatColor.RED + "Too many parameters.");
            return;
        }
        if (isNotTracking) {
            if (TimingTrackerManager.startTracking()) {
                sender.sendMessage(ChatColor.GOLD + "Started timing packet listeners.");
                return;
            }
            sender.sendMessage(ChatColor.RED + "Packet timing already started.");
            return;
        }
        if (TimingTrackerManager.stopTracking()) {
            this.saveTimings(TimingTrackerManager.createReportAndReset());
            sender.sendMessage(ChatColor.GOLD + "Stopped and saved result in plugin folder.");
            return;
        }
        sender.sendMessage(ChatColor.RED + "Packet timing already stopped.");
    }

    private void saveTimings(TimingReport report) {
        try {
            Path path = this.plugin.getDataFolder().toPath().resolve("timings_" + System.currentTimeMillis() + ".txt");
            report.saveTo(path);
        }
        catch (IOException e) {
            this.reporter.reportMinimal(this.plugin, "saveTimings()", e);
        }
    }

    public void updateFinished() {
        long currentTime = TimeUnit.MILLISECONDS.toSeconds(System.currentTimeMillis());
        this.config.setAutoLastTime(currentTime);
        this.config.saveAll();
    }

    public void reloadConfiguration(CommandSender sender) {
        this.plugin.reloadConfig();
        sender.sendMessage(ChatColor.YELLOW + "Reloaded configuration!");
    }

    private void printVersion(CommandSender sender) {
        PluginDescriptionFile desc = this.plugin.getDescription();
        sender.sendMessage(ChatColor.GREEN + desc.getName() + ChatColor.WHITE + " v" + ChatColor.GREEN + desc.getVersion());
        sender.sendMessage(ChatColor.WHITE + "Authors: " + ChatColor.GREEN + "dmulloy2" + ChatColor.WHITE + " and " + ChatColor.GREEN + "Comphenix");
        sender.sendMessage(ChatColor.WHITE + "Issues: " + ChatColor.GREEN + "https://github.com/dmulloy2/ProtocolLib/issues");
    }

    private void dump(CommandSender sender) {
        if (FILE_FORMAT == null) {
            FILE_FORMAT = new SimpleDateFormat("yyyy-MM-dd_HH.mm.ss");
        }
        if (TIMESTAMP_FORMAT == null) {
            TIMESTAMP_FORMAT = new SimpleDateFormat("MM/dd/yy HH:mm:ss");
        }
        try (Closer closer = Closer.create();){
            Date date = new Date();
            File file = new File(this.plugin.getDataFolder(), "dump-" + FILE_FORMAT.format(date) + ".txt");
            if (file.exists()) {
                file.delete();
            }
            file.createNewFile();
            FileWriter fw = closer.register(new FileWriter(file));
            PrintWriter pw = closer.register(new PrintWriter(fw));
            pw.println("ProtocolLib Dump");
            pw.println("Timestamp: " + TIMESTAMP_FORMAT.format(date));
            pw.println();
            pw.println("ProtocolLib Version: " + this.plugin.toString());
            pw.println("Bukkit Version: " + this.plugin.getServer().getBukkitVersion());
            pw.println("Server Version: " + this.plugin.getServer().getVersion());
            pw.println("Java Version: " + System.getProperty("java.version"));
            pw.println();
            ProtocolManager manager = ProtocolLibrary.getProtocolManager();
            pw.println("ProtocolLib: " + DetailedErrorReporter.getStringDescription(this.plugin));
            pw.println("Manager: " + DetailedErrorReporter.getStringDescription(manager));
            pw.println();
            ImmutableSet<PacketListener> listeners = manager.getPacketListeners();
            HashSet<Plugin> plugins = new HashSet<Plugin>();
            if (!listeners.isEmpty()) {
                pw.println("Listeners:");
                for (PacketListener listener : listeners) {
                    pw.println(DetailedErrorReporter.getStringDescription(listener));
                    Plugin plugin = listener.getPlugin();
                    if (plugin != null) {
                        plugins.add(plugin);
                        continue;
                    }
                    pw.println("(Missing plugin!)");
                }
                pw.println();
            } else {
                pw.println("No listeners");
            }
            if (!plugins.isEmpty()) {
                pw.println("Plugins Using ProtocolLib:");
                for (Plugin plugin : plugins) {
                    pw.println(plugin.getName() + " by " + plugin.getDescription().getAuthors());
                }
            }
            sender.sendMessage("Data dump written to " + file.getAbsolutePath());
        }
        catch (IOException ex) {
            ProtocolLogger.log(Level.SEVERE, "Failed to create dump:", ex);
            sender.sendMessage(ChatColor.RED + "Failed to create dump! Check console!");
        }
    }
}

