# Security Policy

## Supported Versions

Overview over versions of ChestShop that are currently being actively developed
and which ones are supported with security updates if necessary.

| Version       | Active development | Security Fixes     |
| ------------- | ------------------ | ------------------ |
| latest        | :heavy_check_mark: | :heavy_check_mark: |
| < latest      | :x:                | :x:                |
| 3.9.3-1.12    | :x:                | :heavy_check_mark: |
| 3.9.2-1.8.8   | :x:                | :heavy_check_mark: |

Updates for the different versions can be found on the [build server](https://ci.minebench.de/job/ChestShop-3/),
only the latest version will get releases on the main project pages.

## Reporting a Vulnerability

If you want to report an issue which might pose a security risk then
you can do this in private:

- Open a report [directly on GitHub](https://github.com/ChestShop-authors/ChestShop-3/security/advisories/new)
- [Start a private conversation](https://www.spigotmc.org/conversations/add?to=Phoenix616&title=ChestShop%20Vulnerability) with Phoenix616 on SpigotMC.org 
- Message `phoenix616` on the [Esper.net IRC network](https://esper.net)

For issues that do not have security implications please [open an issue](https://github.com/ChestShop-authors/ChestShop-3/issues/new/choose).
