/*
 * Decompiled with CFR 0.152.
 */
package com.Acrobot.ChestShop.Utils;

import com.Acrobot.Breeze.Utils.BlockUtil;
import com.Acrobot.Breeze.Utils.ImplementationAdapter;
import com.Acrobot.ChestShop.Configuration.Properties;
import com.Acrobot.ChestShop.Signs.ChestShopSign;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.BlockState;
import org.bukkit.block.Container;
import org.bukkit.block.DoubleChest;
import org.bukkit.block.Sign;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.type.Chest;
import org.bukkit.block.data.type.WallSign;
import org.bukkit.inventory.InventoryHolder;

public class uBlock {
    public static final BlockFace[] CHEST_EXTENSION_FACES = new BlockFace[]{BlockFace.EAST, BlockFace.NORTH, BlockFace.WEST, BlockFace.SOUTH};
    public static final BlockFace[] SHOP_FACES = new BlockFace[]{BlockFace.SELF, BlockFace.DOWN, BlockFace.UP, BlockFace.EAST, BlockFace.NORTH, BlockFace.WEST, BlockFace.SOUTH};
    @Deprecated
    public static final BlockFace[] NEIGHBOR_FACES = new BlockFace[]{BlockFace.EAST, BlockFace.NORTH, BlockFace.WEST, BlockFace.SOUTH};

    public static Sign getConnectedSign(BlockState blockState) {
        return uBlock.getConnectedSign(blockState.getBlock());
    }

    public static Sign getConnectedSign(Block block) {
        Block neighbor;
        Sign sign = uBlock.findAnyNearbyShopSign(block);
        if (sign == null && (neighbor = uBlock.findNeighbor(block)) != null) {
            sign = uBlock.findAnyNearbyShopSign(neighbor);
        }
        return sign;
    }

    @Deprecated
    public static org.bukkit.block.Chest findConnectedChest(Sign sign) {
        if (!BlockUtil.isLoaded(sign.getBlock())) {
            return null;
        }
        BlockFace signFace = null;
        BlockData data = sign.getBlockData();
        if (data instanceof WallSign) {
            signFace = ((WallSign)data).getFacing().getOppositeFace();
        }
        return uBlock.findConnectedChest(sign.getBlock(), signFace);
    }

    @Deprecated
    public static org.bukkit.block.Chest findConnectedChest(Block block) {
        BlockData data;
        BlockFace signFace = null;
        if (BlockUtil.isSign(block) && (data = block.getBlockData()) instanceof WallSign) {
            signFace = ((WallSign)data).getFacing().getOppositeFace();
        }
        return uBlock.findConnectedChest(block, signFace);
    }

    @Deprecated
    private static org.bukkit.block.Chest findConnectedChest(Block block, BlockFace signFace) {
        Block faceBlock;
        if (!BlockUtil.isLoaded(block)) {
            return null;
        }
        if (signFace != null && BlockUtil.isChest(faceBlock = block.getRelative(signFace))) {
            return (org.bukkit.block.Chest)faceBlock.getState();
        }
        for (BlockFace bf : SHOP_FACES) {
            Block faceBlock2;
            if (bf == signFace || !BlockUtil.isChest(faceBlock2 = block.getRelative(bf))) continue;
            return (org.bukkit.block.Chest)faceBlock2.getState();
        }
        return null;
    }

    public static Container findConnectedContainer(Sign sign) {
        if (!BlockUtil.isLoaded(sign.getBlock())) {
            return null;
        }
        BlockFace signFace = null;
        BlockData data = sign.getBlockData();
        if (data instanceof WallSign) {
            signFace = ((WallSign)data).getFacing().getOppositeFace();
        }
        return uBlock.findConnectedContainer(sign.getLocation(), signFace);
    }

    public static Container findConnectedContainer(Block block) {
        if (!BlockUtil.isLoaded(block)) {
            return null;
        }
        BlockFace signFace = null;
        BlockData data = block.getBlockData();
        if (data instanceof WallSign) {
            signFace = ((WallSign)data).getFacing().getOppositeFace();
        }
        return uBlock.findConnectedContainer(block.getLocation(), signFace);
    }

    private static Container findConnectedContainer(Location location, BlockFace signFace) {
        Block faceBlock;
        if (signFace != null && uBlock.couldBeShopContainer(faceBlock = location.clone().add((double)signFace.getModX(), (double)signFace.getModY(), (double)signFace.getModZ()).getBlock())) {
            return (Container)faceBlock.getState();
        }
        for (BlockFace bf : SHOP_FACES) {
            Block faceBlock2;
            if (bf == signFace || !uBlock.couldBeShopContainer(faceBlock2 = location.clone().add((double)bf.getModX(), (double)bf.getModY(), (double)bf.getModZ()).getBlock())) continue;
            return (Container)faceBlock2.getState();
        }
        return null;
    }

    @Deprecated
    public static Sign findValidShopSign(Block block, String originalName) {
        Sign ownerShopSign = null;
        for (BlockFace bf : SHOP_FACES) {
            Sign sign;
            Block faceBlock = block.getRelative(bf);
            if (!BlockUtil.isSign(faceBlock) || !ChestShopSign.isValid(sign = (Sign)faceBlock.getState()) || !uBlock.signIsAttachedToBlock(sign, block)) continue;
            if (!sign.getLine(0).equals(originalName)) {
                return sign;
            }
            if (ownerShopSign != null) continue;
            ownerShopSign = sign;
        }
        return ownerShopSign;
    }

    public static List<Sign> findConnectedShopSigns(InventoryHolder chestShopInventoryHolder) {
        Block chestBlock;
        ArrayList<Sign> result = new ArrayList<Sign>();
        if (chestShopInventoryHolder instanceof DoubleChest) {
            InventoryHolder leftChestSide = ImplementationAdapter.getLeftSide((DoubleChest)chestShopInventoryHolder, false);
            InventoryHolder rightChestSide = ImplementationAdapter.getRightSide((DoubleChest)chestShopInventoryHolder, false);
            if (!(leftChestSide instanceof BlockState) || !(rightChestSide instanceof BlockState)) {
                return result;
            }
            Block leftChest = ((BlockState)leftChestSide).getBlock();
            Block rightChest = ((BlockState)rightChestSide).getBlock();
            if (ChestShopSign.isShopBlock(leftChest)) {
                result.addAll(uBlock.findConnectedShopSigns(leftChest));
            }
            if (ChestShopSign.isShopBlock(rightChest)) {
                result.addAll(uBlock.findConnectedShopSigns(rightChest));
            }
        } else if (chestShopInventoryHolder instanceof BlockState && ChestShopSign.isShopBlock(chestBlock = ((BlockState)chestShopInventoryHolder).getBlock())) {
            result.addAll(uBlock.findConnectedShopSigns(chestBlock));
        }
        return result;
    }

    public static List<Sign> findConnectedShopSigns(Block chestBlock) {
        ArrayList<Sign> result = new ArrayList<Sign>();
        for (BlockFace bf : SHOP_FACES) {
            Sign sign;
            Container signContainer;
            Block faceBlock = chestBlock.getRelative(bf);
            if (!BlockUtil.isSign(faceBlock) || (signContainer = uBlock.findConnectedContainer(sign = (Sign)faceBlock.getState())) == null || !chestBlock.equals((Object)signContainer.getBlock()) || !ChestShopSign.isValid(sign)) continue;
            result.add(sign);
        }
        return result;
    }

    public static Sign findAnyNearbyShopSign(Block block) {
        for (BlockFace bf : SHOP_FACES) {
            BlockData data;
            Block faceBlock = block.getRelative(bf);
            if (!BlockUtil.isLoaded(faceBlock) || (!((data = faceBlock.getBlockData()) instanceof WallSign) ? !(data instanceof org.bukkit.block.data.type.Sign) : ((WallSign)data).getFacing() != bf && uBlock.couldBeShopContainer(faceBlock.getRelative(((WallSign)data).getFacing().getOppositeFace())))) continue;
            Sign sign = (Sign)ImplementationAdapter.getState(faceBlock, false);
            if (!ChestShopSign.isValid(sign)) continue;
            return sign;
        }
        return null;
    }

    public static org.bukkit.block.Chest findNeighbor(org.bukkit.block.Chest chest) {
        Block neighbor = uBlock.findNeighbor(chest.getBlock());
        return neighbor != null ? (org.bukkit.block.Chest)neighbor.getState() : null;
    }

    public static Block findNeighbor(Block block) {
        Block neighborBlock;
        if (!BlockUtil.isLoaded(block)) {
            return null;
        }
        BlockData blockData = block.getBlockData();
        if (!(blockData instanceof Chest)) {
            return null;
        }
        Chest chestData = (Chest)blockData;
        if (chestData.getType() == Chest.Type.SINGLE) {
            return null;
        }
        BlockFace chestFace = chestData.getFacing();
        if (chestFace == BlockFace.WEST) {
            chestFace = BlockFace.NORTH;
        } else if (chestFace == BlockFace.NORTH) {
            chestFace = BlockFace.EAST;
        } else if (chestFace == BlockFace.EAST) {
            chestFace = BlockFace.SOUTH;
        } else if (chestFace == BlockFace.SOUTH) {
            chestFace = BlockFace.WEST;
        }
        if (chestData.getType() == Chest.Type.RIGHT) {
            chestFace = chestFace.getOppositeFace();
        }
        if (!BlockUtil.isLoaded(neighborBlock = block.getRelative(chestFace))) {
            return null;
        }
        if (neighborBlock.getType() == block.getType()) {
            return neighborBlock;
        }
        return null;
    }

    private static boolean signIsAttachedToBlock(Sign sign, Block block) {
        return sign.getBlock().equals((Object)block) || BlockUtil.getAttachedBlock(sign).equals((Object)block);
    }

    public static boolean couldBeShopContainer(Block block) {
        return block != null && BlockUtil.isLoaded(block) && Properties.SHOP_CONTAINERS.contains(block.getType());
    }

    public static boolean couldBeShopContainer(InventoryHolder holder) {
        return holder instanceof Container && uBlock.couldBeShopContainer(((Container)holder).getBlock()) || holder instanceof DoubleChest && uBlock.couldBeShopContainer(ImplementationAdapter.getLeftSide((DoubleChest)holder, false));
    }
}

