/*
 * Decompiled with CFR 0.152.
 */
package com.Acrobot.ChestShop.Utils;

import com.Acrobot.Breeze.Utils.InventoryUtil;
import com.Acrobot.Breeze.Utils.MaterialUtil;
import com.Acrobot.Breeze.Utils.StringUtil;
import com.Acrobot.ChestShop.ChestShop;
import com.Acrobot.ChestShop.Events.ItemParseEvent;
import com.Acrobot.ChestShop.Events.ItemStringQueryEvent;
import java.util.ArrayList;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.event.Event;
import org.bukkit.inventory.ItemStack;

public class ItemUtil {
    public static String getItemList(ItemStack[] items) {
        Map<ItemStack, Integer> itemCounts = InventoryUtil.getItemCounts(items);
        ArrayList<String> itemText = new ArrayList<String>();
        for (Map.Entry<ItemStack, Integer> entry : itemCounts.entrySet()) {
            itemText.add(entry.getValue() + " " + ItemUtil.getName(entry.getKey()));
        }
        return String.join((CharSequence)", ", itemText);
    }

    public static String getName(ItemStack itemStack) {
        return ItemUtil.getName(itemStack, 0);
    }

    public static String getName(ItemStack itemStack, int maxWidth) {
        String code = ChestShop.callEvent(new ItemStringQueryEvent(itemStack, maxWidth)).getItemString();
        if (code != null) {
            int codeWidth;
            if (maxWidth > 0 && (codeWidth = StringUtil.getMinecraftStringWidth(code)) > maxWidth) {
                int exceeding = codeWidth - maxWidth;
                int poundIndex = code.indexOf(35);
                int colonIndex = code.indexOf(58);
                String material = code;
                String rest = "";
                if (poundIndex > 0 && (colonIndex < 0 || poundIndex < colonIndex)) {
                    material = code.substring(0, poundIndex);
                    rest = code.substring(poundIndex);
                } else if (colonIndex > 0 && (poundIndex < 0 || colonIndex < poundIndex)) {
                    material = code.substring(0, colonIndex);
                    rest = code.substring(colonIndex);
                }
                code = MaterialUtil.getShortenedName(material, StringUtil.getMinecraftStringWidth(material) - exceeding) + rest;
            }
            ItemParseEvent parseEvent = new ItemParseEvent(code);
            Bukkit.getPluginManager().callEvent((Event)parseEvent);
            ItemStack codeItem = parseEvent.getItem();
            if (!MaterialUtil.equals(itemStack, codeItem)) {
                throw new IllegalArgumentException("Cannot generate code for item " + itemStack + " with maximum length of " + maxWidth + " (code " + code + " results in item " + codeItem + ")");
            }
        }
        return code;
    }

    public static String getSignName(ItemStack itemStack) {
        return ItemUtil.getName(itemStack, MaterialUtil.MAXIMUM_SIGN_WIDTH);
    }
}

