/*
 * Decompiled with CFR 0.152.
 */
package com.Acrobot.ChestShop.Updater;

import com.google.common.hash.Hashing;
import com.google.common.io.Files;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Enumeration;
import java.util.Locale;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.Plugin;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.JSONValue;

public final class Updater {
    private Plugin plugin;
    private UpdateType type;
    private String versionName;
    private String versionLink;
    private String versionHash;
    private String versionType;
    private String versionGameVersion;
    private boolean announce;
    private URL url;
    private File file;
    private Thread thread;
    private String id;
    private String apiKey = null;
    private static final String TITLE_VALUE = "version_number";
    private static final String FILES_VALUE = "files";
    private static final String LINK_VALUE = "url";
    private static final String TYPE_VALUE = "version_type";
    private static final String VERSION_VALUE = "game_versions";
    private static final String QUERY = "/v2/project/%projectid%/version";
    private static final String HOST = "https://api.modrinth.com";
    private static final String USER_AGENT = "Updater v2.1 (by Gravity) - Modified by Phoenix616 for Modrinth";
    private static final Pattern VERSION_PATTERN = Pattern.compile("(\\d+\\.\\d+(?>\\.\\d+)?)");
    private static final String[] NO_UPDATE_TAG = new String[]{"-DEV", "-PRE", "-SNAPSHOT"};
    private static final int BYTE_SIZE = 1024;
    private final YamlConfiguration config = new YamlConfiguration();
    private UpdateResult result = UpdateResult.SUCCESS;

    public Updater(Plugin plugin, String id, File file, UpdateType type, boolean announce) {
        this.plugin = plugin;
        this.type = type;
        this.announce = announce;
        this.file = file;
        this.id = id;
        File pluginFile = plugin.getDataFolder().getParentFile();
        File updaterFile = new File(pluginFile, "Updater");
        File updaterConfigFile = new File(updaterFile, "config.yml");
        this.config.options().header("This configuration file affects all plugins using the Updater system (version 2+ )\nIf you wish to use your API key, then you can get it from https://modrinth.com/settings/pats and place it below.\nSome updating systems will not adhere to the disabled value, but these may be turned off in their plugin's configuration.");
        this.config.addDefault("modrinth-key", (Object)"PUT_PAT_HERE");
        this.config.addDefault("disable", (Object)false);
        if (!updaterFile.exists()) {
            updaterFile.mkdir();
        }
        boolean createFile = !updaterConfigFile.exists();
        try {
            if (createFile) {
                updaterConfigFile.createNewFile();
                this.config.options().copyDefaults(true);
                this.config.save(updaterConfigFile);
            } else {
                this.config.load(updaterConfigFile);
            }
        }
        catch (Exception e) {
            if (createFile) {
                plugin.getLogger().severe("The updater could not create configuration at " + updaterFile.getAbsolutePath());
            } else {
                plugin.getLogger().severe("The updater could not load configuration at " + updaterFile.getAbsolutePath());
            }
            plugin.getLogger().log(Level.SEVERE, null, e);
        }
        if (this.config.getBoolean("disable")) {
            this.result = UpdateResult.DISABLED;
            return;
        }
        String key = this.config.getString("api-key");
        if (key != null && (key.equalsIgnoreCase("PUT_API_KEY_HERE") || key.equals(""))) {
            key = null;
        }
        this.apiKey = key;
        try {
            this.url = new URL(HOST + QUERY.replace("%projectid%", id));
        }
        catch (MalformedURLException e) {
            plugin.getLogger().log(Level.SEVERE, "The project ID provided for updating, " + id + " is invalid.", e);
            this.result = UpdateResult.FAIL_BADID;
        }
        this.thread = new Thread(new UpdateRunnable());
        this.thread.start();
    }

    public UpdateResult getResult() {
        this.waitForThread();
        return this.result;
    }

    public ReleaseType getLatestType() {
        this.waitForThread();
        return this.getLatestTypeInternal();
    }

    private ReleaseType getLatestTypeInternal() {
        if (this.versionType != null) {
            for (ReleaseType type : ReleaseType.values()) {
                if (!this.versionType.equals(type.name().toLowerCase(Locale.ROOT))) continue;
                return type;
            }
        }
        return null;
    }

    public String getLatestGameVersion() {
        this.waitForThread();
        return this.versionGameVersion;
    }

    public String getLatestName() {
        this.waitForThread();
        return this.versionName;
    }

    public String getLatestFileLink() {
        this.waitForThread();
        return this.versionLink;
    }

    private void waitForThread() {
        if (this.thread != null && this.thread.isAlive()) {
            try {
                this.thread.join();
            }
            catch (InterruptedException e) {
                this.plugin.getLogger().log(Level.SEVERE, null, e);
            }
        }
    }

    private void saveFile(File folder, String file, String link) {
        if (!folder.exists()) {
            folder.mkdir();
        }
        try {
            URL url = new URL(link);
            int fileLength = url.openConnection().getContentLength();
            File targetFile = new File(folder, file);
            try (BufferedInputStream in = new BufferedInputStream(url.openStream());
                 FileOutputStream fout = new FileOutputStream(targetFile);){
                File dFile;
                String fileHash;
                int count;
                byte[] data = new byte[1024];
                if (this.announce) {
                    this.plugin.getLogger().info("About to download a new update: " + this.versionName);
                }
                long downloaded = 0L;
                int lastAnnouncePercent = 0;
                while ((count = in.read(data, 0, 1024)) != -1) {
                    fout.write(data, 0, count);
                    int percent = (int)((downloaded += (long)count) * 100L / (long)fileLength);
                    if (!this.announce || lastAnnouncePercent == percent || percent % 10 != 0) continue;
                    lastAnnouncePercent = percent;
                    this.plugin.getLogger().info("Downloading update: " + percent + "% of " + fileLength + " bytes.");
                }
                if (this.versionHash != null && !this.versionHash.equalsIgnoreCase(fileHash = Files.asByteSource((File)targetFile).hash(Hashing.sha512()).toString())) {
                    this.plugin.getLogger().warning("Downloaded file " + file + " does not match the remote file's SHA-1 hash");
                    this.result = UpdateResult.FAIL_HASH;
                    return;
                }
                File[] files = this.plugin.getServer().getUpdateFolderFile().listFiles();
                if (files != null) {
                    for (File xFile : files) {
                        if (!xFile.getName().endsWith(".zip")) continue;
                        xFile.delete();
                    }
                }
                if ((dFile = new File(folder.getAbsolutePath(), file)).getName().endsWith(".zip")) {
                    this.unzip(dFile.getCanonicalPath());
                }
                if (this.announce) {
                    this.plugin.getLogger().info("Finished updating.");
                }
            }
        }
        catch (Exception ex) {
            this.plugin.getLogger().warning("The auto-updater tried to download a new update, but was unsuccessful.");
            this.result = UpdateResult.FAIL_DOWNLOAD;
        }
    }

    private void unzip(String file) {
        File fSourceZip = new File(file);
        String zipPath = file.substring(0, file.length() - 4);
        try (ZipFile zipFile = new ZipFile(fSourceZip);){
            Enumeration<? extends ZipEntry> e = zipFile.entries();
            while (e.hasMoreElements()) {
                int b;
                ZipEntry entry = e.nextElement();
                File destinationFilePath = new File(zipPath, entry.getName());
                destinationFilePath.getParentFile().mkdirs();
                if (entry.isDirectory()) continue;
                BufferedInputStream bis = new BufferedInputStream(zipFile.getInputStream(entry));
                byte[] buffer = new byte[1024];
                FileOutputStream fos = new FileOutputStream(destinationFilePath);
                BufferedOutputStream bos = new BufferedOutputStream(fos, 1024);
                while ((b = bis.read(buffer, 0, 1024)) != -1) {
                    bos.write(buffer, 0, b);
                }
                bos.flush();
                bos.close();
                bis.close();
                String name = destinationFilePath.getName();
                if (!name.endsWith(".jar") || !this.pluginFile(name)) continue;
                destinationFilePath.renameTo(new File(this.plugin.getServer().getUpdateFolderFile(), name));
            }
            zipFile.close();
            File[] files = new File(zipPath).listFiles();
            if (files != null) {
                for (File dFile : files) {
                    if (dFile.isDirectory() && this.pluginFile(dFile.getName())) {
                        File oFile = new File(this.plugin.getDataFolder().getParent(), dFile.getName());
                        File[] contents = oFile.listFiles();
                        File[] newFiles = dFile.listFiles();
                        if (newFiles != null) {
                            for (File cFile : newFiles) {
                                boolean found = false;
                                if (contents != null) {
                                    for (File xFile : contents) {
                                        if (!xFile.getName().equals(cFile.getName())) continue;
                                        found = true;
                                        break;
                                    }
                                }
                                if (!found) {
                                    cFile.renameTo(new File(oFile.getCanonicalFile(), cFile.getName()));
                                    continue;
                                }
                                cFile.delete();
                            }
                        }
                    }
                    dFile.delete();
                }
            }
            new File(zipPath).delete();
            fSourceZip.delete();
        }
        catch (IOException e) {
            this.plugin.getLogger().log(Level.SEVERE, "The auto-updater tried to unzip a new update file, but was unsuccessful.", e);
            this.result = UpdateResult.FAIL_DOWNLOAD;
        }
        new File(file).delete();
    }

    private boolean pluginFile(String name) {
        File[] files = new File("plugins").listFiles();
        if (files != null) {
            for (File file : files) {
                if (!file.getName().equals(name)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean versionCheck(String title) {
        if (this.type != UpdateType.NO_VERSION_CHECK) {
            String rawLocalVersion = this.plugin.getDescription().getVersion();
            Matcher localMatcher = VERSION_PATTERN.matcher(rawLocalVersion);
            Matcher titleMatcher = VERSION_PATTERN.matcher(title);
            if (titleMatcher.find() && localMatcher.find()) {
                String localVersion = localMatcher.group(1);
                String remoteVersion = titleMatcher.group(1);
                if (this.hasTag(rawLocalVersion) || !this.shouldUpdate(localVersion, remoteVersion)) {
                    this.result = UpdateResult.NO_UPDATE;
                    return false;
                }
            } else {
                this.result = UpdateResult.FAIL_NOVERSION;
                return false;
            }
        }
        return true;
    }

    public boolean shouldUpdate(String localVersion, String remoteVersion) {
        if (this.type != UpdateType.NO_DOWNLOAD && localVersion.contains("DEV") || this.getLatestTypeInternal() != ReleaseType.RELEASE) {
            return false;
        }
        if (localVersion.equalsIgnoreCase(remoteVersion)) {
            return true;
        }
        try {
            int[] localSemanticVersion = this.parseVersion(localVersion);
            int[] remoteSemanticVersion = this.parseVersion(remoteVersion);
            for (int i = 0; i < localSemanticVersion.length; ++i) {
                if (remoteSemanticVersion.length < i + 1) {
                    return false;
                }
                if (localSemanticVersion[i] < remoteSemanticVersion[i]) {
                    return true;
                }
                if (localSemanticVersion[i] <= remoteSemanticVersion[i]) continue;
                return false;
            }
            return false;
        }
        catch (NumberFormatException e) {
            this.plugin.getLogger().warning("Invalid version number found: " + localVersion + " or " + remoteVersion);
            return true;
        }
    }

    private int[] parseVersion(String version) {
        String[] split = version.split("\\.");
        int[] semanticVersion = new int[split.length];
        for (int i = 0; i < split.length; ++i) {
            semanticVersion[i] = Integer.parseInt(split[i]);
        }
        return semanticVersion;
    }

    private boolean hasTag(String version) {
        for (String string : NO_UPDATE_TAG) {
            if (!version.contains(string)) continue;
            return true;
        }
        return false;
    }

    private boolean read() {
        try {
            URLConnection conn = this.url.openConnection();
            conn.setConnectTimeout(5000);
            if (this.apiKey != null) {
                conn.addRequestProperty("Authorization", this.apiKey);
            }
            conn.addRequestProperty("User-Agent", USER_AGENT);
            conn.setDoOutput(true);
            BufferedReader reader = new BufferedReader(new InputStreamReader(conn.getInputStream()));
            String response = reader.readLine();
            JSONArray array = (JSONArray)JSONValue.parse((String)response);
            if (array.size() == 0) {
                this.plugin.getLogger().warning("The updater could not find any files for the project id " + this.id);
                this.result = UpdateResult.FAIL_BADID;
                return false;
            }
            this.versionName = (String)((JSONObject)array.get(array.size() - 1)).get((Object)TITLE_VALUE);
            JSONArray versionFiles = (JSONArray)((JSONObject)array.get(array.size() - 1)).get((Object)FILES_VALUE);
            for (Object versionFile : versionFiles) {
                JSONObject file = (JSONObject)versionFile;
                if (!file.get((Object)"primary").equals(true)) continue;
                this.versionLink = (String)file.get((Object)LINK_VALUE);
                this.versionHash = ((JSONObject)file.get((Object)"hashes")).get((Object)"sha512").toString();
                break;
            }
            this.versionType = (String)((JSONObject)array.get(array.size() - 1)).get((Object)TYPE_VALUE);
            JSONArray gameVersions = (JSONArray)((JSONObject)array.get(array.size() - 1)).get((Object)VERSION_VALUE);
            this.versionGameVersion = gameVersions.get(gameVersions.size() - 1).toString();
            return true;
        }
        catch (IOException e) {
            if (e.getMessage().contains("HTTP response code: 403")) {
                this.plugin.getLogger().severe("The Modrinth API server rejected the API key provided in plugins/Updater/config.yml");
                this.plugin.getLogger().severe("Please double-check your configuration to ensure it is correct.");
                this.result = UpdateResult.FAIL_APIKEY;
            } else {
                this.plugin.getLogger().severe("The updater could not contact the api.modrinth.com server for updating.");
                this.plugin.getLogger().severe("If you have not recently modified your configuration and this is the first time you are seeing this message, the site may be experiencing temporary downtime.");
                this.result = UpdateResult.FAIL_DBO;
            }
            this.plugin.getLogger().log(Level.SEVERE, null, e);
            return false;
        }
    }

    public static enum UpdateResult {
        SUCCESS,
        NO_UPDATE,
        DISABLED,
        FAIL_DOWNLOAD,
        FAIL_DBO,
        FAIL_NOVERSION,
        FAIL_BADID,
        FAIL_APIKEY,
        UPDATE_AVAILABLE,
        FAIL_HASH;

    }

    public static enum UpdateType {
        DEFAULT,
        NO_VERSION_CHECK,
        NO_DOWNLOAD;

    }

    private class UpdateRunnable
    implements Runnable {
        private UpdateRunnable() {
        }

        @Override
        public void run() {
            if (Updater.this.url != null && Updater.this.read() && Updater.this.versionCheck(Updater.this.versionName)) {
                if (Updater.this.versionLink != null && Updater.this.type != UpdateType.NO_DOWNLOAD) {
                    String name = Updater.this.file.getName();
                    if (Updater.this.versionLink.endsWith(".zip")) {
                        String[] split = Updater.this.versionLink.split("/");
                        name = split[split.length - 1];
                    }
                    Updater.this.saveFile(Updater.this.plugin.getServer().getUpdateFolderFile(), name, Updater.this.versionLink);
                } else {
                    Updater.this.result = UpdateResult.UPDATE_AVAILABLE;
                }
            }
        }
    }

    public static enum ReleaseType {
        ALPHA,
        BETA,
        RELEASE;

    }
}

