/*
 * Decompiled with CFR 0.152.
 */
package com.Acrobot.ChestShop.Updater;

import com.Acrobot.ChestShop.ChestShop;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.logging.Level;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.Plugin;

public class JenkinsBuildsNotifier
implements Runnable {
    private final Plugin plugin;
    private final File configFile;
    private final FileConfiguration config;
    private int build;
    private URL apiUrl;

    public JenkinsBuildsNotifier(Plugin plugin, String jenkinsJobUrl) {
        this.plugin = plugin;
        this.configFile = new File(plugin.getDataFolder(), "jenkinsBuildsNotifier.yml");
        if (this.configFile.exists()) {
            this.config = YamlConfiguration.loadConfiguration((File)this.configFile);
        } else {
            this.config = new YamlConfiguration();
            this.config.addDefault("disabled", (Object)false);
            this.config.addDefault("jenkins-job-url-override", (Object)"");
            this.config.options().copyDefaults(true);
            this.saveConfig();
        }
        if (this.config.getBoolean("disabled")) {
            return;
        }
        this.build = this.getBuildNumber();
        if (this.build < 1) {
            plugin.getLogger().log(Level.WARNING, "Unable to parse plugin build from version string! (" + plugin.getDescription().getVersion() + ")");
            return;
        }
        String jenkinsJobUrlOverride = this.config.getString("jenkins-job-url-override");
        if (jenkinsJobUrlOverride != null && !jenkinsJobUrlOverride.isEmpty()) {
            jenkinsJobUrl = jenkinsJobUrlOverride;
        }
        try {
            this.apiUrl = new URL(jenkinsJobUrl + "api/json");
            ChestShop.runInAsyncThread(this);
        }
        catch (MalformedURLException e) {
            plugin.getLogger().log(Level.WARNING, "Can not check for new dev builds as " + jenkinsJobUrl + "api/json is not a valid url!", e);
        }
    }

    private void saveConfig() {
        try {
            this.config.save(this.configFile);
        }
        catch (IOException e) {
            this.plugin.getLogger().log(Level.WARNING, "Error while saving " + this.configFile.getName() + "! " + e.getMessage());
        }
    }

    private int getBuildNumber() {
        String tag = "(build ";
        String versionStr = this.plugin.getDescription().getVersion();
        int start = versionStr.indexOf(tag);
        int end = versionStr.indexOf(41, start);
        if (start > 0 && end > start) {
            try {
                return Integer.parseInt(versionStr.substring(start + tag.length(), end));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return -1;
    }

    @Override
    public void run() {
        try {
            JsonObject lastStable;
            int lastStableBuild;
            JsonObject responseJson = this.queryJson();
            if (responseJson.has("lastStableBuild") && responseJson.get("lastStableBuild").isJsonObject() && (lastStableBuild = (lastStable = responseJson.getAsJsonObject("lastStableBuild")).get("number").getAsInt()) > this.build && this.config.getInt("last-announced-build", 0) < lastStableBuild) {
                String url = lastStable.get("url").getAsString();
                this.plugin.getLogger().log(Level.INFO, "A new development build is available for testing: " + url);
                this.config.set("last-announced-build", (Object)lastStableBuild);
                this.saveConfig();
            }
        }
        catch (Exception e) {
            this.plugin.getLogger().log(Level.WARNING, "Error while trying to query Jenkins API", e);
        }
    }

    private JsonObject queryJson() throws IOException {
        String line;
        HttpURLConnection con = (HttpURLConnection)this.apiUrl.openConnection();
        con.setRequestProperty("User-Agent", this.plugin.getName() + " " + this.plugin.getDescription().getVersion() + " Jenkins Builds Notifier");
        con.setRequestMethod("GET");
        StringBuilder msg = new StringBuilder();
        BufferedReader in = new BufferedReader(new InputStreamReader(con.getInputStream()));
        while ((line = in.readLine()) != null) {
            if (msg.length() != 0) {
                msg.append("\n");
            }
            msg.append(line);
        }
        in.close();
        return new JsonParser().parse(msg.toString()).getAsJsonObject();
    }
}

