/*
 * Decompiled with CFR 0.152.
 */
package com.Acrobot.ChestShop.UUIDs;

import com.Acrobot.Breeze.Collection.SimpleCache;
import com.Acrobot.Breeze.Utils.Encoding.Base62;
import com.Acrobot.Breeze.Utils.NameUtil;
import com.Acrobot.Breeze.Utils.NumberUtil;
import com.Acrobot.ChestShop.ChestShop;
import com.Acrobot.ChestShop.Configuration.Properties;
import com.Acrobot.ChestShop.Database.Account;
import com.Acrobot.ChestShop.Database.DaoCreator;
import com.Acrobot.ChestShop.Events.AccountAccessEvent;
import com.Acrobot.ChestShop.Events.AccountQueryEvent;
import com.Acrobot.ChestShop.Libs.ORMlite.dao.Dao;
import com.Acrobot.ChestShop.Libs.ORMlite.stmt.SelectArg;
import com.Acrobot.ChestShop.Permission;
import com.Acrobot.ChestShop.Signs.ChestShopSign;
import com.Acrobot.ChestShop.UUIDs.PlayerDTO;
import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import java.sql.SQLException;
import java.util.Date;
import java.util.Locale;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import java.util.logging.Level;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;

public class NameManager
implements Listener {
    private static final Object accountsLock = new Object();
    private static Dao<Account, String> accounts;
    private static SimpleCache<String, Account> usernameToAccount;
    private static SimpleCache<UUID, Account> uuidToAccount;
    private static SimpleCache<String, Account> shortToAccount;
    private static SimpleCache<String, Boolean> invalidPlayers;
    private static Account adminAccount;
    private static Account serverEconomyAccount;
    private static int uuidVersion;

    public static int getAccountCount() {
        try {
            return NumberUtil.toInt(accounts.queryBuilder().countOf() - 1L);
        }
        catch (SQLException e) {
            return 0;
        }
    }

    public static Account getOrCreateAccount(OfflinePlayer player) {
        Preconditions.checkNotNull((Object)player.getName(), (Object)("Name of player " + player.getUniqueId() + " is null?"));
        Preconditions.checkArgument((player instanceof Player || !Properties.ENSURE_CORRECT_PLAYERID || uuidVersion < 0 || player.getUniqueId().version() == uuidVersion ? 1 : 0) != 0, (Object)("Invalid OfflinePlayer! " + player.getUniqueId() + " has version " + player.getUniqueId().version() + " and not server version " + uuidVersion + ". If you believe that is an error and your setup allows such UUIDs then set the ENSURE_CORRECT_PLAYERID config option to false."));
        return NameManager.getOrCreateAccount(player.getUniqueId(), player.getName());
    }

    public static Account getOrCreateAccount(UUID id, String name) {
        Preconditions.checkNotNull((Object)id, (Object)"UUID of player is null?");
        Preconditions.checkNotNull((Object)name, (Object)("Name of player " + id + " is null?"));
        Account account = NameManager.getAccount(id);
        if (account == null) {
            account = NameManager.storeUsername(new PlayerDTO(id, name));
        }
        return account;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Account getAccount(UUID uuid) {
        try {
            Object object = accountsLock;
            synchronized (object) {
                return uuidToAccount.get(uuid, () -> {
                    try {
                        Account account = (Account)accounts.queryBuilder().orderBy("lastSeen", false).where().eq("uuid", new SelectArg(uuid)).queryForFirst();
                        if (account != null) {
                            account.setUuid(uuid);
                            shortToAccount.put(account.getShortName(), account);
                            usernameToAccount.put(account.getName(), account);
                            return account;
                        }
                    }
                    catch (SQLException e) {
                        ChestShop.getBukkitLogger().log(Level.WARNING, "Error while getting account for " + uuid + ":", e);
                    }
                    throw new Exception("Could not find account for " + uuid);
                });
            }
        }
        catch (ExecutionException ignored) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Account getAccount(String fullName) {
        Preconditions.checkNotNull((Object)fullName, (Object)"fullName cannot be null!");
        Preconditions.checkArgument((!fullName.isEmpty() ? 1 : 0) != 0, (Object)"fullName cannot be empty!");
        try {
            Object object = accountsLock;
            synchronized (object) {
                return usernameToAccount.get(fullName, () -> {
                    try {
                        Account account = (Account)accounts.queryBuilder().orderBy("lastSeen", false).where().eq("name", new SelectArg((Object)fullName)).queryForFirst();
                        if (account != null) {
                            account.setName(fullName);
                            shortToAccount.put(account.getShortName(), account);
                            return account;
                        }
                    }
                    catch (SQLException e) {
                        ChestShop.getBukkitLogger().log(Level.WARNING, "Error while getting account for " + fullName + ":", e);
                    }
                    throw new Exception("Could not find account for " + fullName);
                });
            }
        }
        catch (ExecutionException ignored) {
            return null;
        }
    }

    @EventHandler
    public static void onAccountQuery(AccountQueryEvent event) {
        if (event.getAccount() == null) {
            event.setAccount(NameManager.getLastAccountFromName(event.getName(), event.searchOfflinePlayers()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public static Account getAccountFromShortName(String shortName) {
        Preconditions.checkNotNull((Object)shortName, (Object)"shortName cannot be null!");
        Preconditions.checkArgument((!shortName.isEmpty() ? 1 : 0) != 0, (Object)"shortName cannot be empty!");
        Account account = null;
        try {
            Object object = accountsLock;
            synchronized (object) {
                account = shortToAccount.get(shortName, () -> {
                    try {
                        Account a = (Account)accounts.queryBuilder().where().eq("shortName", new SelectArg((Object)shortName)).queryForFirst();
                        if (a != null) {
                            a.setShortName(shortName);
                            return a;
                        }
                    }
                    catch (SQLException e) {
                        ChestShop.getBukkitLogger().log(Level.WARNING, "Error while getting account for " + shortName + ":", e);
                    }
                    throw new Exception("Could not find account for " + shortName);
                });
            }
        }
        catch (ExecutionException executionException) {
            // empty catch block
        }
        return account;
    }

    private static Account getLastAccountFromName(String name, boolean searchOfflinePlayer) {
        Account account = NameManager.getAccountFromShortName(name);
        if (account == null) {
            account = NameManager.getAccount(name);
        }
        if (account == null && searchOfflinePlayer && !invalidPlayers.contains(name.toLowerCase(Locale.ROOT))) {
            OfflinePlayer offlinePlayer = ChestShop.getBukkitServer().getOfflinePlayer(name);
            if (!(offlinePlayer == null || offlinePlayer.getName() == null || offlinePlayer.getUniqueId() == null || Properties.ENSURE_CORRECT_PLAYERID && offlinePlayer.getUniqueId().version() != uuidVersion)) {
                account = NameManager.storeUsername(new PlayerDTO(offlinePlayer.getUniqueId(), offlinePlayer.getName()));
            } else {
                invalidPlayers.put(name.toLowerCase(Locale.ROOT), true);
            }
        }
        if (account != null) {
            return NameManager.getAccount(account.getUuid());
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Account storeUsername(PlayerDTO player) {
        UUID uuid = player.getUniqueId();
        Account latestAccount = null;
        Object object = accountsLock;
        synchronized (object) {
            try {
                latestAccount = (Account)accounts.queryBuilder().where().eq("uuid", new SelectArg(uuid)).and().eq("name", new SelectArg((Object)player.getName())).queryForFirst();
            }
            catch (SQLException e) {
                ChestShop.getBukkitLogger().log(Level.WARNING, "Error while searching for latest account of " + player.getName() + "/" + uuid + ":", e);
            }
            if (latestAccount == null) {
                latestAccount = new Account(player.getName(), NameManager.getNewShortenedName(player), player.getUniqueId());
            }
            latestAccount.setLastSeen(new Date());
            try {
                NameManager.storeAccount(latestAccount);
            }
            catch (SQLException e) {
                ChestShop.getBukkitLogger().log(Level.WARNING, "Error while updating account " + latestAccount + ":", e);
                return null;
            }
            usernameToAccount.put(latestAccount.getName(), latestAccount);
            uuidToAccount.put(uuid, latestAccount);
            shortToAccount.put(latestAccount.getShortName(), latestAccount);
        }
        return latestAccount;
    }

    public static void storeAccount(Account account) throws SQLException {
        accounts.createOrUpdate(account);
    }

    private static String getNewShortenedName(PlayerDTO player) {
        String shortenedName = NameUtil.stripUsername(player.getName());
        Account account = NameManager.getAccountFromShortName(shortenedName);
        if (account == null) {
            return shortenedName;
        }
        int id = 0;
        while (account != null) {
            String baseId = Base62.encode(id);
            shortenedName = NameUtil.stripUsername(player.getName(), 14 - baseId.length()) + ":" + baseId;
            account = NameManager.getAccountFromShortName(shortenedName);
            ++id;
        }
        return shortenedName;
    }

    public static boolean canUseName(Player player, Permission base, String name) {
        if (ChestShopSign.isAdminShop(name)) {
            if (Permission.has((CommandSender)player, Permission.ADMIN_SHOP)) {
                return true;
            }
            ChestShop.logDebug(player.getName() + " cannot use the name " + name + " as it's an admin shop and they don't have the permission " + (Object)((Object)Permission.ADMIN_SHOP));
            return false;
        }
        if (Permission.otherName(player, base, name)) {
            return true;
        }
        AccountQueryEvent queryEvent = new AccountQueryEvent(name);
        ChestShop.callEvent(queryEvent);
        Account account = queryEvent.getAccount();
        if (account == null) {
            if (player.getName().equalsIgnoreCase(name)) {
                return true;
            }
            ChestShop.logDebug(player.getName() + " cannot use the name " + name + " for a shop as no account with that name exists");
            return false;
        }
        if (!account.getName().equalsIgnoreCase(name) && Permission.otherName(player, base, account.getName())) {
            return true;
        }
        AccountAccessEvent event = new AccountAccessEvent(player, account);
        ChestShop.callEvent(event);
        return event.canAccess();
    }

    @EventHandler
    public static void onAccountAccessCheck(AccountAccessEvent event) {
        if (!event.canAccess()) {
            event.setAccess(event.getPlayer().getUniqueId().equals(event.getAccount().getUuid()));
            if (!event.canAccess()) {
                ChestShop.logDebug(event.getPlayer().getName() + "/" + event.getPlayer().getUniqueId() + " cannot access the account " + event.getAccount().getName() + "/" + event.getAccount().getUuid() + " as their UUID doesn't match!");
            }
        }
    }

    public static boolean isAdminShop(UUID uuid) {
        return adminAccount != null && uuid.equals(adminAccount.getUuid());
    }

    public static boolean isServerEconomyAccount(UUID uuid) {
        return serverEconomyAccount != null && uuid.equals(serverEconomyAccount.getUuid());
    }

    public static void load() {
        if (NameManager.getUuidVersion() < 0) {
            if (Bukkit.getOnlineMode()) {
                NameManager.setUuidVersion(4);
            } else if (!Bukkit.getOnlinePlayers().isEmpty()) {
                NameManager.setUuidVersion(((Player)Bukkit.getOnlinePlayers().iterator().next()).getUniqueId().version());
            }
        }
        try {
            accounts = DaoCreator.getDaoAndCreateTable(Account.class);
            try {
                adminAccount = new Account(Properties.ADMIN_SHOP_NAME, Bukkit.getOfflinePlayer((String)Properties.ADMIN_SHOP_NAME).getUniqueId());
            }
            catch (NullPointerException ratelimitedException) {
                adminAccount = new Account(Properties.ADMIN_SHOP_NAME, UUID.nameUUIDFromBytes(("OfflinePlayer:" + Properties.ADMIN_SHOP_NAME).getBytes(Charsets.UTF_8)));
                ChestShop.getBukkitLogger().log(Level.WARNING, "Your server appears to be ratelimited by Mojang and can't query UUID data from their API. If you run into issues with admin shops please report them!");
            }
            accounts.createOrUpdate(adminAccount);
            if (!Properties.SERVER_ECONOMY_ACCOUNT.isEmpty()) {
                serverEconomyAccount = NameManager.getAccount(Properties.SERVER_ECONOMY_ACCOUNT);
            }
            if (serverEconomyAccount == null && !Properties.SERVER_ECONOMY_ACCOUNT.isEmpty() && !Properties.SERVER_ECONOMY_ACCOUNT_UUID.equals(new UUID(0L, 0L))) {
                serverEconomyAccount = NameManager.getOrCreateAccount(Properties.SERVER_ECONOMY_ACCOUNT_UUID, Properties.SERVER_ECONOMY_ACCOUNT);
            }
            if (serverEconomyAccount == null || serverEconomyAccount.getUuid() == null) {
                serverEconomyAccount = null;
                if (!Properties.SERVER_ECONOMY_ACCOUNT.isEmpty()) {
                    ChestShop.getBukkitLogger().log(Level.WARNING, "Server economy account setting '" + Properties.SERVER_ECONOMY_ACCOUNT + "' doesn't seem to be the name of a known player account! Please specify the SERVER_ECONOMY_ACCOUNT_UUID or log in at least once and create a player shop with that account in order for the server economy account to work.");
                }
            }
        }
        catch (SQLException e) {
            ChestShop.getBukkitLogger().log(Level.SEVERE, "Error while trying to setup accounts", e);
        }
    }

    public static Account getServerEconomyAccount() {
        return serverEconomyAccount;
    }

    public static void setUuidVersion(int uuidVersion) {
        NameManager.uuidVersion = uuidVersion;
    }

    public static int getUuidVersion() {
        return uuidVersion;
    }

    static {
        usernameToAccount = new SimpleCache(Properties.CACHE_SIZE);
        uuidToAccount = new SimpleCache(Properties.CACHE_SIZE);
        shortToAccount = new SimpleCache(Properties.CACHE_SIZE);
        invalidPlayers = new SimpleCache(Properties.CACHE_SIZE);
        uuidVersion = -1;
    }
}

