/*
 * Decompiled with CFR 0.152.
 */
package com.Acrobot.ChestShop.Signs;

import com.Acrobot.Breeze.Utils.BlockUtil;
import com.Acrobot.Breeze.Utils.ImplementationAdapter;
import com.Acrobot.Breeze.Utils.MaterialUtil;
import com.Acrobot.Breeze.Utils.QuantityUtil;
import com.Acrobot.Breeze.Utils.StringUtil;
import com.Acrobot.ChestShop.ChestShop;
import com.Acrobot.ChestShop.Configuration.Properties;
import com.Acrobot.ChestShop.Containers.AdminInventory;
import com.Acrobot.ChestShop.Database.Account;
import com.Acrobot.ChestShop.Events.AccountQueryEvent;
import com.Acrobot.ChestShop.Events.SignValidationEvent;
import com.Acrobot.ChestShop.Permission;
import com.Acrobot.ChestShop.UUIDs.NameManager;
import com.Acrobot.ChestShop.Utils.uBlock;
import java.util.Locale;
import java.util.Optional;
import java.util.regex.Pattern;
import org.bukkit.Bukkit;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.block.Chest;
import org.bukkit.block.DoubleChest;
import org.bukkit.block.Sign;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;

public class ChestShopSign {
    public static final byte NAME_LINE = 0;
    public static final byte QUANTITY_LINE = 1;
    public static final byte PRICE_LINE = 2;
    public static final byte ITEM_LINE = 3;
    public static final Pattern[][] SHOP_SIGN_PATTERN = new Pattern[][]{{Pattern.compile("^[1-9][0-9]{0,5}$"), QuantityUtil.QUANTITY_LINE_WITH_COUNTER_PATTERN}, {Pattern.compile("(?i)^((\\d*([.e]\\d+)?)([KM])?|free)$"), Pattern.compile("(?i)^([BS] *((\\d+([.e]\\d+)?([KM])?)|free))( *: *([BS] *((\\d+([.e]\\d+)?([KM])?)|free)))?$"), Pattern.compile("(?i)^(((\\d+([.e]\\d+)?([KM] )?)|free) *[BS])( *: *([BS] *((\\d+([.e]\\d+)?([KM])?)|free)))?$"), Pattern.compile("(?i)^(((\\d+([.e]\\d+)?([KM] )?)|free) *[BS]) *: *(((\\d+([.e]\\d+)?([KM] )?)|free) *[BS])$"), Pattern.compile("(?i)^([BS] *((\\d+([.e]\\d+)?([KM])?)|free)) *: *(((\\d+([.e]\\d+)?([KM] )?)|free) *[BS])$")}, {Pattern.compile("^\\?$"), Pattern.compile("^[\\p{L}\\d_ \\-]+(" + MaterialUtil.DURABILITY.pattern() + ")?(" + MaterialUtil.METADATA.pattern() + ")?$"), Pattern.compile("^[\\p{L}\\d_ \\-]+" + MaterialUtil.METADATA.pattern() + "(" + MaterialUtil.DURABILITY.pattern() + ")?$")}};
    public static final String AUTOFILL_CODE = "?";

    public static boolean isAdminShop(Inventory ownerInventory) {
        return ownerInventory instanceof AdminInventory;
    }

    public static boolean isAdminShop(String owner) {
        return owner.replace(" ", "").equalsIgnoreCase(Properties.ADMIN_SHOP_NAME.replace(" ", ""));
    }

    public static boolean isAdminShop(Sign sign) {
        return ChestShopSign.isAdminShop(sign.getLines());
    }

    public static boolean isAdminShop(String[] lines) {
        return ChestShopSign.isAdminShop(ChestShopSign.getOwner(lines));
    }

    public static boolean isValid(Sign sign) {
        return ChestShopSign.isValid(sign.getLines());
    }

    public static boolean isValid(String[] lines) {
        return ChestShop.callEvent(new SignValidationEvent(lines = StringUtil.stripColourCodes(lines))).isValid() && (ChestShopSign.getPrice(lines).toUpperCase(Locale.ROOT).contains("B") || ChestShopSign.getPrice(lines).toUpperCase(Locale.ROOT).contains("S")) && !ChestShopSign.getOwner(lines).isEmpty();
    }

    public static boolean isValid(Block sign) {
        return BlockUtil.isSign(sign) && ChestShopSign.isValid((Sign)ImplementationAdapter.getState(sign, false));
    }

    @Deprecated
    public static boolean isShopChest(Block chest) {
        if (!BlockUtil.isChest(chest)) {
            return false;
        }
        return uBlock.getConnectedSign(chest) != null;
    }

    public static boolean isShopBlock(Block block) {
        if (!uBlock.couldBeShopContainer(block)) {
            return false;
        }
        return uBlock.getConnectedSign(block) != null;
    }

    @Deprecated
    public static boolean isShopChest(InventoryHolder holder) {
        if (!BlockUtil.isChest(holder)) {
            return false;
        }
        if (holder instanceof DoubleChest) {
            return ChestShopSign.isShopChest(((DoubleChest)holder).getLocation().getBlock());
        }
        if (holder instanceof Chest) {
            return ChestShopSign.isShopChest(((Chest)holder).getBlock());
        }
        return false;
    }

    public static boolean isShopBlock(InventoryHolder holder) {
        if (holder instanceof DoubleChest) {
            return ChestShopSign.isShopBlock(ImplementationAdapter.getLeftSide((DoubleChest)holder, false)) || ChestShopSign.isShopBlock(ImplementationAdapter.getRightSide((DoubleChest)holder, false));
        }
        if (holder instanceof BlockState) {
            return ChestShopSign.isShopBlock(((BlockState)holder).getBlock());
        }
        return false;
    }

    public static Block getShopBlock(InventoryHolder holder) {
        if (holder instanceof DoubleChest) {
            return Optional.ofNullable(ChestShopSign.getShopBlock(ImplementationAdapter.getLeftSide((DoubleChest)holder, false))).orElse(ChestShopSign.getShopBlock(ImplementationAdapter.getRightSide((DoubleChest)holder, false)));
        }
        if (holder instanceof BlockState) {
            return ((BlockState)holder).getBlock();
        }
        return null;
    }

    public static boolean canAccess(Player player, Sign sign) {
        return ChestShopSign.hasPermission(player, Permission.OTHER_NAME_ACCESS, sign);
    }

    public static boolean hasPermission(Player player, Permission base, Sign sign) {
        if (player == null) {
            return false;
        }
        if (sign == null) {
            return true;
        }
        String name = ChestShopSign.getOwner(sign);
        if (name == null || name.isEmpty()) {
            return true;
        }
        return NameManager.canUseName(player, base, name);
    }

    public static boolean isOwner(Player player, Sign sign) {
        if (player == null || sign == null) {
            return false;
        }
        String name = ChestShopSign.getOwner(sign);
        if (name == null || name.isEmpty()) {
            return false;
        }
        AccountQueryEvent accountQueryEvent = new AccountQueryEvent(name);
        Bukkit.getPluginManager().callEvent((Event)accountQueryEvent);
        Account account = accountQueryEvent.getAccount();
        if (account == null) {
            return player.getName().equalsIgnoreCase(name);
        }
        return account.getUuid().equals(player.getUniqueId());
    }

    @Deprecated
    public static boolean isValidPreparedSign(String[] lines) {
        return ChestShop.callEvent(new SignValidationEvent(lines)).isValid();
    }

    public static String getOwner(Sign sign) {
        return ChestShopSign.getOwner(sign.getLines());
    }

    public static String getOwner(String[] lines) {
        return StringUtil.stripColourCodes(StringUtil.strip(StringUtil.stripColourCodes(lines[0])));
    }

    public static String getQuantityLine(Sign sign) throws IllegalArgumentException {
        return ChestShopSign.getQuantityLine(sign.getLines());
    }

    public static String getQuantityLine(String[] lines) throws IllegalArgumentException {
        return lines.length > 1 ? StringUtil.strip(StringUtil.stripColourCodes(lines[1])) : "";
    }

    public static int getQuantity(Sign sign) throws IllegalArgumentException {
        return ChestShopSign.getQuantity(sign.getLines());
    }

    public static int getQuantity(String[] lines) throws IllegalArgumentException {
        return QuantityUtil.parseQuantity(ChestShopSign.getQuantityLine(lines));
    }

    public static String getPrice(Sign sign) {
        return StringUtil.strip(StringUtil.stripColourCodes(sign.getLine(2)));
    }

    public static String getPrice(String[] lines) {
        return lines.length > 2 ? StringUtil.strip(StringUtil.stripColourCodes(lines[2])) : "";
    }

    public static String getItem(Sign sign) {
        return ChestShopSign.getItem(sign.getLines());
    }

    public static String getItem(String[] lines) {
        return lines.length > 3 ? StringUtil.strip(StringUtil.stripColourCodes(lines[3])) : "";
    }
}

