/*
 * Decompiled with CFR 0.152.
 */
package com.Acrobot.ChestShop;

import com.Acrobot.Breeze.Utils.BlockUtil;
import com.Acrobot.Breeze.Utils.ImplementationAdapter;
import com.Acrobot.ChestShop.ChestShop;
import com.Acrobot.ChestShop.Configuration.Properties;
import com.Acrobot.ChestShop.Events.Protection.ProtectBlockEvent;
import com.Acrobot.ChestShop.Events.Protection.ProtectionCheckEvent;
import com.Acrobot.ChestShop.Signs.ChestShopSign;
import com.Acrobot.ChestShop.Utils.uBlock;
import java.util.UUID;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.Sign;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;

public class Security {
    private static final BlockFace[] SIGN_CONNECTION_FACES = new BlockFace[]{BlockFace.UP, BlockFace.EAST, BlockFace.WEST, BlockFace.NORTH, BlockFace.SOUTH};
    private static final BlockFace[] BLOCKS_AROUND = new BlockFace[]{BlockFace.UP, BlockFace.DOWN, BlockFace.EAST, BlockFace.WEST, BlockFace.NORTH, BlockFace.SOUTH};

    public static boolean protect(Player player, Block block) {
        return Security.protect(player, block, player.getUniqueId());
    }

    public static boolean protect(Player player, Block block, UUID protectionOwner) {
        return Security.protect(player, block, protectionOwner, Type.PRIVATE);
    }

    public static boolean protect(Player player, Block block, UUID protectionOwner, Type type) {
        ProtectBlockEvent event = ChestShop.callEvent(new ProtectBlockEvent(block, player, protectionOwner, type));
        return event.isProtected();
    }

    public static boolean canAccess(Player player, Block block) {
        return Security.canAccess(player, block, false);
    }

    public static boolean canAccess(Player player, Block block, boolean ignoreDefaultProtection) {
        ProtectionCheckEvent event = ChestShop.callEvent(new ProtectionCheckEvent(block, player, ignoreDefaultProtection));
        return event.getResult() != Event.Result.DENY;
    }

    public static boolean canView(Player player, Block block, boolean ignoreDefaultProtection) {
        ProtectionCheckEvent event = ChestShop.callEvent(new ProtectionCheckEvent(block, player, ignoreDefaultProtection, false));
        return event.getResult() != Event.Result.DENY;
    }

    public static boolean canPlaceSign(Player player, Sign sign) {
        Block baseBlock = BlockUtil.getAttachedBlock(sign);
        if (!Properties.ALLOW_MULTIPLE_SHOPS_AT_ONE_BLOCK && Security.anotherShopFound(baseBlock, sign.getBlock(), player)) {
            return false;
        }
        return Security.canBePlaced(player, sign.getBlock());
    }

    private static boolean canBePlaced(Player player, Block sign) {
        for (BlockFace face : BLOCKS_AROUND) {
            Block block = sign.getRelative(face);
            if (!uBlock.couldBeShopContainer(block) || Security.canAccess(player, block)) continue;
            return false;
        }
        return true;
    }

    private static boolean anotherShopFound(Block baseBlock, Block signBlock, Player player) {
        for (BlockFace face : SIGN_CONNECTION_FACES) {
            Sign sign;
            Block block = baseBlock.getRelative(face);
            if (block.equals((Object)signBlock) || !BlockUtil.isSign(block) || !ChestShopSign.isValid(sign = (Sign)ImplementationAdapter.getState(block, false)) || !BlockUtil.getAttachedBlock(sign).equals((Object)baseBlock) || ChestShopSign.isOwner(player, sign)) continue;
            return true;
        }
        return false;
    }

    public static enum Type {
        PUBLIC,
        PRIVATE,
        DONATION,
        DISPLAY;

    }
}

