/*
 * Decompiled with CFR 0.152.
 */
package com.Acrobot.ChestShop.Plugins;

import com.Acrobot.Breeze.Utils.BlockUtil;
import com.Acrobot.ChestShop.Events.Protection.ProtectionCheckEvent;
import com.sk89q.worldedit.bukkit.BukkitAdapter;
import com.sk89q.worldedit.extension.platform.Actor;
import com.sk89q.worldedit.world.World;
import com.sk89q.worldguard.LocalPlayer;
import com.sk89q.worldguard.WorldGuard;
import com.sk89q.worldguard.bukkit.BukkitWorldConfiguration;
import com.sk89q.worldguard.bukkit.WorldGuardPlugin;
import com.sk89q.worldguard.internal.permission.RegionPermissionModel;
import com.sk89q.worldguard.internal.platform.WorldGuardPlatform;
import com.sk89q.worldguard.protection.ApplicableRegionSet;
import com.sk89q.worldguard.protection.association.RegionAssociable;
import com.sk89q.worldguard.protection.flags.Flags;
import com.sk89q.worldguard.protection.flags.StateFlag;
import com.sk89q.worldguard.protection.managers.RegionManager;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;

public class WorldGuardProtection
implements Listener {
    private WorldGuardPlugin worldGuard;
    private WorldGuardPlatform worldGuardPlatform;

    public WorldGuardProtection(Plugin plugin) {
        this.worldGuard = (WorldGuardPlugin)plugin;
        this.worldGuardPlatform = WorldGuard.getInstance().getPlatform();
    }

    @EventHandler
    public void onProtectionCheck(ProtectionCheckEvent event) {
        com.sk89q.worldedit.util.Location location;
        if (event.getResult() == Event.Result.DENY) {
            return;
        }
        Block block = event.getBlock();
        Player player = event.getPlayer();
        LocalPlayer localPlayer = this.worldGuard.wrapPlayer(player);
        if (!this.canAccess(localPlayer, block, location = BukkitAdapter.adapt((Location)block.getLocation()))) {
            event.setResult(Event.Result.DENY);
            return;
        }
        RegionManager manager = this.worldGuardPlatform.getRegionContainer().get((World)location.getExtent());
        if (manager == null) {
            return;
        }
        ApplicableRegionSet set = manager.getApplicableRegions(location.toVector().toBlockPoint());
        StateFlag flag = Flags.CHEST_ACCESS;
        if (BlockUtil.isSign(block)) {
            flag = Flags.USE;
        }
        if (!this.canAccess(localPlayer, (World)location.getExtent(), set, flag)) {
            event.setResult(Event.Result.DENY);
        }
    }

    private boolean canAccess(LocalPlayer player, Block block, com.sk89q.worldedit.util.Location location) {
        BukkitWorldConfiguration wcfg = (BukkitWorldConfiguration)this.worldGuardPlatform.getGlobalStateManager().get((World)location.getExtent());
        return !wcfg.signChestProtection || !wcfg.getChestProtection().isChest(BukkitAdapter.asBlockType((Material)block.getType())) || !wcfg.getChestProtection().isProtected(location, player);
    }

    private boolean canAccess(LocalPlayer player, World world, ApplicableRegionSet set, StateFlag flag) {
        return new RegionPermissionModel((Actor)player).mayIgnoreRegionProtection(world) || set.testState((RegionAssociable)player, new StateFlag[]{Flags.BUILD}) || set.testState((RegionAssociable)player, new StateFlag[]{flag});
    }
}

