/*
 * Decompiled with CFR 0.152.
 */
package com.Acrobot.ChestShop.Plugins;

import com.Acrobot.ChestShop.ChestShop;
import com.Acrobot.ChestShop.Configuration.Messages;
import com.Acrobot.ChestShop.Configuration.Properties;
import com.Acrobot.ChestShop.Events.PreShopCreationEvent;
import com.Acrobot.ChestShop.Events.Protection.ProtectBlockEvent;
import com.Acrobot.ChestShop.Events.Protection.ProtectionCheckEvent;
import com.Acrobot.ChestShop.Events.ShopCreatedEvent;
import com.Acrobot.ChestShop.Events.ShopDestroyedEvent;
import com.Acrobot.ChestShop.Security;
import com.Acrobot.ChestShop.Utils.uBlock;
import com.griefcraft.cache.BlockCache;
import com.griefcraft.lwc.LWC;
import com.griefcraft.model.Protection;
import com.griefcraft.modules.limits.LimitsModule;
import com.griefcraft.modules.limits.LimitsV2;
import com.griefcraft.scripting.event.LWCEvent;
import com.griefcraft.scripting.event.LWCProtectionRegisterEvent;
import com.griefcraft.scripting.event.LWCProtectionRegistrationPostEvent;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.block.Container;
import org.bukkit.block.Sign;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;

public class LightweightChestProtection
implements Listener {
    private final LWC lwc = LWC.getInstance();
    private final LimitsModule limitsModule = (LimitsModule)this.lwc.getModuleLoader().getModule(LimitsModule.class);
    private final LimitsV2 limitsV2 = (LimitsV2)this.lwc.getModuleLoader().getModule(LimitsV2.class);

    public LightweightChestProtection() {
        try {
            if (Properties.PROTECT_SIGN_WITH_LWC) {
                Protection.Type.valueOf((String)Properties.LWC_SIGN_PROTECTION_TYPE.name());
            }
            if (Properties.PROTECT_CHEST_WITH_LWC) {
                Protection.Type.valueOf((String)Properties.LWC_CHEST_PROTECTION_TYPE.name());
            }
        }
        catch (IllegalArgumentException e) {
            ChestShop.getBukkitLogger().warning("Your installed LWC version doesn't seem to support the configured protection type! " + e.getMessage());
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onPreShopCreation(PreShopCreationEvent event) {
        if (Properties.LWC_LIMITS_BLOCK_CREATION) {
            Container container;
            if (Properties.PROTECT_SIGN_WITH_LWC && this.isAtLimit(event.getPlayer(), (BlockState)event.getSign())) {
                event.setOutcome(PreShopCreationEvent.CreationOutcome.OTHER_BREAK);
                return;
            }
            if (Properties.PROTECT_CHEST_WITH_LWC && (container = uBlock.findConnectedContainer(event.getSign())) != null && this.isAtLimit(event.getPlayer(), (BlockState)container)) {
                event.setOutcome(PreShopCreationEvent.CreationOutcome.OTHER_BREAK);
                return;
            }
        }
    }

    private boolean isAtLimit(Player player, BlockState blockState) {
        LWCProtectionRegisterEvent protectionEvent = new LWCProtectionRegisterEvent(player, blockState.getBlock());
        this.limitsModule.onRegisterProtection(protectionEvent);
        this.limitsV2.onRegisterProtection(protectionEvent);
        return protectionEvent.isCancelled();
    }

    @EventHandler
    public static void onShopCreation(ShopCreatedEvent event) {
        Player player = event.getPlayer();
        Sign sign = event.getSign();
        Container connectedContainer = event.getContainer();
        Messages.Message message = null;
        if (Properties.PROTECT_SIGN_WITH_LWC) {
            message = Security.protect(player, sign.getBlock(), event.getOwnerAccount() != null ? event.getOwnerAccount().getUuid() : player.getUniqueId(), Properties.LWC_SIGN_PROTECTION_TYPE) ? Messages.PROTECTED_SHOP_SIGN : Messages.NOT_ENOUGH_PROTECTIONS;
        }
        if (Properties.PROTECT_CHEST_WITH_LWC && connectedContainer != null) {
            if (Security.protect(player, connectedContainer.getBlock(), event.getOwnerAccount() != null ? event.getOwnerAccount().getUuid() : player.getUniqueId(), Properties.LWC_CHEST_PROTECTION_TYPE)) {
                message = Messages.PROTECTED_SHOP;
            } else if (message == null) {
                message = Messages.NOT_ENOUGH_PROTECTIONS;
            }
        }
        if (message != null) {
            message.sendWithPrefix((CommandSender)player, new String[0]);
        }
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onProtectionCheck(ProtectionCheckEvent event) {
        if (event.getResult() == Event.Result.DENY && !Properties.TURN_OFF_DEFAULT_PROTECTION_WHEN_PROTECTED_EXTERNALLY) {
            return;
        }
        Block block = event.getBlock();
        Player player = event.getPlayer();
        Protection protection = this.lwc.findProtection(block);
        if (protection == null) {
            return;
        }
        if (event.checkCanManage() ? !this.lwc.canAdminProtection(player, protection) : !this.lwc.canAccessProtection(player, protection)) {
            event.setResult(Event.Result.DENY);
        } else if (Properties.TURN_OFF_DEFAULT_PROTECTION_WHEN_PROTECTED_EXTERNALLY) {
            event.setResult(Event.Result.ALLOW);
        }
    }

    @EventHandler
    public void onBlockProtect(ProtectBlockEvent event) {
        Protection.Type type;
        if (event.isProtected()) {
            return;
        }
        Block block = event.getBlock();
        Player player = event.getPlayer();
        if (player == null) {
            return;
        }
        int x = block.getX();
        int y = block.getY();
        int z = block.getZ();
        String worldName = block.getWorld().getName();
        Protection existingProtection = this.lwc.getPhysicalDatabase().loadProtection(worldName, x, y, z);
        if (existingProtection != null) {
            event.setProtected(true);
            return;
        }
        LWCProtectionRegisterEvent protectionEvent = new LWCProtectionRegisterEvent(player, block);
        this.lwc.getModuleLoader().dispatchEvent((LWCEvent)protectionEvent);
        if (protectionEvent.isCancelled()) {
            return;
        }
        switch (event.getType()) {
            case PRIVATE: {
                type = Protection.Type.PRIVATE;
                break;
            }
            case PUBLIC: {
                type = Protection.Type.PUBLIC;
                break;
            }
            case DONATION: {
                type = Protection.Type.DONATION;
                break;
            }
            case DISPLAY: {
                try {
                    type = Protection.Type.valueOf((String)"DISPLAY");
                    break;
                }
                catch (IllegalArgumentException e) {
                    return;
                }
            }
            default: {
                return;
            }
        }
        Protection protection = null;
        try {
            int blockId = BlockCache.getInstance().getBlockId(block);
            if (blockId < 0) {
                return;
            }
            protection = this.lwc.getPhysicalDatabase().registerProtection(blockId, type, worldName, event.getProtectionOwner().toString(), "", x, y, z);
        }
        catch (LinkageError e) {
            ChestShop.getBukkitLogger().warning("Incompatible LWC version installed! (" + this.lwc.getPlugin().getName() + " v" + this.lwc.getVersion() + ") \nBlock cache/type id error: " + e.getMessage());
        }
        if (protection != null) {
            event.setProtected(true);
            protection.removeCache();
            this.lwc.getProtectionCache().addProtection(protection);
            this.lwc.getModuleLoader().dispatchEvent((LWCEvent)new LWCProtectionRegistrationPostEvent(protection));
        }
    }

    @EventHandler
    public void onShopRemove(ShopDestroyedEvent event) {
        Protection signProtection = this.lwc.findProtection(event.getSign().getBlock());
        if (signProtection != null) {
            signProtection.remove();
        }
        if (event.getContainer() == null || !Properties.REMOVE_LWC_PROTECTION_AUTOMATICALLY) {
            return;
        }
        Protection chestProtection = this.lwc.findProtection(event.getContainer().getBlock());
        if (chestProtection != null) {
            chestProtection.remove();
        }
    }
}

