/*
 * Decompiled with CFR 0.152.
 */
package com.Acrobot.ChestShop.Metadata;

import com.Acrobot.Breeze.Utils.Encoding.Base62;
import com.Acrobot.Breeze.Utils.Encoding.Base64;
import com.Acrobot.ChestShop.ChestShop;
import com.Acrobot.ChestShop.Database.DaoCreator;
import com.Acrobot.ChestShop.Database.Item;
import com.Acrobot.ChestShop.Libs.ORMlite.dao.CloseableIterator;
import com.Acrobot.ChestShop.Libs.ORMlite.dao.Dao;
import com.Acrobot.ChestShop.Libs.ORMlite.stmt.SelectArg;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.sql.SQLException;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import org.bukkit.Material;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.configuration.file.YamlConstructor;
import org.bukkit.configuration.file.YamlRepresenter;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.Damageable;
import org.bukkit.inventory.meta.ItemMeta;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.BaseConstructor;
import org.yaml.snakeyaml.constructor.Construct;
import org.yaml.snakeyaml.error.YAMLException;
import org.yaml.snakeyaml.nodes.Tag;
import org.yaml.snakeyaml.representer.Representer;

public class ItemDatabase {
    private Dao<Item, Integer> itemDao;
    private final Yaml yaml = new Yaml((BaseConstructor)new YamlBukkitConstructor(), (Representer)new YamlRepresenter(), new DumperOptions());

    public ItemDatabase() {
        try {
            this.itemDao = DaoCreator.getDaoAndCreateTable(Item.class);
            this.handleMetadataUpdate();
        }
        catch (SQLException e) {
            ChestShop.getBukkitLogger().log(Level.SEVERE, "Error while loading items database", e);
        }
    }

    private void handleMetadataUpdate() {
        int newVersion;
        File configFile = ChestShop.loadFile("version");
        YamlConfiguration versionConfig = YamlConfiguration.loadConfiguration((File)configFile);
        int previousVersion = versionConfig.getInt("metadata-version", -1);
        if (previousVersion < (newVersion = this.getCurrentMetadataVersion())) {
            if (this.updateMetadataVersion(previousVersion, newVersion)) {
                versionConfig.set("metadata-version", (Object)newVersion);
                try {
                    versionConfig.save(configFile);
                }
                catch (IOException e) {
                    ChestShop.getBukkitLogger().log(Level.SEVERE, "Error while updating metadata-version from " + previousVersion + " to " + newVersion, e);
                }
            } else {
                ChestShop.getBukkitLogger().log(Level.WARNING, "Error while updating Item Metadata database! While the plugin will still run it will work less efficiently.");
            }
        }
    }

    private int getCurrentMetadataVersion() {
        ItemStack item = new ItemStack(Material.STONE);
        ItemMeta meta = item.getItemMeta();
        if (meta != null) {
            meta.setDisplayName("GetCurrentMetadataVersion");
            item.setItemMeta(meta);
        }
        Map serialized = item.serialize();
        return serialized.getOrDefault("v", -1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean updateMetadataVersion(int previousVersion, int newVersion) {
        if (previousVersion > -1) {
            ChestShop.getBukkitLogger().info("Data version change detected! Previous version was " + previousVersion);
        }
        ChestShop.getBukkitLogger().info("Updating Item Metadata database to data version " + newVersion + "...");
        AtomicInteger i = new AtomicInteger();
        AtomicInteger updated = new AtomicInteger();
        CloseableIterator<Item> it = this.itemDao.iterator();
        long start = System.currentTimeMillis();
        try {
            this.itemDao.callBatchTasks(() -> {
                while (it.hasNext()) {
                    i.getAndIncrement();
                    Item item = (Item)it.next();
                    try {
                        String serialized = (String)Base64.decodeToObject(item.getBase64ItemCode());
                        if (previousVersion < 0 || !serialized.contains("\nv: " + newVersion + "\n")) {
                            try {
                                ItemStack itemStack = (ItemStack)this.yaml.loadAs(serialized, ItemStack.class);
                                item.setBase64ItemCode(Base64.encodeObject((Serializable)((Object)this.yaml.dump((Object)itemStack))));
                                this.itemDao.update(item);
                                updated.getAndIncrement();
                            }
                            catch (RuntimeException e) {
                                ChestShop.getBukkitLogger().log(Level.SEVERE, "YAML of the item with ID " + Base62.encode(item.getId()) + " (" + item.getId() + ") is corrupted: \n" + serialized + "\n" + e.getMessage());
                            }
                        }
                    }
                    catch (IOException | ClassNotFoundException | SQLException e) {
                        ChestShop.getBukkitLogger().log(Level.SEVERE, "Unable to convert item with ID " + Base62.encode(item.getId()) + " (" + item.getId() + ")", e);
                    }
                    catch (StackOverflowError e) {
                        ChestShop.getBukkitLogger().log(Level.SEVERE, "Item with ID " + Base62.encode(item.getId()) + " (" + item.getId() + ") is corrupted. Sorry :(");
                    }
                    if (i.get() % 1000 != 0) continue;
                    ChestShop.getBukkitLogger().info("Checked " + i + " items. Updated " + updated + "...");
                }
                return true;
            });
        }
        catch (Exception e) {
            ChestShop.getBukkitLogger().log(Level.SEVERE, "Unable to update metadata version of all items from " + previousVersion + " to " + newVersion, e);
            boolean bl = false;
            return bl;
        }
        finally {
            it.closeQuietly();
        }
        ChestShop.getBukkitLogger().info("Finished updating database in " + (double)(System.currentTimeMillis() - start) / 1000.0 + "s. " + updated + " items out of " + i + " were updated!");
        return true;
    }

    public String getItemCode(ItemStack item) {
        try {
            String dumped;
            ItemStack loadedItem;
            Damageable damageable;
            ItemStack clone = new ItemStack(item);
            clone.setAmount(1);
            ItemMeta meta = clone.getItemMeta();
            if (meta instanceof Damageable && (damageable = (Damageable)clone.getItemMeta()).hasDamage()) {
                damageable.setDamage(0);
            }
            if (!(loadedItem = (ItemStack)this.yaml.loadAs(dumped = this.yaml.dump((Object)clone), ItemStack.class)).isSimilar(item)) {
                dumped = this.yaml.dump((Object)loadedItem);
            }
            String code = Base64.encodeObject((Serializable)((Object)dumped));
            Item itemEntity = (Item)this.itemDao.queryBuilder().where().eq("code", new SelectArg((Object)code)).queryForFirst();
            if (itemEntity == null) {
                itemEntity = new Item(code);
                this.itemDao.create(itemEntity);
            }
            return Base62.encode(itemEntity.getId());
        }
        catch (IOException | SQLException e) {
            ChestShop.getBukkitLogger().log(Level.SEVERE, "Unable to get code of item " + item, e);
            return null;
        }
    }

    public ItemStack getFromCode(String code) {
        int id = Base62.decode(code);
        try {
            Item item = (Item)this.itemDao.queryBuilder().where().eq("id", new SelectArg(id)).queryForFirst();
            if (item == null) {
                return null;
            }
            String serialized = item.getBase64ItemCode();
            try {
                return (ItemStack)this.yaml.loadAs((String)Base64.decodeToObject(serialized), ItemStack.class);
            }
            catch (YAMLException e) {
                ChestShop.getBukkitLogger().log(Level.SEVERE, "YAML of the item with ID " + Base62.encode(item.getId()) + " (" + item.getId() + ") is corrupted: \n" + serialized);
            }
        }
        catch (IOException | ClassNotFoundException | SQLException | YAMLException e) {
            ChestShop.getBukkitLogger().log(Level.SEVERE, "Unable to load item with ID " + code + " (" + id + ")", e);
        }
        catch (StackOverflowError e) {
            ChestShop.getBukkitLogger().log(Level.SEVERE, "Item with ID " + code + " (" + id + ") is corrupted. Sorry :(");
        }
        return null;
    }

    private static class YamlBukkitConstructor
    extends YamlConstructor {
        public YamlBukkitConstructor() {
            this.yamlConstructors.put(new Tag("tag:yaml.org,2002:org.bukkit.inventory.ItemStack"), (Construct)this.yamlConstructors.get(Tag.MAP));
        }
    }
}

