/*
 * Decompiled with CFR 0.152.
 */
package com.Acrobot.ChestShop.Listeners;

import com.Acrobot.Breeze.Utils.MaterialUtil;
import com.Acrobot.Breeze.Utils.StringUtil;
import com.Acrobot.ChestShop.Configuration.Properties;
import com.Acrobot.ChestShop.Events.ItemParseEvent;
import com.Acrobot.ChestShop.Events.MaterialParseEvent;
import com.Acrobot.ChestShop.Events.SignValidationEvent;
import com.Acrobot.ChestShop.Signs.ChestShopSign;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;

public class SignParseListener
implements Listener {
    @EventHandler(priority=EventPriority.NORMAL)
    public static void onItemParse(ItemParseEvent event) {
        if (event.getItem() == null) {
            event.setItem(MaterialUtil.getItem(event.getItemString()));
        }
    }

    @EventHandler(priority=EventPriority.NORMAL)
    public static void onMaterialParse(MaterialParseEvent event) {
        if (event.getMaterial() == null) {
            event.setMaterial(MaterialUtil.getMaterial(event.getMaterialString()));
        }
    }

    @EventHandler
    public void onSignValidation(SignValidationEvent event) {
        String ownerName = event.getOwner();
        String[] lines = event.getLines();
        if (!ChestShopSign.isAdminShop(ownerName) && !ownerName.isEmpty()) {
            Pattern playernamePattern = Pattern.compile(Properties.VALID_PLAYERNAME_REGEXP);
            Matcher playernameWithIdMatcher = Pattern.compile("^(.+):[A-Za-z0-9]+$").matcher(ownerName);
            if (playernameWithIdMatcher.matches()) {
                ownerName = playernameWithIdMatcher.group(1);
            }
            if (!playernamePattern.matcher(ownerName).matches()) {
                event.setValid(false);
                return;
            }
        }
        for (int i = 0; i < 3; ++i) {
            boolean matches = false;
            for (Pattern pattern : ChestShopSign.SHOP_SIGN_PATTERN[i]) {
                if (!pattern.matcher(StringUtil.strip(StringUtil.stripColourCodes(lines[i + 1]))).matches()) continue;
                matches = true;
                break;
            }
            if (matches) continue;
            event.setValid(false);
            return;
        }
        String priceLine = ChestShopSign.getPrice(lines);
        event.setValid(priceLine.indexOf(58) == priceLine.lastIndexOf(58));
    }
}

