/*
 * Decompiled with CFR 0.152.
 */
package com.Acrobot.ChestShop.Listeners;

import com.Acrobot.Breeze.Utils.InventoryUtil;
import com.Acrobot.Breeze.Utils.MaterialUtil;
import com.Acrobot.Breeze.Utils.PriceUtil;
import com.Acrobot.ChestShop.ChestShop;
import com.Acrobot.ChestShop.Configuration.Messages;
import com.Acrobot.ChestShop.Configuration.Properties;
import com.Acrobot.ChestShop.Events.AccountQueryEvent;
import com.Acrobot.ChestShop.Events.Economy.CurrencyFormatEvent;
import com.Acrobot.ChestShop.Events.ItemInfoEvent;
import com.Acrobot.ChestShop.Events.ItemParseEvent;
import com.Acrobot.ChestShop.Events.ShopInfoEvent;
import com.Acrobot.ChestShop.Signs.ChestShopSign;
import com.Acrobot.ChestShop.Utils.ItemUtil;
import com.Acrobot.ChestShop.Utils.uBlock;
import com.google.common.collect.ImmutableMap;
import java.math.BigDecimal;
import java.util.Map;
import org.bukkit.block.Container;
import org.bukkit.command.CommandSender;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.inventory.ItemStack;

public class ShopInfoListener
implements Listener {
    @EventHandler(ignoreCancelled=true)
    public static void showShopInfo(ShopInfoEvent event) {
        if (ChestShopSign.isValid(event.getSign())) {
            CurrencyFormatEvent cfe;
            int amount;
            String nameLine = ChestShopSign.getOwner(event.getSign());
            try {
                amount = ChestShopSign.getQuantity(event.getSign());
            }
            catch (NumberFormatException notANumber) {
                Messages.INVALID_SHOP_DETECTED.sendWithPrefix((CommandSender)event.getSender(), new String[0]);
                return;
            }
            String pricesLine = ChestShopSign.getPrice(event.getSign());
            AccountQueryEvent queryEvent = new AccountQueryEvent(nameLine);
            ChestShop.callEvent(queryEvent);
            if (queryEvent.getAccount() == null) {
                Messages.INVALID_SHOP_DETECTED.sendWithPrefix((CommandSender)event.getSender(), new String[0]);
                return;
            }
            String ownerName = queryEvent.getAccount().getName();
            ownerName = ownerName != null ? ownerName : nameLine;
            ItemParseEvent parseEvent = new ItemParseEvent(ChestShopSign.getItem(event.getSign()));
            ItemStack item = ChestShop.callEvent(parseEvent).getItem();
            if (item == null || amount < 1) {
                Messages.INVALID_SHOP_DETECTED.sendWithPrefix((CommandSender)event.getSender(), new String[0]);
                return;
            }
            Container shopBlock = uBlock.findConnectedContainer(event.getSign());
            String stock = shopBlock != null ? String.valueOf(InventoryUtil.getAmount(item, shopBlock.getInventory())) : "\u221e";
            ImmutableMap replacementMap = ImmutableMap.of((Object)"item", (Object)ItemUtil.getName(item), (Object)"stock", (Object)stock, (Object)"owner", (Object)ownerName, (Object)"prices", (Object)pricesLine, (Object)"quantity", (Object)String.valueOf(amount));
            if (!Properties.SHOWITEM_MESSAGE || !MaterialUtil.Show.sendMessage(event.getSender(), event.getSender().getName(), Messages.shopinfo, false, new ItemStack[]{item}, (Map<String, String>)replacementMap, new String[0])) {
                Messages.shopinfo.send((CommandSender)event.getSender(), (Map<String, String>)replacementMap);
            }
            BigDecimal buyPrice = PriceUtil.getExactBuyPrice(pricesLine);
            BigDecimal sellPrice = PriceUtil.getExactSellPrice(pricesLine);
            ItemInfoEvent itemInfoEvent = ChestShop.callEvent(new ItemInfoEvent((CommandSender)event.getSender(), item));
            for (Map.Entry<Messages.Message, String[]> entry : itemInfoEvent.getMessages()) {
                entry.getKey().send((CommandSender)event.getSender(), entry.getValue());
            }
            if (!buyPrice.equals(PriceUtil.NO_PRICE)) {
                cfe = ChestShop.callEvent(new CurrencyFormatEvent(buyPrice));
                Messages.shopinfo_buy.send((CommandSender)event.getSender(), "amount", String.valueOf(amount), "price", cfe.getFormattedAmount());
            }
            if (!sellPrice.equals(PriceUtil.NO_PRICE)) {
                cfe = ChestShop.callEvent(new CurrencyFormatEvent(sellPrice));
                Messages.shopinfo_sell.send((CommandSender)event.getSender(), "amount", String.valueOf(amount), "price", cfe.getFormattedAmount());
            }
        } else {
            Messages.INVALID_SHOP_DETECTED.sendWithPrefix((CommandSender)event.getSender(), new String[0]);
        }
    }
}

