/*
 * Decompiled with CFR 0.152.
 */
package com.Acrobot.ChestShop.Listeners.PreTransaction;

import com.Acrobot.Breeze.Utils.InventoryUtil;
import com.Acrobot.ChestShop.Events.PreTransactionEvent;
import com.Acrobot.ChestShop.Events.TransactionEvent;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;

public class StockFittingChecker
implements Listener {
    @EventHandler
    public static void onSellCheck(PreTransactionEvent event) {
        if (event.isCancelled() || event.getTransactionType() != TransactionEvent.TransactionType.SELL) {
            return;
        }
        Inventory shopInventory = event.getOwnerInventory();
        ItemStack[] stock = event.getStock();
        if (!InventoryUtil.fits(stock, shopInventory)) {
            event.setCancelled(PreTransactionEvent.TransactionOutcome.NOT_ENOUGH_SPACE_IN_CHEST);
        }
    }

    @EventHandler
    public static void onBuyCheck(PreTransactionEvent event) {
        if (event.isCancelled() || event.getTransactionType() != TransactionEvent.TransactionType.BUY) {
            return;
        }
        Inventory clientInventory = event.getClientInventory();
        ItemStack[] stock = event.getStock();
        if (!InventoryUtil.fits(stock, clientInventory)) {
            event.setCancelled(PreTransactionEvent.TransactionOutcome.NOT_ENOUGH_SPACE_IN_INVENTORY);
        }
    }
}

