/*
 * Decompiled with CFR 0.152.
 */
package com.Acrobot.ChestShop.Listeners.PreTransaction;

import com.Acrobot.ChestShop.Events.PreTransactionEvent;
import com.Acrobot.ChestShop.Events.TransactionEvent;
import com.Acrobot.ChestShop.Permission;
import com.Acrobot.ChestShop.Signs.ChestShopSign;
import java.util.Locale;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.inventory.ItemStack;

public class PermissionChecker
implements Listener {
    @EventHandler
    public static void onPermissionCheck(PreTransactionEvent event) {
        if (event.isCancelled()) {
            return;
        }
        Player client = event.getClient();
        TransactionEvent.TransactionType transactionType = event.getTransactionType();
        String itemLine = ChestShopSign.getItem(event.getSign());
        if (itemLine.contains("#") && Permission.hasPermissionSetFalse((CommandSender)client, (Object)((Object)(transactionType == TransactionEvent.TransactionType.BUY ? Permission.BUY_ID : Permission.SELL_ID)) + itemLine)) {
            event.setCancelled(PreTransactionEvent.TransactionOutcome.CLIENT_DOES_NOT_HAVE_PERMISSION);
            return;
        }
        for (ItemStack stock : event.getStock()) {
            boolean hasPerm;
            String matID = stock.getType().toString().toLowerCase(Locale.ROOT);
            if (transactionType == TransactionEvent.TransactionType.BUY) {
                hasPerm = Permission.has((CommandSender)client, Permission.BUY) || Permission.has((CommandSender)client, (Object)((Object)Permission.BUY_ID) + matID);
            } else {
                boolean bl = hasPerm = Permission.has((CommandSender)client, Permission.SELL) || Permission.has((CommandSender)client, (Object)((Object)Permission.SELL_ID) + matID);
            }
            if (hasPerm) continue;
            event.setCancelled(PreTransactionEvent.TransactionOutcome.CLIENT_DOES_NOT_HAVE_PERMISSION);
            return;
        }
    }
}

