/*
 * Decompiled with CFR 0.152.
 */
package com.Acrobot.ChestShop.Listeners.PreTransaction;

import com.Acrobot.Breeze.Utils.MaterialUtil;
import com.Acrobot.ChestShop.ChestShop;
import com.Acrobot.ChestShop.Commands.Toggle;
import com.Acrobot.ChestShop.Configuration.Messages;
import com.Acrobot.ChestShop.Configuration.Properties;
import com.Acrobot.ChestShop.Database.Account;
import com.Acrobot.ChestShop.Economy.Economy;
import com.Acrobot.ChestShop.Events.PreTransactionEvent;
import com.Acrobot.ChestShop.Utils.ItemUtil;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Table;
import java.util.Collections;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.inventory.ItemStack;

public class ErrorMessageSender
implements Listener {
    private static Table<UUID, String, Long> notificationCooldowns = HashBasedTable.create();

    @EventHandler(priority=EventPriority.MONITOR)
    public static void onQuit(PlayerQuitEvent event) {
        if (Properties.NOTIFICATION_MESSAGE_COOLDOWN > 0L) {
            notificationCooldowns.rowMap().remove(event.getPlayer().getUniqueId());
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public static void onMessage(PreTransactionEvent event) {
        if (!event.isCancelled()) {
            return;
        }
        Messages.Message message = null;
        switch (event.getTransactionOutcome()) {
            case SHOP_DOES_NOT_BUY_THIS_ITEM: {
                message = Messages.NO_SELLING_HERE;
                break;
            }
            case SHOP_DOES_NOT_SELL_THIS_ITEM: {
                message = Messages.NO_BUYING_HERE;
                break;
            }
            case CLIENT_DOES_NOT_HAVE_PERMISSION: {
                message = Messages.NO_PERMISSION;
                break;
            }
            case CLIENT_DOES_NOT_HAVE_ENOUGH_MONEY: {
                message = Messages.NOT_ENOUGH_MONEY;
                break;
            }
            case SHOP_DOES_NOT_HAVE_ENOUGH_MONEY: {
                message = Messages.NOT_ENOUGH_MONEY_SHOP;
                break;
            }
            case NOT_ENOUGH_SPACE_IN_CHEST: {
                if (Properties.SHOW_MESSAGE_FULL_SHOP && !Properties.CSTOGGLE_TOGGLES_FULL_SHOP || !Toggle.isIgnoring(event.getOwnerAccount().getUuid())) {
                    Location loc = event.getSign().getLocation();
                    ErrorMessageSender.sendMessageToOwner(event.getOwnerAccount(), Messages.NOT_ENOUGH_SPACE_IN_YOUR_SHOP, new String[]{"price", Economy.formatBalance(event.getExactPrice()), "seller", event.getClient().getName(), "world", loc.getWorld().getName(), "x", String.valueOf(loc.getBlockX()), "y", String.valueOf(loc.getBlockY()), "z", String.valueOf(loc.getBlockZ())}, event.getStock());
                }
                message = Messages.NOT_ENOUGH_SPACE_IN_CHEST;
                break;
            }
            case NOT_ENOUGH_SPACE_IN_INVENTORY: {
                message = Messages.NOT_ENOUGH_SPACE_IN_INVENTORY;
                break;
            }
            case NOT_ENOUGH_STOCK_IN_INVENTORY: {
                message = Messages.NOT_ENOUGH_ITEMS_TO_SELL;
                break;
            }
            case NOT_ENOUGH_STOCK_IN_CHEST: {
                if (Properties.SHOW_MESSAGE_OUT_OF_STOCK && !Properties.CSTOGGLE_TOGGLES_OUT_OF_STOCK || !Toggle.isIgnoring(event.getOwnerAccount().getUuid())) {
                    Location loc = event.getSign().getLocation();
                    ErrorMessageSender.sendMessageToOwner(event.getOwnerAccount(), Messages.NOT_ENOUGH_STOCK_IN_YOUR_SHOP, new String[]{"price", Economy.formatBalance(event.getExactPrice()), "buyer", event.getClient().getName(), "world", loc.getWorld().getName(), "x", String.valueOf(loc.getBlockX()), "y", String.valueOf(loc.getBlockY()), "z", String.valueOf(loc.getBlockZ())}, event.getStock());
                }
                message = Messages.NOT_ENOUGH_STOCK;
                break;
            }
            case CLIENT_DEPOSIT_FAILED: {
                message = Messages.CLIENT_DEPOSIT_FAILED;
                break;
            }
            case SHOP_DEPOSIT_FAILED: {
                ErrorMessageSender.sendMessageToOwner(event.getOwnerAccount(), Messages.CLIENT_DEPOSIT_FAILED, new String[0], new ItemStack[0]);
                message = Messages.SHOP_DEPOSIT_FAILED;
                break;
            }
            case SHOP_IS_RESTRICTED: {
                message = Messages.ACCESS_DENIED;
                break;
            }
            case INVALID_SHOP: {
                message = Messages.INVALID_SHOP_DETECTED;
                break;
            }
            case INVALID_CLIENT_NAME: {
                message = Messages.INVALID_CLIENT_NAME;
                break;
            }
            case CREATIVE_MODE_PROTECTION: {
                message = Messages.TRADE_DENIED_CREATIVE_MODE;
                break;
            }
        }
        if (message != null) {
            message.sendWithPrefix((CommandSender)event.getClient(), new String[0]);
        }
    }

    private static void sendMessageToOwner(Account ownerAccount, Messages.Message message, String[] replacements, ItemStack ... stock) {
        Player player = Bukkit.getPlayer((UUID)ownerAccount.getUuid());
        if (player != null || Properties.BUNGEECORD_MESSAGES) {
            String items;
            if (Properties.NOTIFICATION_MESSAGE_COOLDOWN > 0L) {
                String cacheKey = message.getKey() + "|" + String.join((CharSequence)",", replacements) + "|" + ItemUtil.getItemList(stock);
                Long last = (Long)notificationCooldowns.get((Object)ownerAccount.getUuid(), (Object)cacheKey);
                if (last != null && last + Properties.NOTIFICATION_MESSAGE_COOLDOWN * 1000L > System.currentTimeMillis()) {
                    return;
                }
                notificationCooldowns.put((Object)ownerAccount.getUuid(), (Object)cacheKey, (Object)System.currentTimeMillis());
            }
            if (player != null) {
                if (Properties.SHOWITEM_MESSAGE && MaterialUtil.Show.sendMessage(player, message, stock, Collections.emptyMap(), replacements)) {
                    return;
                }
                items = ItemUtil.getItemList(stock);
                message.sendWithPrefix((CommandSender)player, (Map<String, String>)ImmutableMap.of((Object)"material", (Object)items, (Object)"item", (Object)items), replacements);
            } else {
                items = ItemUtil.getItemList(stock);
                ChestShop.sendBungeeMessage(ownerAccount.getName(), message, (Map<String, String>)ImmutableMap.of((Object)"material", (Object)items, (Object)"item", (Object)items), replacements);
            }
        }
    }
}

