/*
 * Decompiled with CFR 0.152.
 */
package com.Acrobot.ChestShop.Listeners.PreShopCreation;

import com.Acrobot.Breeze.Utils.PriceUtil;
import com.Acrobot.ChestShop.Events.PreShopCreationEvent;
import com.Acrobot.ChestShop.Signs.ChestShopSign;
import java.math.BigDecimal;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;

public class PriceRatioChecker
implements Listener {
    @EventHandler(priority=EventPriority.HIGH)
    public static void onPreShopCreation(PreShopCreationEvent event) {
        String priceLine = ChestShopSign.getPrice(event.getSignLines());
        if (PriceUtil.hasBuyPrice(priceLine) && PriceUtil.hasSellPrice(priceLine)) {
            BigDecimal buyPrice = PriceUtil.getExactBuyPrice(priceLine);
            BigDecimal sellPrice = PriceUtil.getExactSellPrice(priceLine);
            if (sellPrice.compareTo(buyPrice) > 0) {
                event.setOutcome(PreShopCreationEvent.CreationOutcome.SELL_PRICE_HIGHER_THAN_BUY_PRICE);
            }
        }
    }
}

